/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class RequestInstallPackagesPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.REQUEST_INSTALL_PACKAGES";
    public static final Parcelable.Creator<RequestInstallPackagesPermission> CREATOR = new Parcelable.Creator<RequestInstallPackagesPermission>(){

        public RequestInstallPackagesPermission createFromParcel(Parcel source) {
            return new RequestInstallPackagesPermission(source);
        }

        public RequestInstallPackagesPermission[] newArray(int size) {
            return new RequestInstallPackagesPermission[size];
        }
    };

    public RequestInstallPackagesPermission() {
    }

    private RequestInstallPackagesPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 26;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid8()) {
            return true;
        }
        return context.getPackageManager().canRequestPackageInstalls();
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(6);
        if (PermissionVersion.isAndroid8()) {
            intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = RequestInstallPackagesPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = RequestInstallPackagesPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

