/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.ApplicationManifestInfo;
import com.hjq.permissions.manifest.node.MetaDataManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class WriteExternalStoragePermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.WRITE_EXTERNAL_STORAGE";
    static final String META_DATA_KEY_SCOPED_STORAGE = "ScopedStorage";
    public static final Parcelable.Creator<WriteExternalStoragePermission> CREATOR = new Parcelable.Creator<WriteExternalStoragePermission>(){

        public WriteExternalStoragePermission createFromParcel(Parcel source) {
            return new WriteExternalStoragePermission(source);
        }

        public WriteExternalStoragePermission[] newArray(int size) {
            return new WriteExternalStoragePermission[size];
        }
    };

    public WriteExternalStoragePermission() {
    }

    private WriteExternalStoragePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public String getPermissionGroup(@NonNull Context context) {
        return "storage_group";
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 23;
    }

    @Override
    protected boolean isGrantedPermissionByStandardVersion(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid11() && PermissionVersion.getTargetVersion(context) >= 30) {
            return true;
        }
        if (PermissionVersion.getTargetVersion(context) >= 29 && PermissionVersion.isAndroid10() && !Environment.isExternalStorageLegacy()) {
            return true;
        }
        return super.isGrantedPermissionByStandardVersion(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByStandardVersion(@NonNull Activity activity) {
        if (PermissionVersion.isAndroid11() && PermissionVersion.getTargetVersion((Context)activity) >= 30) {
            return false;
        }
        if (PermissionVersion.getTargetVersion((Context)activity) >= 29 && PermissionVersion.isAndroid10() && !Environment.isExternalStorageLegacy()) {
            return false;
        }
        return super.isDoNotAskAgainPermissionByStandardVersion(activity);
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return false;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        ApplicationManifestInfo applicationInfo = manifestInfo.applicationInfo;
        if (applicationInfo == null) {
            return;
        }
        if (PermissionVersion.getTargetVersion((Context)activity) < 29) {
            WriteExternalStoragePermission.checkPermissionRegistrationStatus(permissionInfoList, this.getPermissionName());
            return;
        }
        if (PermissionVersion.getTargetVersion((Context)activity) >= 30 && WriteExternalStoragePermission.findPermissionInfoByList(permissionInfoList, "android.permission.MANAGE_EXTERNAL_STORAGE") != null) {
            WriteExternalStoragePermission.checkPermissionRegistrationStatus(permissionInfoList, this.getPermissionName(), 29);
        } else {
            WriteExternalStoragePermission.checkPermissionRegistrationStatus(permissionInfoList, this.getPermissionName(), applicationInfo.requestLegacyExternalStorage ? 29 : 28);
        }
        if (PermissionUtils.containsPermission(requestList, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        int targetSdkVersion = PermissionVersion.getTargetVersion((Context)activity);
        boolean scopedStorage = false;
        if (applicationInfo.metaDataInfoList != null) {
            for (MetaDataManifestInfo metaDataManifestInfo : applicationInfo.metaDataInfoList) {
                if (!META_DATA_KEY_SCOPED_STORAGE.equals(metaDataManifestInfo.name)) continue;
                scopedStorage = Boolean.parseBoolean(metaDataManifestInfo.value);
                break;
            }
        }
        if (targetSdkVersion >= 29 && !applicationInfo.requestLegacyExternalStorage && !scopedStorage) {
            throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
        }
        if (targetSdkVersion >= 30 && !scopedStorage) {
            throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use \"android.permission.MANAGE_EXTERNAL_STORAGE\" to apply for permission");
        }
    }
}

