/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.dangerous.HealthDataBasePermission;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.List;

public final class ReadHealthDataHistoryPermission
extends HealthDataBasePermission {
    public static final String PERMISSION_NAME = "android.permission.health.READ_HEALTH_DATA_HISTORY";
    public static final Parcelable.Creator<ReadHealthDataHistoryPermission> CREATOR = new Parcelable.Creator<ReadHealthDataHistoryPermission>(){

        public ReadHealthDataHistoryPermission createFromParcel(Parcel source) {
            return new ReadHealthDataHistoryPermission(source);
        }

        public ReadHealthDataHistoryPermission[] newArray(int size) {
            return new ReadHealthDataHistoryPermission[size];
        }
    };

    public ReadHealthDataHistoryPermission() {
    }

    private ReadHealthDataHistoryPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 35;
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        super.checkSelfByRequestPermissions(activity, requestList);
        int thisPermissionIndex = -1;
        int otherHealthDataPermissionIndex = -1;
        for (int i = 0; i < requestList.size(); ++i) {
            IPermission permission2 = requestList.get(i);
            if (PermissionUtils.equalsPermission(permission2, this)) {
                thisPermissionIndex = i;
                continue;
            }
            if (!PermissionApi.isHealthPermission(permission2) || PermissionUtils.equalsPermission(permission2, "android.permission.health.READ_HEALTH_DATA_IN_BACKGROUND")) continue;
            otherHealthDataPermissionIndex = i;
        }
        if (otherHealthDataPermissionIndex != -1 && otherHealthDataPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + requestList.get(otherHealthDataPermissionIndex) + "\" permission");
        }
    }
}

