/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.hjq.device.compat.DeviceOs;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.PermissionPageType;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class GetInstalledAppsPermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "com.android.permission.GET_INSTALLED_APPS";
    private static final String MIUI_OP_GET_INSTALLED_APPS_FIELD_NAME = "OP_GET_INSTALLED_APPS";
    private static final int MIUI_OP_GET_INSTALLED_APPS_DEFAULT_VALUE = 10022;
    private static final String ONE_UI_GET_APP_LIST_PERMISSION_NAME = "com.samsung.android.permission.GET_APP_LIST";
    public static final Parcelable.Creator<GetInstalledAppsPermission> CREATOR = new Parcelable.Creator<GetInstalledAppsPermission>(){

        public GetInstalledAppsPermission createFromParcel(Parcel source) {
            return new GetInstalledAppsPermission(source);
        }

        public GetInstalledAppsPermission[] newArray(int size) {
            return new GetInstalledAppsPermission[size];
        }
    };

    public GetInstalledAppsPermission() {
    }

    private GetInstalledAppsPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    @NonNull
    public PermissionChannel getPermissionChannel(@NonNull Context context) {
        if (PermissionVersion.isAndroid6()) {
            if (this.isSupportRequestPermissionBySystem(context)) {
                return PermissionChannel.REQUEST_PERMISSIONS;
            }
            if (GetInstalledAppsPermission.isSupportRequestPermissionByOneUi(context)) {
                return PermissionChannel.START_ACTIVITY;
            }
            if (GetInstalledAppsPermission.isSupportRequestPermissionByFlyme()) {
                return PermissionChannel.START_ACTIVITY;
            }
        }
        return PermissionChannel.START_ACTIVITY;
    }

    @Override
    @NonNull
    public PermissionPageType getPermissionPageType(@NonNull Context context) {
        if (this.getPermissionChannel(context) == PermissionChannel.REQUEST_PERMISSIONS) {
            return PermissionPageType.TRANSPARENT_ACTIVITY;
        }
        return PermissionPageType.OPAQUE_ACTIVITY;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 17;
    }

    @Override
    public boolean isSupportRequestPermission(@NonNull Context context) {
        boolean superMethodSupportRequestPermission = super.isSupportRequestPermission(context);
        if (superMethodSupportRequestPermission) {
            if (PermissionVersion.isAndroid6() && (this.isSupportRequestPermissionBySystem(context) || GetInstalledAppsPermission.isSupportRequestPermissionByOneUi(context))) {
                return true;
            }
            if (PermissionVersion.isAndroid4_4() && DeviceOs.isMiui() && GetInstalledAppsPermission.isSupportRequestPermissionByMiui()) {
                return DeviceOs.isMiuiOptimization();
            }
        }
        return superMethodSupportRequestPermission;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid6()) {
            if (this.isSupportRequestPermissionBySystem(context)) {
                return GetInstalledAppsPermission.checkSelfPermission(context, this.getPermissionName());
            }
            if (GetInstalledAppsPermission.isSupportRequestPermissionByOneUi(context)) {
                return GetInstalledAppsPermission.checkSelfPermission(context, ONE_UI_GET_APP_LIST_PERMISSION_NAME);
            }
            if (GetInstalledAppsPermission.isSupportRequestPermissionByFlyme()) {
                int permissionState = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)this.getOpsNameByFlyme(context), (int)-1);
                return permissionState == 4 || permissionState == 6;
            }
        }
        if (PermissionVersion.isAndroid4_4() && GetInstalledAppsPermission.isSupportRequestPermissionByMiui()) {
            if (!DeviceOs.isMiuiOptimization()) {
                return true;
            }
            return GetInstalledAppsPermission.checkOpPermission(context, MIUI_OP_GET_INSTALLED_APPS_FIELD_NAME, 10022, true);
        }
        return true;
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity) {
        if (PermissionVersion.isAndroid6()) {
            if (this.isSupportRequestPermissionBySystem((Context)activity)) {
                return this.isDoNotAskAgainPermissionByStandardVersion(activity);
            }
            if (GetInstalledAppsPermission.isSupportRequestPermissionByOneUi((Context)activity)) {
                return false;
            }
        }
        if (PermissionVersion.isAndroid4_4() && DeviceOs.isMiui() && GetInstalledAppsPermission.isSupportRequestPermissionByMiui()) {
            if (!DeviceOs.isMiuiOptimization()) {
                return false;
            }
            return !this.isGrantedPermission((Context)activity);
        }
        return false;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>();
        if (DeviceOs.isHyperOsByChina() && DeviceOs.isHyperOsOptimization() || DeviceOs.isMiuiByChina() && DeviceOs.isMiuiOptimization()) {
            intent = PermissionSettingPage.getXiaoMiApplicationPermissionPageIntent(context);
            intentList.add(intent);
        } else if (DeviceOs.isFlyme()) {
            intent = PermissionSettingPage.getMeiZuApplicationPermissionPageIntent(context);
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = GetInstalledAppsPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = GetInstalledAppsPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        if (PermissionVersion.getTargetVersion((Context)activity) < 30) {
            return;
        }
        String queryAllPackagesPermissionName = PermissionVersion.isAndroid11() ? "android.permission.QUERY_ALL_PACKAGES" : "android.permission.QUERY_ALL_PACKAGES";
        PermissionManifestInfo permissionInfo = GetInstalledAppsPermission.findPermissionInfoByList(permissionInfoList, queryAllPackagesPermissionName);
        if (permissionInfo != null || !manifestInfo.queriesPackageList.isEmpty()) {
            return;
        }
        throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + queryAllPackagesPermissionName + "\" />, or add the app package name to the <queries> tag in the AndroidManifest.xml file");
    }

    @RequiresApi(value=23)
    private boolean isSupportRequestPermissionBySystem(Context context) {
        try {
            PermissionInfo permissionInfo = context.getPackageManager().getPermissionInfo(this.getPermissionName(), 0);
            if (permissionInfo != null) {
                int protectionLevel = PermissionVersion.isAndroid9() ? permissionInfo.getProtection() : permissionInfo.protectionLevel & 0xF;
                return protectionLevel == 1;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        try {
            return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"oem_installed_apps_runtime_permission_enable") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    @RequiresApi(value=19)
    private static boolean isSupportRequestPermissionByMiui() {
        if (!DeviceOs.isMiui()) {
            return false;
        }
        return GetInstalledAppsPermission.isExistOpPermission(MIUI_OP_GET_INSTALLED_APPS_FIELD_NAME);
    }

    @RequiresApi(value=23)
    private static boolean isSupportRequestPermissionByOneUi(@NonNull Context context) {
        if (!DeviceOs.isOneUi()) {
            return false;
        }
        try {
            PermissionInfo permissionInfo = context.getPackageManager().getPermissionInfo(ONE_UI_GET_APP_LIST_PERMISSION_NAME, 0);
            if (permissionInfo != null) {
                int protectionLevel = PermissionVersion.isAndroid9() ? permissionInfo.getProtection() : permissionInfo.protectionLevel & 0xF;
                return protectionLevel == 1;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    @RequiresApi(value=23)
    private static boolean isSupportRequestPermissionByFlyme() {
        if (!DeviceOs.isFlyme()) {
            return false;
        }
        return DeviceOs.getOsBigVersionCode() >= 9;
    }

    private String getOpsNameByFlyme(@NonNull Context context) {
        int flymePermissionId = 56;
        return context.getPackageName() + "_op_" + flymePermissionId;
    }
}

