/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.manager;

import android.app.Activity;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.HashMap;
import java.util.Map;

public final class ActivityOrientationManager {
    private static final Map<Integer, Integer> ACTIVITY_ORIENTATION_MAP = new HashMap<Integer, Integer>();

    private ActivityOrientationManager() {
    }

    public static synchronized void lockActivityOrientation(@NonNull Activity activity) {
        int sourceScreenOrientation = activity.getRequestedOrientation();
        if (sourceScreenOrientation != -1) {
            return;
        }
        try {
            switch (activity.getResources().getConfiguration().orientation) {
                case 2: {
                    int targetScreenOrientation = ActivityOrientationManager.isActivityReverse(activity) ? 8 : 0;
                    activity.setRequestedOrientation(targetScreenOrientation);
                    ACTIVITY_ORIENTATION_MAP.put(ActivityOrientationManager.getIntKeyByActivity(activity), targetScreenOrientation);
                    break;
                }
                case 1: {
                    int targetScreenOrientation = ActivityOrientationManager.isActivityReverse(activity) ? 9 : 1;
                    activity.setRequestedOrientation(targetScreenOrientation);
                    ACTIVITY_ORIENTATION_MAP.put(ActivityOrientationManager.getIntKeyByActivity(activity), targetScreenOrientation);
                    break;
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void unlockActivityOrientation(@NonNull Activity activity) {
        if (activity.getRequestedOrientation() == -1) {
            return;
        }
        Integer targetScreenOrientation = ACTIVITY_ORIENTATION_MAP.get(ActivityOrientationManager.getIntKeyByActivity(activity));
        if (targetScreenOrientation == null) {
            return;
        }
        if (targetScreenOrientation == -1) {
            return;
        }
        activity.setRequestedOrientation(-1);
    }

    private static boolean isActivityReverse(@NonNull Activity activity) {
        Display display = null;
        if (PermissionVersion.isAndroid11()) {
            display = activity.getDisplay();
        } else {
            WindowManager windowManager = activity.getWindowManager();
            if (windowManager != null) {
                display = windowManager.getDefaultDisplay();
            }
        }
        if (display == null) {
            return false;
        }
        int activityRotation = display.getRotation();
        switch (activityRotation) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static int getIntKeyByActivity(@NonNull Activity activity) {
        return activity.hashCode();
    }
}

