/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.core;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.core.OnPermissionFragmentCallback;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactory;
import com.hjq.permissions.manager.ActivityOrientationManager;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionTaskHandler;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PermissionRequestMainLogic {
    @NonNull
    private final Activity mActivity;
    @NonNull
    private final List<IPermission> mRequestList;
    @NonNull
    private final PermissionFragmentFactory<?, ?> mFragmentFactory;
    @NonNull
    private final OnPermissionInterceptor mPermissionInterceptor;
    @NonNull
    private final OnPermissionDescription mPermissionDescription;
    @Nullable
    private final OnPermissionCallback mCallBack;

    public PermissionRequestMainLogic(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, @NonNull OnPermissionInterceptor permissionInterceptor, @NonNull OnPermissionDescription permissionDescription, @Nullable OnPermissionCallback callback) {
        this.mActivity = activity;
        this.mRequestList = requestList;
        this.mFragmentFactory = fragmentFactory;
        this.mPermissionInterceptor = permissionInterceptor;
        this.mPermissionDescription = permissionDescription;
        this.mCallBack = callback;
    }

    public void request() {
        if (this.mRequestList.isEmpty()) {
            return;
        }
        List<List<IPermission>> unauthorizedList = PermissionRequestMainLogic.getUnauthorizedList(this.mActivity, this.mRequestList);
        if (unauthorizedList.isEmpty()) {
            this.handlePermissionRequestResult();
            return;
        }
        final Iterator<List<IPermission>> iterator = unauthorizedList.iterator();
        List<IPermission> firstPermissions = null;
        while (iterator.hasNext() && (firstPermissions == null || firstPermissions.isEmpty())) {
            firstPermissions = iterator.next();
        }
        if (firstPermissions == null || firstPermissions.isEmpty()) {
            this.handlePermissionRequestResult();
            return;
        }
        final Activity activity = this.mActivity;
        final PermissionFragmentFactory<?, ?> fragmentFactory = this.mFragmentFactory;
        final OnPermissionDescription permissionDescription = this.mPermissionDescription;
        ActivityOrientationManager.lockActivityOrientation(activity);
        PermissionRequestMainLogic.requestPermissionsByFragment(activity, firstPermissions, fragmentFactory, permissionDescription, new Runnable(){

            @Override
            public void run() {
                List nextPermissions = null;
                while (iterator.hasNext()) {
                    nextPermissions = (List)iterator.next();
                    if (nextPermissions == null || nextPermissions.isEmpty()) continue;
                    if (!PermissionApi.isGrantedPermissions((Context)activity, nextPermissions)) break;
                    nextPermissions = null;
                }
                if (nextPermissions == null || nextPermissions.isEmpty()) {
                    PermissionRequestMainLogic.this.postDelayedHandlerRequestPermissionsResult();
                    return;
                }
                IPermission firstNextPermission = (IPermission)nextPermissions.get(0);
                if (firstNextPermission.isBackgroundPermission((Context)activity)) {
                    List<IPermission> foregroundPermissions = firstNextPermission.getForegroundPermissions((Context)activity);
                    boolean grantedForegroundPermission = false;
                    if (foregroundPermissions != null && !foregroundPermissions.isEmpty()) {
                        for (IPermission foregroundPermission : foregroundPermissions) {
                            if (!foregroundPermission.isGrantedPermission((Context)activity)) continue;
                            grantedForegroundPermission = true;
                        }
                    } else {
                        grantedForegroundPermission = true;
                    }
                    if (!grantedForegroundPermission) {
                        this.run();
                        return;
                    }
                }
                List finalPermissions = nextPermissions;
                int maxWaitTime = PermissionApi.getMaxIntervalTimeByPermissions((Context)activity, nextPermissions);
                if (maxWaitTime == 0) {
                    PermissionRequestMainLogic.requestPermissionsByFragment(activity, finalPermissions, fragmentFactory, permissionDescription, this);
                } else {
                    PermissionTaskHandler.sendTask(() -> PermissionRequestMainLogic.requestPermissionsByFragment(activity, finalPermissions, fragmentFactory, permissionDescription, this), maxWaitTime);
                }
            }
        });
    }

    @NonNull
    private static List<List<IPermission>> getUnauthorizedList(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        ArrayList<List<IPermission>> unauthorizedList = new ArrayList<List<IPermission>>(requestList.size());
        ArrayList<IPermission> alreadyDoneList = new ArrayList<IPermission>(requestList.size());
        for (int i = 0; i < requestList.size(); ++i) {
            ArrayList<IPermission> foregroundPermissions;
            IPermission permission = requestList.get(i);
            if (PermissionUtils.containsPermission(alreadyDoneList, permission)) continue;
            alreadyDoneList.add(permission);
            if (!permission.isSupportRequestPermission((Context)activity) || permission.isGrantedPermission((Context)activity)) continue;
            if (permission.getPermissionChannel((Context)activity) == PermissionChannel.START_ACTIVITY) {
                unauthorizedList.add(PermissionUtils.asArrayList(permission));
                continue;
            }
            String permissionGroup = permission.getPermissionGroup((Context)activity);
            if (TextUtils.isEmpty((CharSequence)permissionGroup)) {
                unauthorizedList.add(PermissionUtils.asArrayList(permission));
                continue;
            }
            ArrayList<IPermission> todoPermissions = null;
            for (int j = i; j < requestList.size(); ++j) {
                IPermission todoPermission = requestList.get(j);
                if (!PermissionUtils.equalsString(todoPermission.getPermissionGroup((Context)activity), permissionGroup) || !todoPermission.isSupportRequestPermission((Context)activity) || todoPermission.isGrantedPermission((Context)activity)) continue;
                if (todoPermissions == null) {
                    todoPermissions = new ArrayList<IPermission>();
                }
                todoPermissions.add(todoPermission);
                if (PermissionUtils.containsPermission(alreadyDoneList, todoPermission)) continue;
                alreadyDoneList.add(todoPermission);
            }
            if (todoPermissions == null || todoPermissions.isEmpty() || PermissionApi.isGrantedPermissions((Context)activity, (List<IPermission>)todoPermissions)) continue;
            ArrayList<IPermission> backgroundPermissions = null;
            Iterator iterator = todoPermissions.iterator();
            while (iterator.hasNext()) {
                IPermission todoPermission = (IPermission)iterator.next();
                if (!todoPermission.isBackgroundPermission((Context)activity)) continue;
                iterator.remove();
                backgroundPermissions = new ArrayList<IPermission>();
                backgroundPermissions.add(todoPermission);
                break;
            }
            if (!(foregroundPermissions = todoPermissions).isEmpty()) {
                unauthorizedList.add(foregroundPermissions);
            }
            if (backgroundPermissions == null || backgroundPermissions.isEmpty()) continue;
            unauthorizedList.add((List<IPermission>)backgroundPermissions);
        }
        return unauthorizedList;
    }

    private static void requestPermissionsByFragment(final @NonNull Activity activity, final @NonNull List<IPermission> permissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, final @NonNull OnPermissionDescription permissionDescription, final @NonNull Runnable finishRunnable) {
        if (permissions.isEmpty()) {
            finishRunnable.run();
            return;
        }
        PermissionChannel permissionChannel = PermissionChannel.REQUEST_PERMISSIONS;
        for (IPermission permission : permissions) {
            if (permission.getPermissionChannel((Context)activity) == PermissionChannel.REQUEST_PERMISSIONS) continue;
            permissionChannel = PermissionChannel.START_ACTIVITY;
            break;
        }
        if (!PermissionVersion.isAndroid6() && permissionChannel == PermissionChannel.REQUEST_PERMISSIONS) {
            finishRunnable.run();
            return;
        }
        PermissionChannel finalPermissionChannel = permissionChannel;
        Runnable continueRequestRunnable = () -> fragmentFactory.createAndCommitFragment(permissions, finalPermissionChannel, new OnPermissionFragmentCallback(){

            @Override
            public void onRequestPermissionNow() {
                permissionDescription.onRequestPermissionStart(activity, permissions);
            }

            @Override
            public void onRequestPermissionFinish() {
                permissionDescription.onRequestPermissionEnd(activity, permissions);
                finishRunnable.run();
            }

            @Override
            public void onRequestPermissionAnomaly() {
                permissionDescription.onRequestPermissionEnd(activity, permissions);
            }
        });
        permissionDescription.askWhetherRequestPermission(activity, permissions, continueRequestRunnable, finishRunnable);
    }

    private void postDelayedHandlerRequestPermissionsResult() {
        PermissionTaskHandler.sendTask(this::handlePermissionRequestResult, 100L);
    }

    private void postDelayedUnlockActivityOrientation(@NonNull Activity activity) {
        PermissionTaskHandler.sendTask(() -> ActivityOrientationManager.unlockActivityOrientation(activity), 100L);
    }

    private void handlePermissionRequestResult() {
        Activity activity = this.mActivity;
        List<IPermission> requestList = this.mRequestList;
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        ArrayList<IPermission> grantedList = new ArrayList<IPermission>(requestList.size());
        ArrayList<IPermission> deniedList = new ArrayList<IPermission>(requestList.size());
        for (IPermission permission : requestList) {
            if (permission.isGrantedPermission((Context)activity, false)) {
                grantedList.add(permission);
                continue;
            }
            deniedList.add(permission);
        }
        this.mPermissionInterceptor.onRequestPermissionEnd(activity, false, requestList, grantedList, deniedList, this.mCallBack);
        this.postDelayedUnlockActivityOrientation(activity);
    }
}

