/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.hjq.permissions.DefaultPermissionDescription;
import com.hjq.permissions.DefaultPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactory;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactoryByAndroid;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactoryByAndroidX;
import com.hjq.permissions.manifest.AndroidManifestParser;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.start.StartActivityAgent;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionChecker;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static Class<? extends OnPermissionInterceptor> sPermissionInterceptorClass;
    private static Class<? extends OnPermissionDescription> sPermissionDescriptionClass;
    private static Boolean sCheckMode;
    @NonNull
    private final List<IPermission> mRequestList = new ArrayList<IPermission>();
    @Nullable
    private final Context mContext;
    @Nullable
    private Fragment mFragment;
    @Nullable
    private androidx.fragment.app.Fragment mXFragment;
    @Nullable
    private OnPermissionInterceptor mPermissionInterceptor;
    @Nullable
    private OnPermissionDescription mPermissionDescription;
    @Nullable
    private Boolean mCheckMode;

    public static XXPermissions with(@NonNull Context context) {
        return new XXPermissions(context);
    }

    public static XXPermissions with(@NonNull Fragment fragment) {
        return new XXPermissions(fragment);
    }

    public static XXPermissions with(@NonNull androidx.fragment.app.Fragment xFragment) {
        return new XXPermissions(xFragment);
    }

    public static void setCheckMode(boolean checkMode) {
        sCheckMode = checkMode;
    }

    public static void setPermissionInterceptor(Class<? extends OnPermissionInterceptor> clazz) {
        sPermissionInterceptorClass = clazz;
    }

    @NonNull
    public static OnPermissionInterceptor getPermissionInterceptor() {
        if (sPermissionInterceptorClass != null) {
            try {
                return sPermissionInterceptorClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DefaultPermissionInterceptor();
    }

    public static void setPermissionDescription(Class<? extends OnPermissionDescription> clazz) {
        sPermissionDescriptionClass = clazz;
    }

    @NonNull
    public static OnPermissionDescription getPermissionDescription() {
        if (sPermissionDescriptionClass != null) {
            try {
                return sPermissionDescriptionClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DefaultPermissionDescription();
    }

    private XXPermissions(@NonNull Context context) {
        this.mContext = context;
    }

    private XXPermissions(@NonNull Fragment fragment) {
        this.mFragment = fragment;
        this.mContext = fragment.getActivity();
    }

    private XXPermissions(@NonNull androidx.fragment.app.Fragment xFragment) {
        this.mXFragment = xFragment;
        this.mContext = xFragment.getActivity();
    }

    public XXPermissions permission(@NonNull IPermission permission) {
        this.mRequestList.remove(permission);
        this.mRequestList.add(permission);
        return this;
    }

    public XXPermissions permissions(@NonNull List<IPermission> permissions) {
        if (permissions.isEmpty()) {
            return this;
        }
        for (int i = 0; i < permissions.size(); ++i) {
            this.permission(permissions.get(i));
        }
        return this;
    }

    public XXPermissions permissions(@NonNull IPermission[] permissions) {
        return this.permissions(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions interceptor(@Nullable OnPermissionInterceptor permissionInterceptor) {
        this.mPermissionInterceptor = permissionInterceptor;
        return this;
    }

    public XXPermissions description(@Nullable OnPermissionDescription permissionDescription) {
        this.mPermissionDescription = permissionDescription;
        return this;
    }

    public XXPermissions unchecked() {
        this.mCheckMode = false;
        return this;
    }

    public void request(@Nullable OnPermissionCallback callback) {
        PermissionFragmentFactory<?, ?> fragmentFactory;
        if (this.mContext == null) {
            return;
        }
        if (this.mPermissionInterceptor == null) {
            this.mPermissionInterceptor = XXPermissions.getPermissionInterceptor();
        }
        if (this.mPermissionDescription == null) {
            this.mPermissionDescription = XXPermissions.getPermissionDescription();
        }
        Context context = this.mContext;
        Fragment fragment = this.mFragment;
        androidx.fragment.app.Fragment xFragment = this.mXFragment;
        OnPermissionInterceptor permissionInterceptor = this.mPermissionInterceptor;
        OnPermissionDescription permissionDescription = this.mPermissionDescription;
        ArrayList<IPermission> requestList = new ArrayList<IPermission>(this.mRequestList);
        Activity activity = PermissionUtils.findActivity(context);
        if (this.isCheckMode(context)) {
            PermissionChecker.checkActivityStatus(activity);
            if (fragment != null) {
                PermissionChecker.checkAndroidFragmentStatus(fragment);
            } else if (xFragment != null) {
                PermissionChecker.checkAndroidXFragmentStatus(xFragment);
            }
            PermissionChecker.checkPermissionList(activity, requestList, AndroidManifestParser.getAndroidManifestInfo(context));
        }
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        PermissionApi.addOldPermissionsByNewPermissions((Context)activity, requestList);
        if (PermissionApi.isGrantedPermissions(context, requestList)) {
            permissionInterceptor.onRequestPermissionEnd(activity, true, requestList, requestList, new ArrayList<IPermission>(), callback);
            return;
        }
        if (xFragment != null) {
            if (PermissionUtils.isFragmentUnavailable(xFragment)) {
                return;
            }
            fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, xFragment);
        } else if (fragment != null) {
            if (PermissionUtils.isFragmentUnavailable(fragment)) {
                return;
            }
            fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, fragment);
        } else {
            fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity);
        }
        permissionInterceptor.onRequestPermissionStart(activity, requestList, fragmentFactory, permissionDescription, callback);
    }

    private boolean isCheckMode(@NonNull Context context) {
        if (this.mCheckMode == null) {
            if (sCheckMode == null) {
                sCheckMode = PermissionUtils.isDebugMode(context);
            }
            this.mCheckMode = sCheckMode;
        }
        return this.mCheckMode;
    }

    public static boolean isGrantedPermission(@NonNull Context context, @NonNull IPermission permission) {
        return permission.isGrantedPermission(context);
    }

    public static boolean isGrantedPermissions(@NonNull Context context, @NonNull IPermission[] permissions) {
        return XXPermissions.isGrantedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        return PermissionApi.isGrantedPermissions(context, permissions);
    }

    public static List<IPermission> getGrantedPermissions(@NonNull Context context, @NonNull IPermission[] permissions) {
        return XXPermissions.getGrantedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<IPermission> getGrantedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        return PermissionApi.getGrantedPermissions(context, permissions);
    }

    public static List<IPermission> getDeniedPermissions(@NonNull Context context, @NonNull IPermission[] permissions) {
        return XXPermissions.getDeniedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<IPermission> getDeniedPermissions(@NonNull Context context, @NonNull List<IPermission> permissions) {
        return PermissionApi.getDeniedPermissions(context, permissions);
    }

    public static boolean equalsPermission(@NonNull IPermission permission1, @NonNull IPermission permission2) {
        return PermissionUtils.equalsPermission(permission1, permission2);
    }

    public static boolean equalsPermission(@NonNull IPermission permission1, @NonNull String permission2) {
        return PermissionUtils.equalsPermission(permission1, permission2);
    }

    public static boolean equalsPermission(@NonNull String permissionName1, @NonNull String permission2) {
        return PermissionUtils.equalsPermission(permissionName1, permission2);
    }

    public static boolean containsPermission(@NonNull List<IPermission> permissions, @NonNull IPermission permission) {
        return PermissionUtils.containsPermission(permissions, permission);
    }

    public static boolean containsPermission(@NonNull List<IPermission> permissions, @NonNull String permissionName) {
        return PermissionUtils.containsPermission(permissions, permissionName);
    }

    public static boolean isHealthPermission(@NonNull IPermission permission) {
        return PermissionApi.isHealthPermission(permission);
    }

    public static boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull IPermission permission) {
        return permission.isDoNotAskAgainPermission(activity);
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull IPermission[] permissions) {
        return XXPermissions.isDoNotAskAgainPermissions(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull List<IPermission> permissions) {
        return PermissionApi.isDoNotAskAgainPermissions(activity, permissions);
    }

    public static void startPermissionActivity(@NonNull Context context) {
        XXPermissions.startPermissionActivity(context, new ArrayList<IPermission>(0));
    }

    public static void startPermissionActivity(@NonNull Context context, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Context context, @NonNull List<IPermission> permissions) {
        Activity activity = PermissionUtils.findActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity(activity, permissions);
            return;
        }
        StartActivityAgent.startActivity(context, PermissionApi.getBestPermissionSettingIntent(context, permissions, true));
    }

    public static void startPermissionActivity(@NonNull Activity activity) {
        XXPermissions.startPermissionActivity(activity, new ArrayList<IPermission>(0));
    }

    public static void startPermissionActivity(@NonNull Activity activity, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<IPermission> permissions) {
        XXPermissions.startPermissionActivity(activity, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        StartActivityAgent.startActivityForResult(activity, PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions, true), requestCode);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull IPermission permission, @Nullable OnPermissionCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission), callback);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<IPermission> permissions, @Nullable OnPermissionCallback callback) {
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(activity, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity);
        fragmentFactory.createAndCommitFragment(permissions, PermissionChannel.START_ACTIVITY, () -> {
            if (PermissionUtils.isActivityUnavailable(activity)) {
                return;
            }
            XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
        });
    }

    public static void startPermissionActivity(@NonNull Fragment fragment) {
        XXPermissions.startPermissionActivity(fragment, new ArrayList<IPermission>(0));
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull List<IPermission> permissions) {
        XXPermissions.startPermissionActivity(fragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        if (PermissionUtils.isFragmentUnavailable(fragment)) {
            return;
        }
        Activity activity = fragment.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(fragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(fragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        StartActivityAgent.startActivityForResult(fragment, PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions, true), requestCode);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull IPermission permission, @Nullable OnPermissionCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permission), callback);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull List<IPermission> permissions, @Nullable OnPermissionCallback callback) {
        if (PermissionUtils.isFragmentUnavailable(fragment)) {
            return;
        }
        Activity activity = fragment.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(fragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(fragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, fragment);
        fragmentFactory.createAndCommitFragment(permissions, PermissionChannel.START_ACTIVITY, () -> {
            if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(fragment)) {
                return;
            }
            XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
        });
    }

    public static void startPermissionActivity(@NonNull androidx.fragment.app.Fragment xFragment) {
        XXPermissions.startPermissionActivity(xFragment, new ArrayList<IPermission>());
    }

    public static void startPermissionActivity(@NonNull androidx.fragment.app.Fragment xFragment, IPermission ... permissions) {
        XXPermissions.startPermissionActivity(xFragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull androidx.fragment.app.Fragment xFragment, @NonNull List<IPermission> permissions) {
        XXPermissions.startPermissionActivity(xFragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull androidx.fragment.app.Fragment xFragment, @NonNull List<IPermission> permissions, @IntRange(from=1L, to=65535L) int requestCode) {
        if (PermissionUtils.isFragmentUnavailable(xFragment)) {
            return;
        }
        FragmentActivity activity = xFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable((Activity)activity) || PermissionUtils.isFragmentUnavailable(xFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(xFragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        StartActivityAgent.startActivityForResult(xFragment, PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions, true), requestCode);
    }

    public static void startPermissionActivity(@NonNull androidx.fragment.app.Fragment xFragment, @NonNull IPermission permission, @Nullable OnPermissionCallback callback) {
        XXPermissions.startPermissionActivity(xFragment, PermissionUtils.asArrayList(permission), callback);
    }

    public static void startPermissionActivity(@NonNull androidx.fragment.app.Fragment xFragment, @NonNull List<IPermission> permissions, @Nullable OnPermissionCallback callback) {
        if (PermissionUtils.isFragmentUnavailable(xFragment)) {
            return;
        }
        FragmentActivity activity = xFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable((Activity)activity) || PermissionUtils.isFragmentUnavailable(xFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            StartActivityAgent.startActivity(xFragment, PermissionSettingPage.getCommonPermissionSettingIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory((Activity)activity, xFragment);
        fragmentFactory.createAndCommitFragment(permissions, PermissionChannel.START_ACTIVITY, () -> XXPermissions.lambda$startPermissionActivity$2((Activity)activity, xFragment, permissions, callback));
    }

    @NonNull
    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity) {
        return XXPermissions.generatePermissionFragmentFactory(activity, null, null);
    }

    @NonNull
    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable androidx.fragment.app.Fragment xFragment) {
        return XXPermissions.generatePermissionFragmentFactory(activity, xFragment, null);
    }

    @NonNull
    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable Fragment fragment) {
        return XXPermissions.generatePermissionFragmentFactory(activity, null, fragment);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable androidx.fragment.app.Fragment xFragment, @Nullable Fragment fragment) {
        PermissionFragmentFactory fragmentFactory;
        if (xFragment != null) {
            fragmentFactory = new PermissionFragmentFactoryByAndroidX(xFragment.getActivity(), xFragment.getChildFragmentManager());
        } else if (fragment != null) {
            fragmentFactory = new PermissionFragmentFactoryByAndroid(fragment.getActivity(), fragment.getChildFragmentManager());
        } else if (activity instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)activity;
            fragmentFactory = new PermissionFragmentFactoryByAndroidX(fragmentActivity, fragmentActivity.getSupportFragmentManager());
        } else {
            fragmentFactory = new PermissionFragmentFactoryByAndroid(activity, activity.getFragmentManager());
        }
        return fragmentFactory;
    }

    private static void dispatchPermissionPageCallback(@NonNull Context context, @NonNull List<IPermission> permissions, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        ArrayList<IPermission> grantedList = new ArrayList<IPermission>(permissions.size());
        ArrayList<IPermission> deniedList = new ArrayList<IPermission>(permissions.size());
        for (IPermission permission : permissions) {
            if (permission.isGrantedPermission(context, false)) {
                grantedList.add(permission);
                continue;
            }
            deniedList.add(permission);
        }
        callback.onResult(grantedList, deniedList);
    }

    private static /* synthetic */ void lambda$startPermissionActivity$2(Activity activity, androidx.fragment.app.Fragment xFragment, List permissions, OnPermissionCallback callback) {
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(xFragment)) {
            return;
        }
        XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
    }
}

