/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class WriteSettingsPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.WRITE_SETTINGS";
    public static final Parcelable.Creator<WriteSettingsPermission> CREATOR = new Parcelable.Creator<WriteSettingsPermission>(){

        public WriteSettingsPermission createFromParcel(Parcel source) {
            return new WriteSettingsPermission(source);
        }

        public WriteSettingsPermission[] newArray(int size) {
            return new WriteSettingsPermission[size];
        }
    };

    public WriteSettingsPermission() {
    }

    private WriteSettingsPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 23;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid6()) {
            return true;
        }
        return Settings.System.canWrite((Context)context);
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(6);
        if (PermissionVersion.isAndroid6()) {
            intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = WriteSettingsPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = WriteSettingsPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

