/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.ApplicationManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class ManageExternalStoragePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.MANAGE_EXTERNAL_STORAGE";
    public static final Parcelable.Creator<ManageExternalStoragePermission> CREATOR = new Parcelable.Creator<ManageExternalStoragePermission>(){

        public ManageExternalStoragePermission createFromParcel(Parcel source) {
            return new ManageExternalStoragePermission(source);
        }

        public ManageExternalStoragePermission[] newArray(int size) {
            return new ManageExternalStoragePermission[size];
        }
    };

    public ManageExternalStoragePermission() {
    }

    private ManageExternalStoragePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 30;
    }

    @Override
    @NonNull
    public List<IPermission> getOldPermissions(Context context) {
        return PermissionUtils.asArrayList(PermissionLists.getReadExternalStoragePermission(), PermissionLists.getWriteExternalStoragePermission());
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid11()) {
            if (PermissionVersion.isAndroid10() && !Environment.isExternalStorageLegacy()) {
                return false;
            }
            return PermissionLists.getReadExternalStoragePermission().isGrantedPermission(context, skipRequest) && PermissionLists.getWriteExternalStoragePermission().isGrantedPermission(context, skipRequest);
        }
        return Environment.isExternalStorageManager();
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(3);
        if (PermissionVersion.isAndroid11()) {
            intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION");
            intentList.add(intent);
        }
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        if (this.getFromAndroidVersion((Context)activity) > ManageExternalStoragePermission.getMinSdkVersion((Context)activity, manifestInfo)) {
            ManageExternalStoragePermission.checkPermissionRegistrationStatus(permissionInfoList, "android.permission.READ_EXTERNAL_STORAGE", 29);
            ManageExternalStoragePermission.checkPermissionRegistrationStatus(permissionInfoList, "android.permission.WRITE_EXTERNAL_STORAGE", 29);
        }
        if (PermissionUtils.containsPermission(requestList, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        ApplicationManifestInfo applicationInfo = manifestInfo.applicationInfo;
        if (applicationInfo == null) {
            return;
        }
        if (PermissionVersion.getTargetVersion((Context)activity) >= 29 && !applicationInfo.requestLegacyExternalStorage) {
            throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
        }
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        super.checkSelfByRequestPermissions(activity, requestList);
        if (PermissionUtils.containsPermission(requestList, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestList, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("If you have applied for \"" + this.getPermissionName() + "\" permissions, do not apply for the \"" + "android.permission.READ_EXTERNAL_STORAGE" + "\" or \"" + "android.permission.WRITE_EXTERNAL_STORAGE" + "\" permissions");
        }
        if (PermissionUtils.containsPermission(requestList, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestList, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestList, "android.permission.READ_MEDIA_AUDIO")) {
            throw new IllegalArgumentException("Because the \"" + this.getPermissionName() + "\" permission range is very large, you can read media files with it, and there is no need to apply for additional media permissions.");
        }
    }
}

