/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import com.hjq.device.compat.DeviceOs;
import com.hjq.permissions.permission.PermissionPageType;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class RequestIgnoreBatteryOptimizationsPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS";
    public static final Parcelable.Creator<RequestIgnoreBatteryOptimizationsPermission> CREATOR = new Parcelable.Creator<RequestIgnoreBatteryOptimizationsPermission>(){

        public RequestIgnoreBatteryOptimizationsPermission createFromParcel(Parcel source) {
            return new RequestIgnoreBatteryOptimizationsPermission(source);
        }

        public RequestIgnoreBatteryOptimizationsPermission[] newArray(int size) {
            return new RequestIgnoreBatteryOptimizationsPermission[size];
        }
    };

    public RequestIgnoreBatteryOptimizationsPermission() {
    }

    private RequestIgnoreBatteryOptimizationsPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    @SuppressLint(value={"BatteryLife"})
    @NonNull
    public PermissionPageType getPermissionPageType(@NonNull Context context) {
        if (PermissionVersion.isAndroid11() && (DeviceOs.isHyperOs() || DeviceOs.isMiui())) {
            return PermissionPageType.OPAQUE_ACTIVITY;
        }
        if (DeviceOs.isColorOs() && PermissionVersion.isAndroid15()) {
            return PermissionPageType.OPAQUE_ACTIVITY;
        }
        if (PermissionVersion.isAndroid6() && !this.isGrantedPermission(context)) {
            Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
            intent.setData(this.getPackageNameUri(context));
            if (PermissionUtils.areActivityIntent(context, intent)) {
                return PermissionPageType.TRANSPARENT_ACTIVITY;
            }
        }
        return PermissionPageType.OPAQUE_ACTIVITY;
    }

    @Override
    public int getFromAndroidVersion() {
        return 23;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid6()) {
            return true;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService(PowerManager.class);
        if (powerManager == null) {
            return false;
        }
        return powerManager.isIgnoringBatteryOptimizations(context.getPackageName());
    }

    @Override
    @SuppressLint(value={"BatteryLife"})
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(7);
        Intent requestIgnoreBatteryOptimizationsIntent = null;
        if (PermissionVersion.isAndroid6()) {
            requestIgnoreBatteryOptimizationsIntent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
            requestIgnoreBatteryOptimizationsIntent.setData(this.getPackageNameUri(context));
            if (this.isGrantedPermission(context, skipRequest) && !DeviceOs.isHyperOs()) {
                requestIgnoreBatteryOptimizationsIntent = null;
            }
        }
        Intent advancedPowerUsageDetailIntent = null;
        if (PermissionVersion.isAndroid12()) {
            advancedPowerUsageDetailIntent = new Intent("android.settings.VIEW_ADVANCED_POWER_USAGE_DETAIL");
            advancedPowerUsageDetailIntent.setData(this.getPackageNameUri(context));
        }
        Intent ignoreBatteryOptimizationSettingsIntent = null;
        if (PermissionVersion.isAndroid6()) {
            ignoreBatteryOptimizationSettingsIntent = new Intent("android.settings.IGNORE_BATTERY_OPTIMIZATION_SETTINGS");
        }
        if (skipRequest && (!PermissionVersion.isAndroid11() || !DeviceOs.isHyperOs() && !DeviceOs.isMiui())) {
            if (advancedPowerUsageDetailIntent != null) {
                intentList.add(advancedPowerUsageDetailIntent);
            }
            if (ignoreBatteryOptimizationSettingsIntent != null) {
                intentList.add(ignoreBatteryOptimizationSettingsIntent);
            }
            if (requestIgnoreBatteryOptimizationsIntent != null) {
                intentList.add(requestIgnoreBatteryOptimizationsIntent);
            }
        } else {
            if (requestIgnoreBatteryOptimizationsIntent != null) {
                intentList.add(requestIgnoreBatteryOptimizationsIntent);
            }
            if (advancedPowerUsageDetailIntent != null) {
                intentList.add(advancedPowerUsageDetailIntent);
            }
            if (ignoreBatteryOptimizationSettingsIntent != null) {
                intentList.add(ignoreBatteryOptimizationSettingsIntent);
            }
        }
        if (DeviceOs.isHyperOs() || DeviceOs.isMiui()) {
            intent = this.getApplicationDetailsSettingIntent(context);
            intentList.add(intent);
            intent = RequestIgnoreBatteryOptimizationsPermission.getManageApplicationSettingIntent();
            intentList.add(intent);
            intent = RequestIgnoreBatteryOptimizationsPermission.getApplicationSettingIntent();
            intentList.add(intent);
        }
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    public int getResultWaitTime(@NonNull Context context) {
        if (!this.isSupportRequestPermission(context)) {
            return 0;
        }
        int xiaomiPhoneDefaultWaitTime = 1000;
        if (DeviceOs.isHyperOs()) {
            if (PermissionVersion.isAndroid15()) {
                return super.getResultWaitTime(context);
            }
            if (PermissionVersion.isAndroid14()) {
                int osBigVersionCode = DeviceOs.getOsBigVersionCode();
                if (osBigVersionCode < 2) {
                    return 1000;
                }
                return super.getResultWaitTime(context);
            }
            return 1000;
        }
        if (DeviceOs.isMiui() && PermissionVersion.isAndroid11()) {
            return 1000;
        }
        return super.getResultWaitTime(context);
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

