/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.dangerous.HealthDataBasePermission;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class ReadHealthDataInBackgroundPermission
extends HealthDataBasePermission {
    public static final String PERMISSION_NAME = "android.permission.health.READ_HEALTH_DATA_IN_BACKGROUND";
    public static final Parcelable.Creator<ReadHealthDataInBackgroundPermission> CREATOR = new Parcelable.Creator<ReadHealthDataInBackgroundPermission>(){

        public ReadHealthDataInBackgroundPermission createFromParcel(Parcel source) {
            return new ReadHealthDataInBackgroundPermission(source);
        }

        public ReadHealthDataInBackgroundPermission[] newArray(int size) {
            return new ReadHealthDataInBackgroundPermission[size];
        }
    };

    public ReadHealthDataInBackgroundPermission() {
    }

    private ReadHealthDataInBackgroundPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 35;
    }

    @Override
    @Nullable
    public List<IPermission> getOldPermissions(Context context) {
        if (!PermissionVersion.isAndroid14()) {
            return PermissionUtils.asArrayList(PermissionLists.getBodySensorsBackgroundPermission());
        }
        return null;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        if (this.getFromAndroidVersion() > ReadHealthDataInBackgroundPermission.getMinSdkVersion((Context)activity, manifestInfo)) {
            ReadHealthDataInBackgroundPermission.checkPermissionRegistrationStatus(permissionInfoList, "android.permission.BODY_SENSORS_BACKGROUND", 34);
        }
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        super.checkSelfByRequestPermissions(activity, requestList);
        int thisPermissionIndex = -1;
        int readHealthDataHistoryPermissionIndex = -1;
        int otherHealthDataPermissionIndex = -1;
        for (int i = 0; i < requestList.size(); ++i) {
            IPermission permission2 = requestList.get(i);
            if (PermissionUtils.equalsPermission(permission2, this)) {
                thisPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.health.READ_HEALTH_DATA_HISTORY")) {
                readHealthDataHistoryPermissionIndex = i;
                continue;
            }
            if (!PermissionApi.isHealthPermission(permission2)) continue;
            otherHealthDataPermissionIndex = i;
        }
        if (readHealthDataHistoryPermissionIndex != -1 && readHealthDataHistoryPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the " + this.getPermissionName() + "\" permission after the \"" + "android.permission.health.READ_HEALTH_DATA_HISTORY" + "\" permission");
        }
        if (otherHealthDataPermissionIndex != -1 && otherHealthDataPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + requestList.get(otherHealthDataPermissionIndex) + "\" permission");
        }
    }
}

