/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.tools;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PhoneRomUtils {
    private static final String[] ROM_HUAWEI = new String[]{"huawei"};
    private static final String[] ROM_VIVO = new String[]{"vivo"};
    private static final String[] ROM_XIAOMI = new String[]{"xiaomi"};
    private static final String[] ROM_OPPO = new String[]{"oppo"};
    private static final String[] ROM_LEECO = new String[]{"leeco", "letv"};
    private static final String[] ROM_360 = new String[]{"360", "qiku"};
    private static final String[] ROM_ZTE = new String[]{"zte"};
    private static final String[] ROM_ONEPLUS = new String[]{"oneplus"};
    private static final String[] ROM_NUBIA = new String[]{"nubia"};
    private static final String[] ROM_SAMSUNG = new String[]{"samsung"};
    private static final String[] ROM_HONOR = new String[]{"honor"};
    private static final String[] ROM_SMARTISAN = new String[]{"smartisan"};
    private static final String ROM_NAME_MIUI = "ro.miui.ui.version.name";
    private static final String ROM_NAME_HYPER_OS = "ro.mi.os.version.name";
    private static final String VERSION_PROPERTY_HUAWEI = "ro.build.version.emui";
    private static final String VERSION_PROPERTY_VIVO = "ro.vivo.os.build.display.id";
    private static final String[] VERSION_PROPERTY_XIAOMI = new String[]{"ro.mi.os.version.incremental", "ro.build.version.incremental"};
    private static final String[] VERSION_PROPERTY_OPPO = new String[]{"ro.build.version.opporom", "ro.build.version.oplusrom.display"};
    private static final String VERSION_PROPERTY_LEECO = "ro.letv.release.version";
    private static final String VERSION_PROPERTY_360 = "ro.build.uiversion";
    private static final String VERSION_PROPERTY_ZTE = "ro.build.MiFavor_version";
    private static final String VERSION_PROPERTY_ONEPLUS = "ro.rom.version";
    private static final String VERSION_PROPERTY_NUBIA = "ro.build.rom.id";
    private static final String[] VERSION_PROPERTY_MAGIC = new String[]{"msc.config.magic.version", "ro.build.version.magic"};

    private PhoneRomUtils() {
    }

    public static boolean isEmui() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_HUAWEI));
    }

    public static boolean isHyperOs() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(ROM_NAME_HYPER_OS));
    }

    public static boolean isMiui() {
        if (PhoneRomUtils.isHyperOs()) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(ROM_NAME_MIUI));
    }

    public static boolean isColorOs() {
        for (String property : VERSION_PROPERTY_OPPO) {
            String versionName = PermissionUtils.getSystemPropertyValue(property);
            if (TextUtils.isEmpty((CharSequence)versionName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOriginOs() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_VIVO));
    }

    @SuppressLint(value={"PrivateApi"})
    public static boolean isOneUi() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_SAMSUNG);
    }

    public static boolean isHarmonyOs() {
        if (!PermissionVersion.isAndroid10()) {
            return false;
        }
        try {
            Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
            Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
            return "Harmony".equalsIgnoreCase(String.valueOf(osBrand));
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean isMagicOs() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_HONOR);
    }

    public static boolean isSmartisanOS() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_SMARTISAN);
    }

    @SuppressLint(value={"PrivateApi"})
    public static boolean isXiaomiSystemOptimization() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getMethod = clazz.getMethod("get", String.class, String.class);
            String ctsValue = String.valueOf(getMethod.invoke(clazz, "ro.miui.cts", ""));
            Method getBooleanMethod = clazz.getMethod("getBoolean", String.class, Boolean.TYPE);
            return Boolean.parseBoolean(String.valueOf(getBooleanMethod.invoke(clazz, "persist.sys.miui_optimization", !"1".equals(ctsValue))));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static int getRomBigVersionCode() {
        String romVersionName = PhoneRomUtils.getRomVersionName();
        if (romVersionName == null) {
            return 0;
        }
        String[] array = romVersionName.split("\\.");
        if (array.length == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(array[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Nullable
    public static String getRomVersionName() {
        String originalRomVersionName = PhoneRomUtils.getOriginalRomVersionName();
        if (TextUtils.isEmpty((CharSequence)originalRomVersionName)) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+(?:\\.\\d+)+)");
        Matcher matcher = pattern.matcher(originalRomVersionName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    public static String getOriginalRomVersionName() {
        String manufacturer;
        String brand = PhoneRomUtils.getBrand();
        if (PhoneRomUtils.isRightRom(brand, manufacturer = PhoneRomUtils.getManufacturer(), ROM_HUAWEI)) {
            String version = PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_HUAWEI);
            String[] temp = version.split("_");
            if (temp.length > 1) {
                return temp[1];
            }
            if (version.contains("EmotionUI")) {
                return version.replaceFirst("EmotionUI\\s*", "");
            }
            return version;
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_VIVO)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_VIVO);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_XIAOMI)) {
            for (String property : VERSION_PROPERTY_XIAOMI) {
                String versionName = PermissionUtils.getSystemPropertyValue(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_OPPO)) {
            for (String property : VERSION_PROPERTY_OPPO) {
                String versionName = PermissionUtils.getSystemPropertyValue(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_LEECO)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_LEECO);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_360)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_360);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_ZTE)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_ZTE);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_ONEPLUS)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_ONEPLUS);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_NUBIA)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_NUBIA);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_HONOR)) {
            for (String property : VERSION_PROPERTY_MAGIC) {
                String versionName = PermissionUtils.getSystemPropertyValue(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        return PermissionUtils.getSystemPropertyValue("");
    }

    private static boolean isRightRom(String brand, String manufacturer, String ... names) {
        for (String name : names) {
            if (!brand.contains(name) && !manufacturer.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static String getBrand() {
        return Build.BRAND.toLowerCase();
    }

    private static String getManufacturer() {
        return Build.MANUFACTURER.toLowerCase();
    }
}

