/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.tools;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public final class PermissionUtils {
    public static boolean isDebugMode(@NonNull Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    @NonNull
    public static <T> ArrayList<T> asArrayList(T ... array) {
        int initialCapacity = 0;
        if (array != null) {
            initialCapacity = array.length;
        }
        ArrayList<T> list = new ArrayList<T>(initialCapacity);
        if (array == null || array.length == 0) {
            return list;
        }
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    @Nullable
    public static Activity findActivity(@Nullable Context context) {
        do {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }

    public static boolean isActivityUnavailable(@Nullable Activity activity) {
        return activity == null || activity.isDestroyed() || activity.isFinishing();
    }

    public static boolean isFragmentUnavailable(@Nullable android.support.v4.app.Fragment supportFragment) {
        return supportFragment == null || !supportFragment.isAdded() || supportFragment.isRemoving();
    }

    public static boolean isFragmentUnavailable(@Nullable Fragment appFragment) {
        return appFragment == null || !appFragment.isAdded() || appFragment.isRemoving();
    }

    public static boolean getBooleanByMetaData(@NonNull Context context, @NonNull String metaKey, boolean defaultValue) {
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return metaData.getBoolean(metaKey);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static boolean areActivityIntent(@NonNull Context context, @Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        if (PermissionVersion.isAndroid13()) {
            return !packageManager.queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of((long)65536L)).isEmpty();
        }
        return !packageManager.queryIntentActivities(intent, 65536).isEmpty();
    }

    public static boolean equalsString(@Nullable String s1, @Nullable String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.hashCode() == s2.hashCode()) {
            return true;
        }
        int length = s1.length();
        if (length != s2.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean reverseEqualsString(@Nullable String s1, @Nullable String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.hashCode() == s2.hashCode()) {
            return true;
        }
        int length = s1.length();
        if (length != s2.length()) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsPermission(@NonNull String permission1, @NonNull String permission2) {
        return PermissionUtils.reverseEqualsString(permission1, permission2);
    }

    public static boolean equalsPermission(@NonNull IPermission permission1, @NonNull String permission2) {
        return PermissionUtils.reverseEqualsString(permission1.getPermissionName(), permission2);
    }

    public static boolean equalsPermission(@NonNull IPermission permission1, @NonNull IPermission permission2) {
        return PermissionUtils.reverseEqualsString(permission1.getPermissionName(), permission2.getPermissionName());
    }

    public static boolean containsPermission(@NonNull Collection<IPermission> permissions, @NonNull IPermission permission2) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (IPermission item : permissions) {
            if (!PermissionUtils.equalsPermission(permission2, item.getPermissionName())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPermission(@NonNull List<String> permissions, @NonNull String permission2) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (String item : permissions) {
            if (!PermissionUtils.equalsPermission(permission2, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPermission(@NonNull Collection<IPermission> permissions, @NonNull String permissionName) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (IPermission item : permissions) {
            if (!PermissionUtils.equalsPermission(item.getPermissionName(), permissionName)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static List<String> convertPermissionList(@Nullable List<IPermission> permissions) {
        ArrayList<String> list = new ArrayList<String>();
        if (permissions == null || permissions.isEmpty()) {
            return list;
        }
        for (IPermission permission2 : permissions) {
            list.add(permission2.getPermissionName());
        }
        return list;
    }

    @NonNull
    public static List<String> convertPermissionList(@Nullable IPermission[] permissions) {
        ArrayList<String> list = new ArrayList<String>();
        if (permissions == null) {
            return list;
        }
        for (IPermission permission2 : permissions) {
            list.add(permission2.getPermissionName());
        }
        return list;
    }

    @NonNull
    public static String[] convertPermissionArray(@Nullable List<IPermission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return new String[0];
        }
        String[] list = new String[permissions.size()];
        for (int i = 0; i < permissions.size(); ++i) {
            list[i] = permissions.get(i).getPermissionName();
        }
        return list;
    }

    public static Uri getPackageNameUri(@NonNull Context context) {
        return Uri.parse((String)("package:" + context.getPackageName()));
    }

    public static boolean isClassExist(@Nullable String className) {
        if (className == null) {
            return false;
        }
        if (className.isEmpty()) {
            return false;
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean equalsIntentList(@NonNull List<Intent> intentList1, @NonNull List<Intent> intentList2) {
        if (intentList1.size() != intentList2.size()) {
            return false;
        }
        for (int i = 0; i < intentList1.size(); ++i) {
            if (intentList1.get(i).filterEquals(intentList2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static String getSystemPropertyValue(String propertyName) {
        String prop;
        try {
            prop = PermissionUtils.getSystemPropertyByReflect(propertyName);
            if (prop != null && !prop.isEmpty()) {
                return prop;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            prop = PermissionUtils.getSystemPropertyByShell(propertyName);
            if (prop != null && !prop.isEmpty()) {
                return prop;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            prop = PermissionUtils.getSystemPropertyByStream(propertyName);
            if (prop != null && !prop.isEmpty()) {
                return prop;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getSystemPropertyByReflect(String key) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Class<?> clz = Class.forName("android.os.SystemProperties");
        Method getMethod = clz.getMethod("get", String.class, String.class);
        return (String)getMethod.invoke(clz, key, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByShell(String propName) throws IOException {
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            String firstLine = input.readLine();
            if (firstLine != null) {
                String string = firstLine;
                return string;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByStream(String key) throws IOException {
        FileInputStream inputStream = null;
        try {
            Properties prop = new Properties();
            File file = new File(Environment.getRootDirectory(), "build.prop");
            inputStream = new FileInputStream(file);
            prop.load(inputStream);
            String string = prop.getProperty(key, "");
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

