/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.manifest.node.ServiceManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class BindNotificationListenerServicePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE";
    public static final Parcelable.Creator<BindNotificationListenerServicePermission> CREATOR = new Parcelable.Creator<BindNotificationListenerServicePermission>(){

        public BindNotificationListenerServicePermission createFromParcel(Parcel source) {
            return new BindNotificationListenerServicePermission(source);
        }

        public BindNotificationListenerServicePermission[] newArray(int size) {
            return new BindNotificationListenerServicePermission[size];
        }
    };
    private static final String SETTING_ENABLED_NOTIFICATION_LISTENERS = "enabled_notification_listeners";
    @NonNull
    private final String mNotificationListenerServiceClassName;

    public BindNotificationListenerServicePermission(@NonNull Class<? extends NotificationListenerService> notificationListenerServiceClass) {
        this(notificationListenerServiceClass.getName());
    }

    public BindNotificationListenerServicePermission(@NonNull String notificationListenerServiceClassName) {
        this.mNotificationListenerServiceClassName = notificationListenerServiceClassName;
    }

    private BindNotificationListenerServicePermission(Parcel in) {
        this(in.readString());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mNotificationListenerServiceClassName);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 18;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        String[] allComponentNameArray;
        String serviceClassName;
        if (!PermissionVersion.isAndroid4_3()) {
            return true;
        }
        NotificationManager notificationManager = PermissionVersion.isAndroid6() ? (NotificationManager)context.getSystemService(NotificationManager.class) : (NotificationManager)context.getSystemService("notification");
        String string = serviceClassName = PermissionUtils.isClassExist(this.mNotificationListenerServiceClassName) ? this.mNotificationListenerServiceClassName : null;
        if (PermissionVersion.isAndroid8_1() && notificationManager != null && serviceClassName != null) {
            return notificationManager.isNotificationListenerAccessGranted(new ComponentName(context, serviceClassName));
        }
        String enabledNotificationListeners = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)SETTING_ENABLED_NOTIFICATION_LISTENERS);
        if (TextUtils.isEmpty((CharSequence)enabledNotificationListeners)) {
            return false;
        }
        for (String component : allComponentNameArray = enabledNotificationListeners.split(":")) {
            ComponentName componentName = ComponentName.unflattenFromString((String)component);
            if (componentName == null || !(serviceClassName != null ? serviceClassName.equals(componentName.getClassName()) : context.getPackageName().equals(componentName.getPackageName()))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(3);
        if (PermissionVersion.isAndroid11() && PermissionUtils.isClassExist(this.mNotificationListenerServiceClassName)) {
            intent = new Intent("android.settings.NOTIFICATION_LISTENER_DETAIL_SETTINGS");
            intent.putExtra("android.provider.extra.NOTIFICATION_LISTENER_COMPONENT_NAME", new ComponentName(context, this.mNotificationListenerServiceClassName).flattenToString());
            intentList.add(intent);
        }
        String action = PermissionVersion.isAndroid5_1() ? "android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS" : "android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS";
        intent = new Intent(action);
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    public void checkCompliance(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        super.checkCompliance(activity, requestPermissions, androidManifestInfo);
        if (TextUtils.isEmpty((CharSequence)this.mNotificationListenerServiceClassName)) {
            throw new IllegalArgumentException("Pass the ServiceClass parameter as empty");
        }
        if (!PermissionUtils.isClassExist(this.mNotificationListenerServiceClassName)) {
            throw new IllegalArgumentException("The passed-in " + this.mNotificationListenerServiceClassName + " is an invalid class");
        }
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        List<ServiceManifestInfo> serviceManifestInfoList = androidManifestInfo.serviceManifestInfoList;
        for (ServiceManifestInfo serviceManifestInfo : serviceManifestInfoList) {
            if (serviceManifestInfo == null || !PermissionUtils.reverseEqualsString(this.mNotificationListenerServiceClassName, serviceManifestInfo.name)) continue;
            if (serviceManifestInfo.permission == null || !PermissionUtils.equalsPermission((IPermission)this, serviceManifestInfo.permission)) {
                throw new IllegalArgumentException("Please register permission node in the AndroidManifest.xml file, for example: <service android:name=\"" + this.mNotificationListenerServiceClassName + "\" android:permission=\"" + this.getPermissionName() + "\" />");
            }
            return;
        }
        throw new IllegalArgumentException("The \"" + this.mNotificationListenerServiceClassName + "\" component is not registered in the AndroidManifest.xml file");
    }

    @NonNull
    public String getNotificationListenerServiceClassName() {
        return this.mNotificationListenerServiceClassName;
    }
}

