/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.accessibilityservice.AccessibilityService;
import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.manifest.node.ServiceManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class BindAccessibilityServicePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.BIND_ACCESSIBILITY_SERVICE";
    public static final Parcelable.Creator<BindAccessibilityServicePermission> CREATOR = new Parcelable.Creator<BindAccessibilityServicePermission>(){

        public BindAccessibilityServicePermission createFromParcel(Parcel source) {
            return new BindAccessibilityServicePermission(source);
        }

        public BindAccessibilityServicePermission[] newArray(int size) {
            return new BindAccessibilityServicePermission[size];
        }
    };
    @NonNull
    private final String mAccessibilityServiceClassName;

    public BindAccessibilityServicePermission(@NonNull Class<? extends AccessibilityService> accessibilityServiceClass) {
        this(accessibilityServiceClass.getName());
    }

    public BindAccessibilityServicePermission(@NonNull String accessibilityServiceClassName) {
        this.mAccessibilityServiceClassName = accessibilityServiceClassName;
    }

    private BindAccessibilityServicePermission(Parcel in) {
        this(in.readString());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mAccessibilityServiceClassName);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 16;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        String[] allComponentNameArray;
        String enabledNotificationListeners = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services");
        if (TextUtils.isEmpty((CharSequence)enabledNotificationListeners)) {
            return false;
        }
        String serviceClassName = PermissionUtils.isClassExist(this.mAccessibilityServiceClassName) ? this.mAccessibilityServiceClassName : null;
        for (String component : allComponentNameArray = enabledNotificationListeners.split(":")) {
            ComponentName componentName = ComponentName.unflattenFromString((String)component);
            if (componentName == null || !(serviceClassName != null ? serviceClassName.equals(componentName.getClassName()) : context.getPackageName().equals(componentName.getPackageName()))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(2);
        intentList.add(new Intent("android.settings.ACCESSIBILITY_SETTINGS"));
        intentList.add(this.getAndroidSettingIntent());
        return intentList;
    }

    @Override
    public void checkCompliance(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        super.checkCompliance(activity, requestPermissions, androidManifestInfo);
        if (TextUtils.isEmpty((CharSequence)this.mAccessibilityServiceClassName)) {
            throw new IllegalArgumentException("Pass the ServiceClass parameter as empty");
        }
        if (!PermissionUtils.isClassExist(this.mAccessibilityServiceClassName)) {
            throw new IllegalArgumentException("The passed-in " + this.mAccessibilityServiceClassName + " is an invalid class");
        }
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        List<ServiceManifestInfo> serviceManifestInfoList = androidManifestInfo.serviceManifestInfoList;
        for (ServiceManifestInfo serviceManifestInfo : serviceManifestInfoList) {
            if (serviceManifestInfo == null || !PermissionUtils.reverseEqualsString(this.mAccessibilityServiceClassName, serviceManifestInfo.name)) continue;
            if (serviceManifestInfo.permission == null || !PermissionUtils.equalsPermission((IPermission)this, serviceManifestInfo.permission)) {
                throw new IllegalArgumentException("Please register permission node in the AndroidManifest.xml file, for example: <service android:name=\"" + this.mAccessibilityServiceClassName + "\" android:permission=\"" + this.getPermissionName() + "\" />");
            }
            return;
        }
        throw new IllegalArgumentException("The \"" + this.mAccessibilityServiceClassName + "\" component is not registered in the AndroidManifest.xml file");
    }

    @NonNull
    public String getAccessibilityServiceClassName() {
        return this.mAccessibilityServiceClassName;
    }
}

