/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.support.annotation.NonNull;
import com.hjq.permissions.manager.AlreadyRequestPermissionsManager;
import com.hjq.permissions.permission.PermissionPageType;
import com.hjq.permissions.permission.PermissionType;
import com.hjq.permissions.permission.base.BasePermission;
import com.hjq.permissions.tools.PermissionSettingPage;
import com.hjq.permissions.tools.PermissionVersion;
import com.hjq.permissions.tools.PhoneRomUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class DangerousPermission
extends BasePermission {
    protected DangerousPermission() {
    }

    protected DangerousPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public PermissionType getPermissionType() {
        return PermissionType.DANGEROUS;
    }

    @Override
    @NonNull
    public PermissionPageType getPermissionPageType(@NonNull Context context) {
        return PermissionPageType.TRANSPARENT_ACTIVITY;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (this.getFromAndroidVersion() > PermissionVersion.getCurrentVersion()) {
            return this.isGrantedPermissionByLowVersion(context, skipRequest);
        }
        return this.isGrantedPermissionByStandardVersion(context, skipRequest);
    }

    protected boolean isGrantedPermissionByStandardVersion(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid6()) {
            return true;
        }
        return DangerousPermission.checkSelfPermission(context, this.getPermissionName());
    }

    protected boolean isGrantedPermissionByLowVersion(@NonNull Context context, boolean skipRequest) {
        return true;
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity) {
        if (this.getFromAndroidVersion() > PermissionVersion.getCurrentVersion()) {
            return this.isDoNotAskAgainPermissionByLowVersion(activity);
        }
        return this.isDoNotAskAgainPermissionByStandardVersion(activity);
    }

    protected boolean isDoNotAskAgainPermissionByStandardVersion(@NonNull Activity activity) {
        if (!PermissionVersion.isAndroid6()) {
            return false;
        }
        return AlreadyRequestPermissionsManager.isAlreadyRequestPermissions(this) && !DangerousPermission.checkSelfPermission((Context)activity, this.getPermissionName()) && !DangerousPermission.shouldShowRequestPermissionRationale(activity, this.getPermissionName());
    }

    protected boolean isDoNotAskAgainPermissionByLowVersion(@NonNull Activity activity) {
        return false;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        String romVersionName;
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(5);
        if (PhoneRomUtils.isMiui() && PhoneRomUtils.isXiaomiSystemOptimization()) {
            intent = PermissionSettingPage.getXiaoMiApplicationPermissionPageIntent(context);
            intentList.add(intent);
        } else if (PhoneRomUtils.isHyperOs() && PhoneRomUtils.isXiaomiSystemOptimization() && (romVersionName = PhoneRomUtils.getRomVersionName()) != null && !romVersionName.matches("^2\\.0\\.[012345]\\.\\d+$")) {
            intent = PermissionSettingPage.getXiaoMiApplicationPermissionPageIntent(context);
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = DangerousPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = DangerousPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

