/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.tools;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;

public final class PermissionTaskHandler {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static void sendTask(@NonNull Runnable runnable, long delayMillis) {
        HANDLER.postDelayed(runnable, delayMillis);
    }

    public static void sendTask(@NonNull Runnable runnable, @NonNull Object token, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        long uptimeMillis = SystemClock.uptimeMillis() + delayMillis;
        HANDLER.postAtTime(runnable, token, uptimeMillis);
    }

    public static void cancelTask(@NonNull Object token) {
        HANDLER.removeCallbacksAndMessages(token);
    }
}

