/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class NearbyWifiDevicesPermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.NEARBY_WIFI_DEVICES";
    public static final Parcelable.Creator<NearbyWifiDevicesPermission> CREATOR = new Parcelable.Creator<NearbyWifiDevicesPermission>(){

        public NearbyWifiDevicesPermission createFromParcel(Parcel source) {
            return new NearbyWifiDevicesPermission(source);
        }

        public NearbyWifiDevicesPermission[] newArray(int size) {
            return new NearbyWifiDevicesPermission[size];
        }
    };

    public NearbyWifiDevicesPermission() {
    }

    private NearbyWifiDevicesPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public String getPermissionGroup() {
        return PermissionVersion.isAndroid13() ? "nearby_devices_group" : "location_group";
    }

    @Override
    public int getFromAndroidVersion() {
        return 33;
    }

    @Override
    @NonNull
    public List<IPermission> getOldPermissions(Context context) {
        return PermissionUtils.asArrayList(PermissionLists.getAccessFineLocationPermission());
    }

    @Override
    protected boolean isGrantedPermissionByLowVersion(@NonNull Context context, boolean skipRequest) {
        return PermissionLists.getAccessFineLocationPermission().isGrantedPermission(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByLowVersion(@NonNull Activity activity) {
        return PermissionLists.getAccessFineLocationPermission().isDoNotAskAgainPermission(activity);
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        if (this.getFromAndroidVersion() > NearbyWifiDevicesPermission.getMinSdkVersion((Context)activity, androidManifestInfo)) {
            NearbyWifiDevicesPermission.checkPermissionRegistrationStatus(permissionManifestInfoList, "android.permission.ACCESS_FINE_LOCATION", 32);
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            return;
        }
        if (currentPermissionManifestInfo == null) {
            return;
        }
        if (currentPermissionManifestInfo.neverForLocation()) {
            return;
        }
        String maxSdkVersionString = currentPermissionManifestInfo.maxSdkVersion != Integer.MAX_VALUE ? "android:maxSdkVersion=\"" + currentPermissionManifestInfo.maxSdkVersion + "\" " : "";
        throw new IllegalArgumentException("If your app doesn't use " + currentPermissionManifestInfo.name + " to get physical location, please change the <uses-permission android:name=\"" + currentPermissionManifestInfo.name + "\" " + maxSdkVersionString + "/> node in the manifest file to <uses-permission android:name=\"" + currentPermissionManifestInfo.name + "\" android:usesPermissionFlags=\"neverForLocation\" " + maxSdkVersionString + "/> node, if your app need use \"" + currentPermissionManifestInfo.name + "\" to get physical location, also need to add \"" + "android.permission.ACCESS_FINE_LOCATION" + "\" permissions");
    }
}

