/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.PermissionActivityIntentHandler;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;

final class WindowPermissionCompat {
    private static final String OP_SYSTEM_ALERT_WINDOW_FIELD_NAME = "OP_SYSTEM_ALERT_WINDOW";
    private static final int OP_SYSTEM_ALERT_WINDOW_DEFAULT_VALUE = 24;

    WindowPermissionCompat() {
    }

    static boolean isGrantedPermission(@NonNull Context context) {
        if (AndroidVersionTools.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return PermissionUtils.checkOpNoThrow(context, OP_SYSTEM_ALERT_WINDOW_FIELD_NAME, 24);
    }

    static Intent getPermissionIntent(@NonNull Context context) {
        if (AndroidVersionTools.isAndroid6()) {
            Intent intent;
            if (PhoneRomUtils.isHyperOs() && PermissionUtils.areActivityIntent(context, intent = WindowPermissionCompat.getManageOverlayPermissionIntent(context))) {
                return intent;
            }
            if (AndroidVersionTools.isAndroid11() && PhoneRomUtils.isMiui() && PhoneRomUtils.isMiuiOptimization()) {
                intent = PermissionIntentManager.getMiuiPermissionPageIntent(context);
                intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
                return intent;
            }
            intent = WindowPermissionCompat.getManageOverlayPermissionIntent(context);
            if (PermissionUtils.areActivityIntent(context, intent)) {
                return intent;
            }
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
            return intent;
        }
        if (PhoneRomUtils.isEmui()) {
            Intent intent = PermissionIntentManager.getEmuiWindowPermissionPageIntent(context);
            intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isMiui()) {
            Intent intent = null;
            if (PhoneRomUtils.isMiuiOptimization()) {
                intent = PermissionIntentManager.getMiuiWindowPermissionPageIntent(context);
            }
            intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isColorOs()) {
            Intent intent = PermissionIntentManager.getColorOsWindowPermissionPageIntent(context);
            intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isOriginOs()) {
            Intent intent = PermissionIntentManager.getOriginOsWindowPermissionPageIntent(context);
            intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isOneUi()) {
            Intent intent = PermissionIntentManager.getOneUiWindowPermissionPageIntent(context);
            intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isSmartisanOS() && !AndroidVersionTools.isAndroid5_1()) {
            Intent intent = PermissionIntentManager.getSmartisanWindowPermissionPageIntent(context);
            intent = PermissionActivityIntentHandler.addSubIntentForMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }

    @RequiresApi(value=23)
    private static Intent getManageOverlayPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        if (!AndroidVersionTools.isAndroid11()) {
            intent.setData(PermissionUtils.getPackageNameUri(context));
        }
        return intent;
    }
}

