/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionActivityIntentHandler;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.RequestBasePermissionFragment;
import java.util.ArrayList;
import java.util.List;

public final class RequestSpecialPermissionFragment
extends RequestBasePermissionFragment
implements Runnable {
    @Nullable
    private OnPermissionPageCallback mCallBack;

    public static void launch(@NonNull Activity activity, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        RequestSpecialPermissionFragment fragment = new RequestSpecialPermissionFragment();
        Bundle bundle = new Bundle();
        if (permissions instanceof ArrayList) {
            bundle.putStringArrayList("request_permissions", (ArrayList)permissions);
        } else {
            bundle.putStringArrayList("request_permissions", new ArrayList<String>(permissions));
        }
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setOnPermissionPageCallback(callback);
        fragment.attachByActivity(activity);
    }

    public void setOnPermissionPageCallback(@Nullable OnPermissionPageCallback callback) {
        this.mCallBack = callback;
    }

    @Override
    public void startPermissionRequest() {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList permissions = arguments.getStringArrayList("request_permissions");
        if (permissions == null || permissions.isEmpty()) {
            return;
        }
        PermissionActivityIntentHandler.startActivityForResult(this, PermissionApi.getSmartPermissionIntent((Context)activity, permissions), 1025);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != 1025) {
            return;
        }
        Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null) {
            return;
        }
        ArrayList allPermissions = arguments.getStringArrayList("request_permissions");
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        PermissionUtils.postActivityResult(allPermissions, this);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        OnPermissionPageCallback callback = this.mCallBack;
        this.mCallBack = null;
        if (callback == null) {
            this.detachByActivity(activity);
            return;
        }
        Bundle arguments = this.getArguments();
        ArrayList allPermissions = arguments.getStringArrayList("request_permissions");
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        List<String> grantedPermissions = PermissionApi.getGrantedPermissions((Context)activity, allPermissions);
        if (grantedPermissions.size() == allPermissions.size()) {
            callback.onGranted();
        } else {
            callback.onDenied();
        }
        this.detachByActivity(activity);
    }
}

