/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class PhoneRomUtils {
    private static final String[] ROM_HUAWEI = new String[]{"huawei"};
    private static final String[] ROM_VIVO = new String[]{"vivo"};
    private static final String[] ROM_XIAOMI = new String[]{"xiaomi"};
    private static final String[] ROM_OPPO = new String[]{"oppo"};
    private static final String[] ROM_LEECO = new String[]{"leeco", "letv"};
    private static final String[] ROM_360 = new String[]{"360", "qiku"};
    private static final String[] ROM_ZTE = new String[]{"zte"};
    private static final String[] ROM_ONEPLUS = new String[]{"oneplus"};
    private static final String[] ROM_NUBIA = new String[]{"nubia"};
    private static final String[] ROM_SAMSUNG = new String[]{"samsung"};
    private static final String[] ROM_HONOR = new String[]{"honor"};
    private static final String ROM_NAME_MIUI = "ro.miui.ui.version.name";
    private static final String ROM_NAME_HYPER_OS = "ro.mi.os.version.name";
    private static final String VERSION_PROPERTY_HUAWEI = "ro.build.version.emui";
    private static final String VERSION_PROPERTY_VIVO = "ro.vivo.os.build.display.id";
    private static final String VERSION_PROPERTY_XIAOMI = "ro.build.version.incremental";
    private static final String[] VERSION_PROPERTY_OPPO = new String[]{"ro.build.version.opporom", "ro.build.version.oplusrom.display"};
    private static final String VERSION_PROPERTY_LEECO = "ro.letv.release.version";
    private static final String VERSION_PROPERTY_360 = "ro.build.uiversion";
    private static final String VERSION_PROPERTY_ZTE = "ro.build.MiFavor_version";
    private static final String VERSION_PROPERTY_ONEPLUS = "ro.rom.version";
    private static final String VERSION_PROPERTY_NUBIA = "ro.build.rom.id";
    private static final String[] VERSION_PROPERTY_MAGIC = new String[]{"msc.config.magic.version", "ro.build.version.magic"};

    private PhoneRomUtils() {
    }

    static boolean isEmui() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_HUAWEI));
    }

    static boolean isMiui() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(ROM_NAME_MIUI));
    }

    static boolean isHyperOs() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(ROM_NAME_HYPER_OS));
    }

    static boolean isColorOs() {
        for (String property : VERSION_PROPERTY_OPPO) {
            String versionName = PermissionUtils.getSystemPropertyValue(property);
            if (TextUtils.isEmpty((CharSequence)versionName)) continue;
            return true;
        }
        return false;
    }

    static boolean isOriginOs() {
        return !TextUtils.isEmpty((CharSequence)PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_VIVO));
    }

    @SuppressLint(value={"PrivateApi"})
    static boolean isOneUi() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_SAMSUNG);
    }

    static boolean isHarmonyOs() {
        if (!AndroidVersion.isAndroid10()) {
            return false;
        }
        try {
            Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
            Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
            return "Harmony".equalsIgnoreCase(String.valueOf(osBrand));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    static boolean isMagicOs() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_HONOR);
    }

    @SuppressLint(value={"PrivateApi"})
    static boolean isMiuiOptimization() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getMethod = clazz.getMethod("get", String.class, String.class);
            String ctsValue = String.valueOf(getMethod.invoke(clazz, "ro.miui.cts", ""));
            Method getBooleanMethod = clazz.getMethod("getBoolean", String.class, Boolean.TYPE);
            return Boolean.parseBoolean(String.valueOf(getBooleanMethod.invoke(clazz, "persist.sys.miui_optimization", !"1".equals(ctsValue))));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Nullable
    static String getRomVersionName() {
        String manufacturer;
        String brand = PhoneRomUtils.getBrand();
        if (PhoneRomUtils.isRightRom(brand, manufacturer = PhoneRomUtils.getManufacturer(), ROM_HUAWEI)) {
            String version = PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_HUAWEI);
            String[] temp = version.split("_");
            if (temp.length > 1) {
                return temp[1];
            }
            if (version.contains("EmotionUI")) {
                return version.replaceFirst("EmotionUI\\s*", "");
            }
            return version;
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_VIVO)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_VIVO);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_XIAOMI)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_XIAOMI);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_OPPO)) {
            for (String property : VERSION_PROPERTY_OPPO) {
                String versionName = PermissionUtils.getSystemPropertyValue(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_LEECO)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_LEECO);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_360)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_360);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_ZTE)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_ZTE);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_ONEPLUS)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_ONEPLUS);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_NUBIA)) {
            return PermissionUtils.getSystemPropertyValue(VERSION_PROPERTY_NUBIA);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_HONOR)) {
            for (String property : VERSION_PROPERTY_MAGIC) {
                String versionName = PermissionUtils.getSystemPropertyValue(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        return PermissionUtils.getSystemPropertyValue("");
    }

    private static boolean isRightRom(String brand, String manufacturer, String ... names) {
        for (String name : names) {
            if (!brand.contains(name) && !manufacturer.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static String getBrand() {
        return Build.BRAND.toLowerCase();
    }

    private static String getManufacturer() {
        return Build.MANUFACTURER.toLowerCase();
    }
}

