/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.NotificationPermissionCompat;
import com.hjq.permissions.PermissionDelegateImplV31;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV33
extends PermissionDelegateImplV31 {
    PermissionDelegateImplV33() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BODY_SENSORS_BACKGROUND")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid13()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.BODY_SENSORS");
            }
            return PermissionUtils.checkSelfPermission(context, "android.permission.BODY_SENSORS") && PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            if (!AndroidVersion.isAndroid13()) {
                return NotificationPermissionCompat.isGrantedPermission(context);
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NEARBY_WIFI_DEVICES")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid13()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"}, permission2)) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid13()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (AndroidVersion.isAndroid13() && AndroidVersion.getTargetSdkVersionCode(context) >= 33) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                return true;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_EXTERNAL_STORAGE")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_IMAGES") && PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_VIDEO") && PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_AUDIO");
            }
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BODY_SENSORS_BACKGROUND")) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid13()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.BODY_SENSORS") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.BODY_SENSORS");
            }
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.BODY_SENSORS")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.BODY_SENSORS");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            if (!AndroidVersion.isAndroid13()) {
                return false;
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NEARBY_WIFI_DEVICES")) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid13()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"}, permission2)) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid13()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (AndroidVersion.isAndroid13() && AndroidVersion.getTargetSdkVersionCode((Context)activity) >= 33) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                return false;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_EXTERNAL_STORAGE")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_MEDIA_IMAGES") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_MEDIA_IMAGES") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_MEDIA_VIDEO") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_MEDIA_VIDEO") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_MEDIA_AUDIO") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_MEDIA_AUDIO");
            }
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public boolean recheckPermissionResult(@NonNull Context context, @NonNull String permission2, boolean grantResult) {
        if (AndroidVersion.isAndroid13() && AndroidVersion.getTargetSdkVersionCode(context) >= 33 && PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            return this.isGrantedPermission(context, permission2);
        }
        return super.recheckPermissionResult(context, permission2, grantResult);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            return NotificationPermissionCompat.getPermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }
}

