/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV29;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV30
extends PermissionDelegateImplV29 {
    PermissionDelegateImplV30() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid11()) {
                if (AndroidVersion.isAndroid10() && !PermissionDelegateImplV30.isUseDeprecationExternalStorage()) {
                    return false;
                }
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE") && PermissionUtils.checkSelfPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
            }
            return PermissionDelegateImplV30.isGrantedManageStoragePermission();
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            return false;
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (!AndroidVersion.isAndroid11()) {
                return PermissionDelegateImplV30.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV30.getManageStoragePermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    @RequiresApi(value=30)
    private static boolean isGrantedManageStoragePermission() {
        return Environment.isExternalStorageManager();
    }

    @RequiresApi(value=30)
    private static Intent getManageStoragePermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV30.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    @RequiresApi(value=29)
    private static boolean isUseDeprecationExternalStorage() {
        return Environment.isExternalStorageLegacy();
    }
}

