/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV19;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV21
extends PermissionDelegateImplV19 {
    PermissionDelegateImplV21() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            if (!AndroidVersion.isAndroid5()) {
                return true;
            }
            return PermissionDelegateImplV21.isGrantedPackagePermission(context);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            return false;
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            if (!AndroidVersion.isAndroid5()) {
                return PermissionDelegateImplV21.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV21.getPackagePermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    @RequiresApi(value=21)
    private static boolean isGrantedPackagePermission(@NonNull Context context) {
        return PermissionUtils.checkOpNoThrow(context, "android:get_usage_stats");
    }

    @RequiresApi(value=21)
    private static Intent getPackagePermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
        if (AndroidVersion.isAndroid10()) {
            intent.setData(PermissionUtils.getPackageNameUri(context));
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV21.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

