/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.OnRequestPermissionsResultCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.RequestBasePermissionFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class RequestDangerousPermissionFragment
extends RequestBasePermissionFragment {
    private static final String REQUEST_CODE = "request_code";
    private static final List<Integer> REQUEST_CODE_ARRAY = new ArrayList<Integer>();
    @Nullable
    private OnRequestPermissionsResultCallback mCallBack;

    public static void launch(@NonNull Activity activity, @NonNull List<String> permissions, @Nullable OnRequestPermissionsResultCallback callback) {
        int requestCode;
        RequestDangerousPermissionFragment fragment = new RequestDangerousPermissionFragment();
        Random random = new Random();
        while (REQUEST_CODE_ARRAY.contains(requestCode = random.nextInt((int)Math.pow(2.0, 8.0)))) {
        }
        REQUEST_CODE_ARRAY.add(requestCode);
        Bundle bundle = new Bundle();
        bundle.putInt(REQUEST_CODE, requestCode);
        if (permissions instanceof ArrayList) {
            bundle.putStringArrayList("request_permissions", (ArrayList)permissions);
        } else {
            bundle.putStringArrayList("request_permissions", new ArrayList<String>(permissions));
        }
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setOnRequestPermissionsResultCallback(callback);
        fragment.attachByActivity(activity);
    }

    public void setOnRequestPermissionsResultCallback(@Nullable OnRequestPermissionsResultCallback callback) {
        this.mCallBack = callback;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    @Override
    public void startPermissionRequest() {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList allPermissions = arguments.getStringArrayList("request_permissions");
        int requestCode = arguments.getInt(REQUEST_CODE);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        this.requestAllDangerousPermission(activity, requestCode, allPermissions);
    }

    private void requestAllDangerousPermission(@NonNull Activity activity, int requestCode, @NonNull List<String> allPermissions) {
        if (!AndroidVersion.isAndroid6()) {
            int[] grantResults = new int[allPermissions.size()];
            for (int i = 0; i < grantResults.length; ++i) {
                grantResults[i] = PermissionApi.isGrantedPermission((Context)activity, allPermissions.get(i)) ? 0 : -1;
            }
            this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[allPermissions.size()]), grantResults);
            return;
        }
        this.requestPermissions(allPermissions.toArray(new String[allPermissions.size()]), requestCode);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (activity == null || arguments == null || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        if (permissions == null || permissions.length == 0 || grantResults == null || grantResults.length == 0) {
            return;
        }
        OnRequestPermissionsResultCallback callback = this.mCallBack;
        this.mCallBack = null;
        REQUEST_CODE_ARRAY.remove((Object)requestCode);
        if (callback != null) {
            callback.onRequestPermissionsResult(permissions, grantResults);
        }
        this.detachByActivity(activity);
    }
}

