/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.content.res.Resources;
import com.hjq.toast.ToastStrategy;
import com.hjq.toast.config.IToastInterceptor;
import com.hjq.toast.config.IToastStrategy;
import com.hjq.toast.config.IToastStyle;
import com.hjq.toast.style.BlackToastStyle;
import com.hjq.toast.style.LocationToastStyle;
import com.hjq.toast.style.ViewToastStyle;

public final class ToastUtils {
    private static Application sApplication;
    private static IToastStrategy sToastStrategy;
    private static IToastStyle<?> sToastStyle;
    private static IToastInterceptor sToastInterceptor;
    private static Boolean sDebugMode;

    private ToastUtils() {
    }

    public static void init(Application application) {
        ToastUtils.init(application, sToastStyle);
    }

    public static void init(Application application, IToastStyle<?> style) {
        sApplication = application;
        if (sToastStrategy == null) {
            ToastUtils.setStrategy(new ToastStrategy());
        }
        if (style == null) {
            style = new BlackToastStyle();
        }
        ToastUtils.setStyle(style);
    }

    public static boolean isInit() {
        return sApplication != null && sToastStrategy != null && sToastStyle != null;
    }

    public static void show(Object object) {
        ToastUtils.show(object != null ? object.toString() : "null");
    }

    public static void debugShow(Object object) {
        if (!ToastUtils.isDebugMode()) {
            return;
        }
        ToastUtils.show(object);
    }

    public static void show(int id2) {
        try {
            ToastUtils.show(sApplication.getResources().getText(id2));
        }
        catch (Resources.NotFoundException ignored) {
            ToastUtils.show(String.valueOf(id2));
        }
    }

    public static void debugShow(int id2) {
        if (!ToastUtils.isDebugMode()) {
            return;
        }
        ToastUtils.show(id2);
    }

    public static void show(CharSequence text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (sToastInterceptor != null && sToastInterceptor.intercept(text)) {
            return;
        }
        sToastStrategy.showToast(text);
    }

    public static void debugShow(CharSequence text) {
        if (!ToastUtils.isDebugMode()) {
            return;
        }
        ToastUtils.show(text);
    }

    public static void cancel() {
        sToastStrategy.cancelToast();
    }

    public static void setGravity(int gravity) {
        ToastUtils.setGravity(gravity, 0, 0);
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.setGravity(gravity, xOffset, yOffset, 0.0f, 0.0f);
    }

    public static void setGravity(int gravity, int xOffset, int yOffset, float horizontalMargin, float verticalMargin) {
        sToastStrategy.bindStyle(new LocationToastStyle(sToastStyle, gravity, xOffset, yOffset, horizontalMargin, verticalMargin));
    }

    public static void setView(int id2) {
        if (id2 <= 0) {
            return;
        }
        ToastUtils.setStyle(new ViewToastStyle(id2, sToastStyle));
    }

    public static void setStyle(IToastStyle<?> style) {
        sToastStyle = style;
        sToastStrategy.bindStyle(style);
    }

    public static IToastStyle<?> getStyle() {
        return sToastStyle;
    }

    public static void setStrategy(IToastStrategy strategy) {
        sToastStrategy = strategy;
        sToastStrategy.registerStrategy(sApplication);
    }

    public static IToastStrategy getStrategy() {
        return sToastStrategy;
    }

    public static void setInterceptor(IToastInterceptor interceptor) {
        sToastInterceptor = interceptor;
    }

    public static IToastInterceptor getInterceptor() {
        return sToastInterceptor;
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    private static boolean isDebugMode() {
        if (sDebugMode == null) {
            sDebugMode = (ToastUtils.sApplication.getApplicationInfo().flags & 2) != 0;
        }
        return sDebugMode;
    }
}

