/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import com.hjq.toast.WindowHelper;

final class ToastHelper
extends Handler {
    private final Toast mToast;
    private final WindowHelper mWindowHelper;
    private final String mPackageName;
    private boolean mShow;

    ToastHelper(Toast toast, Application application) {
        super(Looper.getMainLooper());
        this.mToast = toast;
        this.mPackageName = application.getPackageName();
        this.mWindowHelper = WindowHelper.register(this, application);
    }

    public void handleMessage(Message msg) {
        this.cancel();
    }

    boolean isShow() {
        return this.mShow;
    }

    void setShow(boolean show) {
        this.mShow = show;
    }

    void show() {
        if (!this.isShow()) {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.format = -3;
            params.windowAnimations = 16973828;
            params.flags = 152;
            params.packageName = this.mPackageName;
            params.gravity = this.mToast.getGravity();
            params.x = this.mToast.getXOffset();
            params.y = this.mToast.getYOffset();
            try {
                WindowManager windowManager;
                Activity topActivity = this.mWindowHelper.getTopActivity();
                if (topActivity != null && !topActivity.isFinishing() && (windowManager = (WindowManager)topActivity.getSystemService("window")) != null) {
                    windowManager.addView(this.mToast.getView(), (ViewGroup.LayoutParams)params);
                }
                this.sendEmptyMessageDelayed(((Object)((Object)this)).hashCode(), this.mToast.getDuration() == 1 ? 3500L : 2000L);
                this.setShow(true);
            }
            catch (WindowManager.BadTokenException | IllegalStateException throwable) {
                // empty catch block
            }
        }
    }

    void cancel() {
        this.removeMessages(((Object)((Object)this)).hashCode());
        if (this.isShow()) {
            try {
                WindowManager windowManager;
                Activity topActivity = this.mWindowHelper.getTopActivity();
                if (topActivity != null && (windowManager = (WindowManager)topActivity.getSystemService("window")) != null) {
                    windowManager.removeViewImmediate(this.mToast.getView());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.setShow(false);
        }
    }
}

