/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.Toast;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

final class ToastHandler
extends Handler {
    static final int SHORT_DURATION_TIMEOUT = 2000;
    static final int LONG_DURATION_TIMEOUT = 3500;
    private static final int TYPE_SHOW = 1;
    private static final int TYPE_CONTINUE = 2;
    private static final int TYPE_CANCEL = 3;
    private static final int MAX_TOAST_CAPACITY = 3;
    private volatile Queue<CharSequence> mQueue;
    private volatile boolean isShow;
    private final Toast mToast;

    ToastHandler(Toast toast) {
        super(Looper.getMainLooper());
        this.mToast = toast;
        this.mQueue = new ArrayBlockingQueue<CharSequence>(3);
    }

    void add(CharSequence s) {
        if (!(!this.mQueue.isEmpty() && this.mQueue.contains(s) || this.mQueue.offer(s))) {
            this.mQueue.poll();
            this.mQueue.offer(s);
        }
    }

    void show() {
        if (!this.isShow) {
            this.isShow = true;
            this.sendEmptyMessage(1);
        }
    }

    void cancel() {
        if (this.isShow) {
            this.isShow = false;
            this.sendEmptyMessage(3);
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                CharSequence text = this.mQueue.peek();
                if (text != null) {
                    this.mToast.setText(text);
                    this.mToast.show();
                    this.sendEmptyMessageDelayed(2, ToastHandler.getToastDuration(text));
                    break;
                }
                this.isShow = false;
                break;
            }
            case 2: {
                this.mQueue.poll();
                if (!this.mQueue.isEmpty()) {
                    this.sendEmptyMessage(1);
                    break;
                }
                this.isShow = false;
                break;
            }
            case 3: {
                this.isShow = false;
                this.mQueue.clear();
                this.mToast.cancel();
                break;
            }
        }
    }

    private static int getToastDuration(CharSequence text) {
        return text.length() > 20 ? 3500 : 2000;
    }
}

