/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.Settings;
import android.view.View;
import com.hjq.toast.ActivityStack;
import com.hjq.toast.ActivityToast;
import com.hjq.toast.CustomToast;
import com.hjq.toast.GlobalToast;
import com.hjq.toast.NotificationToast;
import com.hjq.toast.SafeToast;
import com.hjq.toast.SystemToast;
import com.hjq.toast.ToastParams;
import com.hjq.toast.config.IToast;
import com.hjq.toast.config.IToastStrategy;
import com.hjq.toast.config.IToastStyle;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ToastStrategy
implements IToastStrategy {
    public static final int SHOW_STRATEGY_TYPE_IMMEDIATELY = 0;
    public static final int SHOW_STRATEGY_TYPE_QUEUE = 1;
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private Application mApplication;
    private WeakReference<IToast> mToastReference;
    private final int mShowStrategyType;
    private final Object mShowMessageToken = new Object();
    private final Object mCancelMessageToken = new Object();
    private volatile long mLastShowToastMillis;

    public ToastStrategy() {
        this(0);
    }

    public ToastStrategy(int type) {
        this.mShowStrategyType = type;
        switch (this.mShowStrategyType) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Please don't pass non-existent toast show strategy");
            }
        }
    }

    @Override
    public void registerStrategy(Application application) {
        this.mApplication = application;
    }

    @Override
    public int computeShowDuration(CharSequence text) {
        return text.length() > 20 ? 1 : 0;
    }

    @Override
    public IToast createToast(ToastParams params) {
        Activity foregroundActivity = this.getForegroundActivity();
        IToast toast = (params.priorityType == 0 || params.priorityType == 1) && Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)this.mApplication) ? new GlobalToast(this.mApplication) : ((params.priorityType == 0 || params.priorityType == 2) && this.isActivityAvailable(foregroundActivity) ? new ActivityToast(foregroundActivity) : (Build.VERSION.SDK_INT == 25 ? new SafeToast(this.mApplication) : (Build.VERSION.SDK_INT < 29 && !this.areNotificationsEnabled((Context)this.mApplication) ? new NotificationToast(this.mApplication) : new SystemToast(this.mApplication))));
        if (this.areSupportCustomToastStyle(toast) || !this.onlyShowSystemToastStyle()) {
            this.diyToastStyle(toast, params.style);
        }
        return toast;
    }

    @Override
    public void showToast(ToastParams params) {
        switch (this.mShowStrategyType) {
            case 0: {
                this.cancelToast();
                long uptimeMillis = SystemClock.uptimeMillis() + params.delayMillis + (long)this.generateShowDelayTime(params);
                ToastStrategy.getHandler().postAtTime((Runnable)new ShowToastRunnable(params), this.mShowMessageToken, uptimeMillis);
                break;
            }
            case 1: {
                long showToastMillis = SystemClock.uptimeMillis() + params.delayMillis + (long)this.generateShowDelayTime(params);
                long waitMillis = this.generateToastWaitMillis(params);
                if (showToastMillis < this.mLastShowToastMillis + waitMillis) {
                    showToastMillis = this.mLastShowToastMillis + waitMillis;
                }
                ToastStrategy.getHandler().postAtTime((Runnable)new ShowToastRunnable(params), this.mShowMessageToken, showToastMillis);
                this.mLastShowToastMillis = showToastMillis;
                break;
            }
        }
    }

    @Override
    public void cancelToast() {
        long uptimeMillis = SystemClock.uptimeMillis();
        ToastStrategy.getHandler().postAtTime((Runnable)new CancelToastRunnable(), this.mCancelMessageToken, uptimeMillis);
    }

    protected static Handler getHandler() {
        return HANDLER;
    }

    protected int generateShowDelayTime(ToastParams params) {
        return 300;
    }

    protected boolean areSupportCustomToastStyle(IToast toast) {
        return toast instanceof CustomToast || Build.VERSION.SDK_INT < 30;
    }

    protected void diyToastStyle(IToast toast, IToastStyle<?> style2) {
        toast.setView((View)style2.createView((Context)this.mApplication));
        toast.setGravity(style2.getGravity(), style2.getXOffset(), style2.getYOffset());
        toast.setMargin(style2.getHorizontalMargin(), style2.getVerticalMargin());
    }

    protected int generateToastWaitMillis(ToastParams params) {
        if (params.duration == 0) {
            return 1000;
        }
        if (params.duration == 1) {
            return 1500;
        }
        return 0;
    }

    protected boolean onlyShowSystemToastStyle() {
        return this.isChangeEnabledCompat(147798919L);
    }

    @SuppressLint(value={"PrivateApi"})
    protected boolean isChangeEnabledCompat(long changeId) {
        if (Build.VERSION.SDK_INT < 30) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("android.app.compat.CompatChanges");
            Method method = clazz.getMethod("isChangeEnabled", Long.TYPE);
            method.setAccessible(true);
            return Boolean.parseBoolean(String.valueOf(method.invoke(null, changeId)));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    protected boolean areNotificationsEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    protected Activity getForegroundActivity() {
        return ActivityStack.getInstance().getForegroundActivity();
    }

    protected boolean isActivityAvailable(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (activity.isFinishing()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return !activity.isDestroyed();
        }
        return true;
    }

    private class CancelToastRunnable
    implements Runnable {
        private CancelToastRunnable() {
        }

        @Override
        public void run() {
            IToast toast = null;
            if (ToastStrategy.this.mToastReference != null) {
                toast = (IToast)ToastStrategy.this.mToastReference.get();
            }
            if (toast == null) {
                return;
            }
            toast.cancel();
        }
    }

    private class ShowToastRunnable
    implements Runnable {
        private final ToastParams mToastParams;

        private ShowToastRunnable(ToastParams params) {
            this.mToastParams = params;
        }

        @Override
        public void run() {
            IToast toast = null;
            if (ToastStrategy.this.mToastReference != null) {
                toast = (IToast)ToastStrategy.this.mToastReference.get();
            }
            if (toast != null) {
                toast.cancel();
            }
            toast = ToastStrategy.this.createToast(this.mToastParams);
            ToastStrategy.this.mToastReference = new WeakReference<IToast>(toast);
            toast.setDuration(this.mToastParams.duration);
            toast.setText(this.mToastParams.text);
            toast.show();
        }
    }
}

