/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.hjq.toast.CustomToast;
import com.hjq.toast.WindowLifecycle;

final class ToastImpl {
    private static final String WINDOW_TITLE = "Toast";
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private final CustomToast mToast;
    private WindowLifecycle mWindowLifecycle;
    private final String mPackageName;
    private boolean mShow;
    private boolean mGlobalShow;
    private final Runnable mShowRunnable = new Runnable(){

        @Override
        @SuppressLint(value={"WrongConstant"})
        public void run() {
            WindowManager windowManager = ToastImpl.this.mWindowLifecycle.getWindowManager();
            if (windowManager == null) {
                return;
            }
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.format = -3;
            params.flags = 152;
            params.packageName = ToastImpl.this.mPackageName;
            params.gravity = ToastImpl.this.mToast.getGravity();
            params.x = ToastImpl.this.mToast.getXOffset();
            params.y = ToastImpl.this.mToast.getYOffset();
            params.verticalMargin = ToastImpl.this.mToast.getVerticalMargin();
            params.horizontalMargin = ToastImpl.this.mToast.getHorizontalMargin();
            params.windowAnimations = ToastImpl.this.mToast.getAnimationsId();
            params.setTitle((CharSequence)ToastImpl.WINDOW_TITLE);
            if (Build.VERSION.SDK_INT >= 30) {
                params.setFitInsetsIgnoringVisibility(true);
            }
            if (ToastImpl.this.mGlobalShow) {
                if (Build.VERSION.SDK_INT >= 26) {
                    params.type = 2038;
                    params.flags &= 0xFFFFFFEF;
                } else {
                    params.type = 2003;
                }
            }
            try {
                windowManager.addView(ToastImpl.this.mToast.getView(), (ViewGroup.LayoutParams)params);
                HANDLER.postDelayed(() -> ToastImpl.this.cancel(), ToastImpl.this.mToast.getDuration() == 1 ? (long)ToastImpl.this.mToast.getLongDuration() : (long)ToastImpl.this.mToast.getShortDuration());
                ToastImpl.this.mWindowLifecycle.register(ToastImpl.this);
                ToastImpl.this.setShow(true);
                ToastImpl.this.sendAccessibilityEvent(ToastImpl.this.mToast.getView());
            }
            catch (WindowManager.BadTokenException | IllegalStateException e) {
                e.printStackTrace();
            }
        }
    };
    private final Runnable mCancelRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                WindowManager windowManager = ToastImpl.this.mWindowLifecycle.getWindowManager();
                if (windowManager == null) {
                    return;
                }
                windowManager.removeViewImmediate(ToastImpl.this.mToast.getView());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            finally {
                ToastImpl.this.mWindowLifecycle.unregister();
                ToastImpl.this.setShow(false);
            }
        }
    };

    ToastImpl(Activity activity, CustomToast toast) {
        this((Context)activity, toast);
        this.mGlobalShow = false;
        this.mWindowLifecycle = new WindowLifecycle(activity);
    }

    ToastImpl(Application application, CustomToast toast) {
        this((Context)application, toast);
        this.mGlobalShow = true;
        this.mWindowLifecycle = new WindowLifecycle(application);
    }

    private ToastImpl(Context context, CustomToast toast) {
        this.mToast = toast;
        this.mPackageName = context.getPackageName();
    }

    boolean isShow() {
        return this.mShow;
    }

    void setShow(boolean show) {
        this.mShow = show;
    }

    void show() {
        if (this.isShow()) {
            return;
        }
        if (this.isMainThread()) {
            this.mShowRunnable.run();
        } else {
            HANDLER.removeCallbacks(this.mShowRunnable);
            HANDLER.post(this.mShowRunnable);
        }
    }

    void cancel() {
        if (!this.isShow()) {
            return;
        }
        HANDLER.removeCallbacks(this.mShowRunnable);
        if (this.isMainThread()) {
            this.mCancelRunnable.run();
        } else {
            HANDLER.removeCallbacks(this.mCancelRunnable);
            HANDLER.post(this.mCancelRunnable);
        }
    }

    private boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private void sendAccessibilityEvent(View view) {
        AccessibilityEvent event;
        Context context = view.getContext();
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        if (!accessibilityManager.isEnabled()) {
            return;
        }
        int eventType = 64;
        if (Build.VERSION.SDK_INT >= 30) {
            event = new AccessibilityEvent();
            event.setEventType(eventType);
        } else {
            event = AccessibilityEvent.obtain((int)eventType);
        }
        event.setClassName((CharSequence)Toast.class.getName());
        event.setPackageName((CharSequence)context.getPackageName());
        view.dispatchPopulateAccessibilityEvent(event);
        accessibilityManager.sendAccessibilityEvent(event);
    }
}

