/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.hjq.toast.ActivityToast;
import com.hjq.toast.WindowLifecycle;

final class ToastImpl {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private final ActivityToast mToast;
    private final WindowLifecycle mWindowLifecycle;
    private final String mPackageName;
    private boolean mShow;
    private final Runnable mShowRunnable = new Runnable(){

        @Override
        public void run() {
            Activity activity = ToastImpl.this.mWindowLifecycle.getActivity();
            if (activity == null || activity.isFinishing()) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                return;
            }
            WindowManager windowManager = activity.getWindowManager();
            if (windowManager == null) {
                return;
            }
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.format = -3;
            params.flags = 152;
            params.packageName = ToastImpl.this.mPackageName;
            params.gravity = ToastImpl.this.mToast.getGravity();
            params.x = ToastImpl.this.mToast.getXOffset();
            params.y = ToastImpl.this.mToast.getYOffset();
            params.verticalMargin = ToastImpl.this.mToast.getVerticalMargin();
            params.horizontalMargin = ToastImpl.this.mToast.getHorizontalMargin();
            params.windowAnimations = ToastImpl.this.mToast.getAnimationsId();
            try {
                windowManager.addView(ToastImpl.this.mToast.getView(), (ViewGroup.LayoutParams)params);
                HANDLER.postDelayed(() -> ToastImpl.this.cancel(), ToastImpl.this.mToast.getDuration() == 1 ? (long)ToastImpl.this.mToast.getLongDuration() : (long)ToastImpl.this.mToast.getShortDuration());
                ToastImpl.this.mWindowLifecycle.register(ToastImpl.this);
                ToastImpl.this.setShow(true);
            }
            catch (WindowManager.BadTokenException | IllegalStateException e) {
                e.printStackTrace();
            }
        }
    };
    private final Runnable mCancelRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Activity activity = ToastImpl.this.mWindowLifecycle.getActivity();
                if (activity == null) {
                    return;
                }
                WindowManager windowManager = activity.getWindowManager();
                if (windowManager == null) {
                    return;
                }
                windowManager.removeViewImmediate(ToastImpl.this.mToast.getView());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            finally {
                ToastImpl.this.mWindowLifecycle.unregister();
                ToastImpl.this.setShow(false);
            }
        }
    };

    ToastImpl(Activity activity, ActivityToast toast) {
        this.mToast = toast;
        this.mPackageName = activity.getPackageName();
        this.mWindowLifecycle = new WindowLifecycle(activity);
    }

    boolean isShow() {
        return this.mShow;
    }

    void setShow(boolean show) {
        this.mShow = show;
    }

    void show() {
        if (this.isShow()) {
            return;
        }
        HANDLER.removeCallbacks(this.mShowRunnable);
        HANDLER.post(this.mShowRunnable);
    }

    void cancel() {
        if (!this.isShow()) {
            return;
        }
        HANDLER.removeCallbacks(this.mCancelRunnable);
        HANDLER.post(this.mCancelRunnable);
    }
}

