/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.widget.TextView;
import com.hjq.shape.config.ITextViewAttribute;
import com.hjq.shape.other.TextViewAttribute;
import com.hjq.shape.span.CommonFontSpan;

public class StrokeFontSpan
extends CommonFontSpan {
    private final Paint mStrokePaint = new Paint();
    private int mTextStrokeColor;
    private int mTextStrokeSize;
    private int mTextSolidColor;

    public static SpannableStringBuilder buildStrokeFontSpannable(TextView textView, CharSequence text, int textStrokeColor, int textStrokeSize) {
        return StrokeFontSpan.buildStrokeFontSpannable(new TextViewAttribute(textView), text, textStrokeColor, textStrokeSize);
    }

    public static SpannableStringBuilder buildStrokeFontSpannable(ITextViewAttribute textViewAttribute, CharSequence text, int textStrokeColor, int textStrokeSize) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        StrokeFontSpan span = new StrokeFontSpan(textViewAttribute).setTextStrokeColor(textStrokeColor).setTextStrokeSize(textStrokeSize);
        builder.setSpan((Object)span, 0, builder.length(), 33);
        return builder;
    }

    public StrokeFontSpan(ITextViewAttribute textViewAttribute) {
        super(textViewAttribute);
    }

    @Override
    public void onDraw(@NonNull Canvas canvas, @NonNull Paint paint, CharSequence text, float textWidth, int start, int end, float x, int top, int y, int bottom) {
        this.mStrokePaint.set(paint);
        this.mStrokePaint.setShader(null);
        this.mStrokePaint.setAntiAlias(true);
        this.mStrokePaint.setDither(true);
        this.mStrokePaint.setTextSize(paint.getTextSize());
        this.mStrokePaint.setStrokeWidth((float)this.mTextStrokeSize);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setColor(this.mTextStrokeColor);
        canvas.drawText(text, start, end, x, (float)y, this.mStrokePaint);
        if (this.mTextSolidColor != 0) {
            paint.setColor(this.mTextSolidColor);
            canvas.drawText(text, start, end, x, (float)y, paint);
        }
    }

    public StrokeFontSpan setTextSolidColor(@ColorInt int color) {
        this.mTextSolidColor = color;
        return this;
    }

    public StrokeFontSpan setTextStrokeColor(@ColorInt int color) {
        this.mTextStrokeColor = color;
        return this;
    }

    public StrokeFontSpan setTextStrokeSize(int size) {
        this.mTextStrokeSize = size;
        return this;
    }
}

