/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.builder;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.widget.TextView;
import com.hjq.shape.config.ITextColorStyleable;
import com.hjq.shape.config.ITextViewAttribute;
import com.hjq.shape.other.TextViewAttribute;
import com.hjq.shape.span.StrokeFontSpan;

public final class TextColorBuilder {
    public static final int GRADIENT_ORIENTATION_HORIZONTAL = 0;
    public static final int GRADIENT_ORIENTATION_VERTICAL = 1;
    private final TextView mTextView;
    private final ITextViewAttribute mTextViewAttribute;
    private int mTextColor;
    private Integer mTextPressedColor;
    private Integer mTextCheckedColor;
    private Integer mTextDisabledColor;
    private Integer mTextFocusedColor;
    private Integer mTextSelectedColor;
    private int[] mTextGradientColors;
    private int mTextGradientOrientation;
    private int mTextStrokeColor;
    private int mTextStrokeSize;

    public TextColorBuilder(TextView textView, TypedArray typedArray, ITextColorStyleable styleable2) {
        this.mTextView = textView;
        this.mTextColor = typedArray.getColor(styleable2.getTextColorStyleable(), textView.getTextColors().getDefaultColor());
        if (typedArray.hasValue(styleable2.getTextPressedColorStyleable())) {
            this.mTextPressedColor = typedArray.getColor(styleable2.getTextPressedColorStyleable(), this.mTextColor);
        }
        if (styleable2.getTextCheckedColorStyleable() > 0 && typedArray.hasValue(styleable2.getTextCheckedColorStyleable())) {
            this.mTextCheckedColor = typedArray.getColor(styleable2.getTextCheckedColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextDisabledColorStyleable())) {
            this.mTextDisabledColor = typedArray.getColor(styleable2.getTextDisabledColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextFocusedColorStyleable())) {
            this.mTextFocusedColor = typedArray.getColor(styleable2.getTextFocusedColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextSelectedColorStyleable())) {
            this.mTextSelectedColor = typedArray.getColor(styleable2.getTextSelectedColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextStartColorStyleable()) && typedArray.hasValue(styleable2.getTextEndColorStyleable())) {
            this.mTextGradientColors = typedArray.hasValue(styleable2.getTextCenterColorStyleable()) ? new int[]{typedArray.getColor(styleable2.getTextStartColorStyleable(), this.mTextColor), typedArray.getColor(styleable2.getTextCenterColorStyleable(), this.mTextColor), typedArray.getColor(styleable2.getTextEndColorStyleable(), this.mTextColor)} : new int[]{typedArray.getColor(styleable2.getTextStartColorStyleable(), this.mTextColor), typedArray.getColor(styleable2.getTextEndColorStyleable(), this.mTextColor)};
        }
        this.mTextGradientOrientation = typedArray.getColor(styleable2.getTextGradientOrientationStyleable(), 0);
        if (typedArray.hasValue(styleable2.getTextStrokeColorStyleable())) {
            this.mTextStrokeColor = typedArray.getColor(styleable2.getTextStrokeColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getTextStrokeSizeStyleable())) {
            this.mTextStrokeSize = typedArray.getDimensionPixelSize(styleable2.getTextStrokeSizeStyleable(), 0);
        }
        this.mTextViewAttribute = new TextViewAttribute(this.mTextView);
    }

    public TextColorBuilder setTextColor(int color) {
        this.mTextColor = color;
        return this;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public TextColorBuilder setTextPressedColor(Integer color) {
        this.mTextPressedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextPressedColor() {
        return this.mTextPressedColor;
    }

    public TextColorBuilder setTextCheckedColor(Integer color) {
        this.mTextCheckedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextCheckedColor() {
        return this.mTextCheckedColor;
    }

    public TextColorBuilder setTextDisabledColor(Integer color) {
        this.mTextDisabledColor = color;
        return this;
    }

    @Nullable
    public Integer getTextDisabledColor() {
        return this.mTextDisabledColor;
    }

    public TextColorBuilder setTextFocusedColor(Integer color) {
        this.mTextFocusedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextFocusedColor() {
        return this.mTextFocusedColor;
    }

    public TextColorBuilder setTextSelectedColor(Integer color) {
        this.mTextSelectedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextSelectedColor() {
        return this.mTextSelectedColor;
    }

    public TextColorBuilder setTextGradientColors(int startColor, int endColor) {
        return this.setTextGradientColors(new int[]{startColor, endColor});
    }

    public TextColorBuilder setTextGradientColors(int startColor, int centerColor, int endColor) {
        return this.setTextGradientColors(new int[]{startColor, centerColor, endColor});
    }

    public TextColorBuilder setTextGradientColors(int[] colors) {
        this.mTextGradientColors = colors;
        return this;
    }

    @Nullable
    public int[] getTextGradientColors() {
        return this.mTextGradientColors;
    }

    public boolean isTextGradientColorsEnable() {
        return this.mTextGradientColors != null && this.mTextGradientColors.length > 0;
    }

    public TextColorBuilder setTextGradientOrientation(int orientation) {
        this.mTextGradientOrientation = orientation;
        return this;
    }

    public int getTextGradientOrientation() {
        return this.mTextGradientOrientation;
    }

    public TextColorBuilder setTextStrokeColor(int color) {
        this.mTextStrokeColor = color;
        return this;
    }

    public TextColorBuilder setTextStrokeSize(int size) {
        this.mTextStrokeSize = size;
        return this;
    }

    public int getTextStrokeColor() {
        return this.mTextStrokeColor;
    }

    public int getTextStrokeSize() {
        return this.mTextStrokeSize;
    }

    public boolean isTextStrokeColorEnable() {
        return this.mTextStrokeColor != 0 && this.mTextStrokeSize > 0;
    }

    public void clearTextGradientColor() {
        if (!this.isTextGradientColorsEnable()) {
            this.mTextView.setTextColor(this.mTextColor);
        }
        this.mTextGradientColors = null;
        this.mTextView.postInvalidate();
    }

    public void clearTextStrokeColor() {
        this.mTextStrokeColor = 0;
        this.mTextView.setText((CharSequence)this.mTextView.getText().toString(), TextView.BufferType.NORMAL);
    }

    public SpannableStringBuilder buildStrokeFontSpannable(CharSequence text) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        StrokeFontSpan strokeFontSpan = null;
        if (this.isTextStrokeColorEnable()) {
            strokeFontSpan = new StrokeFontSpan(this.mTextViewAttribute).setTextStrokeColor(this.mTextStrokeColor).setTextStrokeSize(this.mTextStrokeSize);
        }
        if (strokeFontSpan != null) {
            strokeFontSpan.setTextSolidColor(this.mTextColor);
            builder.setSpan((Object)strokeFontSpan, 0, builder.length(), 33);
        }
        return builder;
    }

    public ColorStateList buildColorState() {
        int[] colors;
        int[][] states;
        if (this.mTextPressedColor == null && this.mTextCheckedColor == null && this.mTextDisabledColor == null && this.mTextFocusedColor == null && this.mTextSelectedColor == null) {
            return ColorStateList.valueOf((int)this.mTextColor);
        }
        int maxSize = 6;
        int arraySize = 0;
        int[][] statesTemp = new int[maxSize][];
        int[] colorsTemp = new int[maxSize];
        if (this.mTextPressedColor != null) {
            statesTemp[arraySize] = new int[]{16842919};
            colorsTemp[arraySize] = this.mTextPressedColor;
            ++arraySize;
        }
        if (this.mTextCheckedColor != null) {
            statesTemp[arraySize] = new int[]{0x10100A0};
            colorsTemp[arraySize] = this.mTextCheckedColor;
            ++arraySize;
        }
        if (this.mTextDisabledColor != null) {
            statesTemp[arraySize] = new int[]{-16842910};
            colorsTemp[arraySize] = this.mTextDisabledColor;
            ++arraySize;
        }
        if (this.mTextFocusedColor != null) {
            statesTemp[arraySize] = new int[]{16842908};
            colorsTemp[arraySize] = this.mTextFocusedColor;
            ++arraySize;
        }
        if (this.mTextSelectedColor != null) {
            statesTemp[arraySize] = new int[]{0x10100A1};
            colorsTemp[arraySize] = this.mTextSelectedColor;
            ++arraySize;
        }
        statesTemp[arraySize] = new int[0];
        colorsTemp[arraySize] = this.mTextColor;
        if (++arraySize == maxSize) {
            states = statesTemp;
            colors = colorsTemp;
        } else {
            states = new int[arraySize][];
            colors = new int[arraySize];
            System.arraycopy(statesTemp, 0, states, 0, arraySize);
            System.arraycopy(colorsTemp, 0, colors, 0, arraySize);
        }
        return new ColorStateList((int[][])states, colors);
    }

    public void intoTextColor() {
        if (this.isTextGradientColorsEnable()) {
            this.mTextColor |= 0xFF000000;
        }
        this.mTextView.setTextColor(this.buildColorState());
        if (this.isTextStrokeColorEnable()) {
            this.mTextView.setText((CharSequence)this.buildStrokeFontSpannable(this.mTextView.getText().toString()), TextView.BufferType.SPANNABLE);
        }
        this.mTextView.postInvalidate();
    }

    public void onDraw(@NonNull Canvas canvas, Paint paint) {
        if (this.isTextGradientColorsEnable()) {
            LinearGradient linearGradient = this.mTextGradientOrientation == 1 ? new LinearGradient((float)this.mTextView.getPaddingLeft(), (float)this.mTextView.getPaddingTop(), 0.0f, (float)canvas.getHeight() - (float)this.mTextView.getPaddingBottom(), this.mTextGradientColors, null, Shader.TileMode.CLAMP) : new LinearGradient((float)this.mTextView.getPaddingLeft(), (float)this.mTextView.getPaddingTop(), (float)canvas.getWidth() - (float)this.mTextView.getPaddingEnd(), (float)canvas.getHeight() - (float)this.mTextView.getPaddingBottom(), this.mTextGradientColors, null, Shader.TileMode.CLAMP);
            paint.setShader((Shader)linearGradient);
        } else {
            Shader shader = paint.getShader();
            if (shader instanceof LinearGradient) {
                paint.setShader(null);
            }
        }
    }
}

