/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatRadioButton;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.hjq.shape.R;
import com.hjq.shape.builder.ButtonDrawableBuilder;
import com.hjq.shape.builder.ShapeDrawableBuilder;
import com.hjq.shape.builder.TextColorBuilder;
import com.hjq.shape.styleable.ShapeRadioButtonStyleable;

public class ShapeRadioButton
extends AppCompatRadioButton {
    private static final ShapeRadioButtonStyleable STYLEABLE = new ShapeRadioButtonStyleable();
    private final ShapeDrawableBuilder mShapeDrawableBuilder;
    private final TextColorBuilder mTextColorBuilder;
    private final ButtonDrawableBuilder mButtonDrawableBuilder;

    public ShapeRadioButton(Context context) {
        this(context, null);
    }

    public ShapeRadioButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.radioButtonStyle);
    }

    public ShapeRadioButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeRadioButton);
        this.mShapeDrawableBuilder = new ShapeDrawableBuilder((View)this, typedArray, STYLEABLE);
        this.mTextColorBuilder = new TextColorBuilder((TextView)this, typedArray, STYLEABLE);
        this.mButtonDrawableBuilder = new ButtonDrawableBuilder((CompoundButton)this, typedArray, STYLEABLE);
        typedArray.recycle();
        this.mShapeDrawableBuilder.intoBackground();
        if (this.mTextColorBuilder.isTextGradientColors() || this.mTextColorBuilder.isTextStrokeColor()) {
            this.setText(this.getText());
        } else {
            this.mTextColorBuilder.intoTextColor();
        }
        this.mButtonDrawableBuilder.intoButtonDrawable();
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        if (this.mTextColorBuilder == null) {
            return;
        }
        this.mTextColorBuilder.setTextColor(color);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mTextColorBuilder != null && (this.mTextColorBuilder.isTextGradientColors() || this.mTextColorBuilder.isTextStrokeColor())) {
            super.setText((CharSequence)this.mTextColorBuilder.buildTextSpannable(text), type);
        } else {
            super.setText(text, type);
        }
    }

    public void setButtonDrawable(Drawable drawable) {
        super.setButtonDrawable(drawable);
        if (this.mButtonDrawableBuilder == null) {
            return;
        }
        this.mButtonDrawableBuilder.setButtonDrawable(drawable);
    }

    public ShapeDrawableBuilder getShapeDrawableBuilder() {
        return this.mShapeDrawableBuilder;
    }

    public TextColorBuilder getTextColorBuilder() {
        return this.mTextColorBuilder;
    }

    public ButtonDrawableBuilder getButtonDrawableBuilder() {
        return this.mButtonDrawableBuilder;
    }
}

