/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.builder;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.widget.TextView;
import com.hjq.shape.span.LinearGradientFontSpan;
import com.hjq.shape.span.MultiFontSpan;
import com.hjq.shape.span.StrokeFontSpan;
import com.hjq.shape.styleable.ITextColorStyleable;

public final class TextColorBuilder {
    private final TextView mTextView;
    private int mTextColor;
    private Integer mTextPressedColor;
    private Integer mTextCheckedColor;
    private Integer mTextDisabledColor;
    private Integer mTextFocusedColor;
    private Integer mTextSelectedColor;
    private int[] mTextGradientColors;
    private int mTextGradientOrientation;
    private int mTextStrokeColor;
    private int mTextStrokeSize;

    public TextColorBuilder(TextView textView, TypedArray typedArray, ITextColorStyleable styleable2) {
        this.mTextView = textView;
        this.mTextColor = typedArray.getColor(styleable2.getTextColorStyleable(), textView.getTextColors().getDefaultColor());
        if (typedArray.hasValue(styleable2.getTextPressedColorStyleable())) {
            this.mTextPressedColor = typedArray.getColor(styleable2.getTextPressedColorStyleable(), this.mTextColor);
        }
        if (styleable2.getTextCheckedColorStyleable() > 0 && typedArray.hasValue(styleable2.getTextCheckedColorStyleable())) {
            this.mTextCheckedColor = typedArray.getColor(styleable2.getTextCheckedColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextDisabledColorStyleable())) {
            this.mTextDisabledColor = typedArray.getColor(styleable2.getTextDisabledColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextFocusedColorStyleable())) {
            this.mTextFocusedColor = typedArray.getColor(styleable2.getTextFocusedColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextSelectedColorStyleable())) {
            this.mTextSelectedColor = typedArray.getColor(styleable2.getTextSelectedColorStyleable(), this.mTextColor);
        }
        if (typedArray.hasValue(styleable2.getTextStartColorStyleable()) && typedArray.hasValue(styleable2.getTextEndColorStyleable())) {
            this.mTextGradientColors = typedArray.hasValue(styleable2.getTextCenterColorStyleable()) ? new int[]{typedArray.getColor(styleable2.getTextStartColorStyleable(), this.mTextColor), typedArray.getColor(styleable2.getTextCenterColorStyleable(), this.mTextColor), typedArray.getColor(styleable2.getTextEndColorStyleable(), this.mTextColor)} : new int[]{typedArray.getColor(styleable2.getTextStartColorStyleable(), this.mTextColor), typedArray.getColor(styleable2.getTextEndColorStyleable(), this.mTextColor)};
        }
        this.mTextGradientOrientation = typedArray.getColor(styleable2.getTextGradientOrientationStyleable(), 0);
        if (typedArray.hasValue(styleable2.getTextStrokeColorStyleable())) {
            this.mTextStrokeColor = typedArray.getColor(styleable2.getTextStrokeColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getTextStrokeSizeStyleable())) {
            this.mTextStrokeSize = typedArray.getDimensionPixelSize(styleable2.getTextStrokeSizeStyleable(), 0);
        }
    }

    public TextColorBuilder setTextColor(int color) {
        this.mTextColor = color;
        this.clearTextGradientColors();
        return this;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public TextColorBuilder setTextPressedColor(Integer color) {
        this.mTextPressedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextPressedColor() {
        return this.mTextPressedColor;
    }

    public TextColorBuilder setTextCheckedColor(Integer color) {
        this.mTextCheckedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextCheckedColor() {
        return this.mTextCheckedColor;
    }

    public TextColorBuilder setTextDisabledColor(Integer color) {
        this.mTextDisabledColor = color;
        return this;
    }

    @Nullable
    public Integer getTextDisabledColor() {
        return this.mTextDisabledColor;
    }

    public TextColorBuilder setTextFocusedColor(Integer color) {
        this.mTextFocusedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextFocusedColor() {
        return this.mTextFocusedColor;
    }

    public TextColorBuilder setTextSelectedColor(Integer color) {
        this.mTextSelectedColor = color;
        return this;
    }

    @Nullable
    public Integer getTextSelectedColor() {
        return this.mTextSelectedColor;
    }

    public TextColorBuilder setTextGradientColors(int startColor, int endColor) {
        return this.setTextGradientColors(new int[]{startColor, endColor});
    }

    public TextColorBuilder setTextGradientColors(int startColor, int centerColor, int endColor) {
        return this.setTextGradientColors(new int[]{startColor, centerColor, endColor});
    }

    public TextColorBuilder setTextGradientColors(int[] colors) {
        this.mTextGradientColors = colors;
        return this;
    }

    @Nullable
    public int[] getTextGradientColors() {
        return this.mTextGradientColors;
    }

    public boolean isTextGradientColors() {
        return this.mTextGradientColors != null && this.mTextGradientColors.length > 0;
    }

    public void clearTextGradientColors() {
        this.mTextGradientColors = null;
    }

    public TextColorBuilder setTextGradientOrientation(int orientation) {
        this.mTextGradientOrientation = orientation;
        return this;
    }

    public int getTextGradientOrientation() {
        return this.mTextGradientOrientation;
    }

    public TextColorBuilder setTextStrokeColor(int color) {
        this.mTextStrokeColor = color;
        return this;
    }

    public TextColorBuilder setTextStrokeSize(int size) {
        this.mTextStrokeSize = size;
        return this;
    }

    public int getTextStrokeColor() {
        return this.mTextStrokeColor;
    }

    public int getTextStrokeSize() {
        return this.mTextStrokeSize;
    }

    public boolean isTextStrokeColor() {
        return this.mTextStrokeColor != 0 && this.mTextStrokeSize > 0;
    }

    public void clearTextStrokeColor() {
        this.mTextStrokeColor = 0;
        this.mTextStrokeSize = 0;
    }

    public SpannableStringBuilder buildTextSpannable(CharSequence text) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        LinearGradientFontSpan linearGradientFontSpan = null;
        StrokeFontSpan strokeFontSpan = null;
        if (this.isTextGradientColors()) {
            linearGradientFontSpan = new LinearGradientFontSpan().setTextGradientColor(this.mTextGradientColors).setTextGradientOrientation(this.mTextGradientOrientation).setTextGradientPositions(null);
        }
        if (this.isTextStrokeColor()) {
            strokeFontSpan = new StrokeFontSpan().setTextStrokeColor(this.mTextStrokeColor).setTextStrokeSize(this.mTextStrokeSize);
        }
        if (linearGradientFontSpan != null && strokeFontSpan != null) {
            MultiFontSpan multiFontSpan = new MultiFontSpan(strokeFontSpan, linearGradientFontSpan);
            builder.setSpan((Object)multiFontSpan, 0, builder.length(), 33);
        } else if (linearGradientFontSpan != null) {
            builder.setSpan((Object)linearGradientFontSpan, 0, builder.length(), 33);
        } else if (strokeFontSpan != null) {
            builder.setSpan((Object)strokeFontSpan, 0, builder.length(), 33);
        }
        return builder;
    }

    public ColorStateList buildColorState() {
        int[] colors;
        int[][] states;
        if (this.mTextPressedColor == null && this.mTextCheckedColor == null && this.mTextDisabledColor == null && this.mTextFocusedColor == null && this.mTextSelectedColor == null) {
            return ColorStateList.valueOf((int)this.mTextColor);
        }
        int maxSize = 6;
        int arraySize = 0;
        int[][] statesTemp = new int[maxSize][];
        int[] colorsTemp = new int[maxSize];
        if (this.mTextPressedColor != null) {
            statesTemp[arraySize] = new int[]{16842919};
            colorsTemp[arraySize] = this.mTextPressedColor;
            ++arraySize;
        }
        if (this.mTextCheckedColor != null) {
            statesTemp[arraySize] = new int[]{0x10100A0};
            colorsTemp[arraySize] = this.mTextCheckedColor;
            ++arraySize;
        }
        if (this.mTextDisabledColor != null) {
            statesTemp[arraySize] = new int[]{-16842910};
            colorsTemp[arraySize] = this.mTextDisabledColor;
            ++arraySize;
        }
        if (this.mTextFocusedColor != null) {
            statesTemp[arraySize] = new int[]{16842908};
            colorsTemp[arraySize] = this.mTextFocusedColor;
            ++arraySize;
        }
        if (this.mTextSelectedColor != null) {
            statesTemp[arraySize] = new int[]{0x10100A1};
            colorsTemp[arraySize] = this.mTextSelectedColor;
            ++arraySize;
        }
        statesTemp[arraySize] = new int[0];
        colorsTemp[arraySize] = this.mTextColor;
        if (++arraySize == maxSize) {
            states = statesTemp;
            colors = colorsTemp;
        } else {
            states = new int[arraySize][];
            colors = new int[arraySize];
            System.arraycopy(statesTemp, 0, states, 0, arraySize);
            System.arraycopy(colorsTemp, 0, colors, 0, arraySize);
        }
        return new ColorStateList((int[][])states, colors);
    }

    public void intoTextColor() {
        if (this.isTextGradientColors() || this.isTextStrokeColor()) {
            this.mTextView.setText((CharSequence)this.buildTextSpannable(this.mTextView.getText()));
            return;
        }
        this.mTextView.setTextColor(this.buildColorState());
    }
}

