/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.builder;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.hjq.shape.drawable.ExtendStateListDrawable;
import com.hjq.shape.drawable.ShapeDrawable;
import com.hjq.shape.styleable.IShapeDrawableStyleable;

public final class ShapeDrawableBuilder {
    private static final int NO_COLOR = 0;
    private final View mView;
    private int mShape;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private Integer mSolidPressedColor;
    private Integer mSolidCheckedColor;
    private Integer mSolidDisabledColor;
    private Integer mSolidFocusedColor;
    private Integer mSolidSelectedColor;
    private float mTopLeftRadius;
    private float mTopRightRadius;
    private float mBottomLeftRadius;
    private float mBottomRightRadius;
    private int[] mSolidGradientColors;
    private int[] mStrokeGradientColors;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private Integer mStrokePressedColor;
    private Integer mStrokeCheckedColor;
    private Integer mStrokeDisabledColor;
    private Integer mStrokeFocusedColor;
    private Integer mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;
    private int mInnerRadius;
    private float mInnerRadiusRatio;
    private int mThickness;
    private float mThicknessRatio;
    private int mShadowSize;
    private int mShadowColor;
    private int mShadowOffsetX;
    private int mShadowOffsetY;

    public ShapeDrawableBuilder(View view, TypedArray typedArray, IShapeDrawableStyleable styleable2) {
        this.mView = view;
        this.mShape = typedArray.getInt(styleable2.getShapeTypeStyleable(), 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(styleable2.getShapeWidthStyleable(), -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(styleable2.getShapeHeightStyleable(), -1);
        this.mSolidColor = typedArray.getColor(styleable2.getSolidColorStyleable(), 0);
        if (typedArray.hasValue(styleable2.getSolidPressedColorStyleable())) {
            this.mSolidPressedColor = typedArray.getColor(styleable2.getSolidPressedColorStyleable(), 0);
        }
        if (styleable2.getSolidCheckedColorStyleable() > 0 && typedArray.hasValue(styleable2.getSolidCheckedColorStyleable())) {
            this.mSolidCheckedColor = typedArray.getColor(styleable2.getSolidCheckedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getSolidDisabledColorStyleable())) {
            this.mSolidDisabledColor = typedArray.getColor(styleable2.getSolidDisabledColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getSolidFocusedColorStyleable())) {
            this.mSolidFocusedColor = typedArray.getColor(styleable2.getSolidFocusedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getSolidSelectedColorStyleable())) {
            this.mSolidSelectedColor = typedArray.getColor(styleable2.getSolidSelectedColorStyleable(), 0);
        }
        int radius = typedArray.getDimensionPixelSize(styleable2.getRadiusStyleable(), 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(styleable2.getTopLeftRadiusStyleable(), radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(styleable2.getTopRightRadiusStyleable(), radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(styleable2.getBottomLeftRadiusStyleable(), radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(styleable2.getBottomRightRadiusStyleable(), radius);
        if (typedArray.hasValue(styleable2.getSolidStartColorStyleable()) && typedArray.hasValue(styleable2.getSolidEndColorStyleable())) {
            this.mSolidGradientColors = typedArray.hasValue(styleable2.getSolidCenterColorStyleable()) ? new int[]{typedArray.getColor(styleable2.getSolidStartColorStyleable(), 0), typedArray.getColor(styleable2.getSolidCenterColorStyleable(), 0), typedArray.getColor(styleable2.getSolidEndColorStyleable(), 0)} : new int[]{typedArray.getColor(styleable2.getSolidStartColorStyleable(), 0), typedArray.getColor(styleable2.getSolidEndColorStyleable(), 0)};
        }
        if (typedArray.hasValue(styleable2.getStrokeStartColorStyleable()) && typedArray.hasValue(styleable2.getStrokeEndColorStyleable())) {
            this.mStrokeGradientColors = typedArray.hasValue(styleable2.getStrokeCenterColorStyleable()) ? new int[]{typedArray.getColor(styleable2.getStrokeStartColorStyleable(), 0), typedArray.getColor(styleable2.getStrokeCenterColorStyleable(), 0), typedArray.getColor(styleable2.getStrokeEndColorStyleable(), 0)} : new int[]{typedArray.getColor(styleable2.getStrokeStartColorStyleable(), 0), typedArray.getColor(styleable2.getStrokeEndColorStyleable(), 0)};
        }
        this.mUseLevel = typedArray.getBoolean(styleable2.getUseLevelStyleable(), false);
        this.mAngle = (int)typedArray.getFloat(styleable2.getAngleStyleable(), 0.0f);
        this.mGradientType = typedArray.getInt(styleable2.getGradientTypeStyleable(), 0);
        this.mCenterX = typedArray.getFloat(styleable2.getCenterXStyleable(), 0.5f);
        this.mCenterY = typedArray.getFloat(styleable2.getCenterYStyleable(), 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(styleable2.getGradientRadiusStyleable(), radius);
        this.mStrokeColor = typedArray.getColor(styleable2.getStrokeColorStyleable(), 0);
        if (typedArray.hasValue(styleable2.getStrokePressedColorStyleable())) {
            this.mStrokePressedColor = typedArray.getColor(styleable2.getStrokePressedColorStyleable(), 0);
        }
        if (styleable2.getStrokeCheckedColorStyleable() > 0 && typedArray.hasValue(styleable2.getStrokeCheckedColorStyleable())) {
            this.mStrokeCheckedColor = typedArray.getColor(styleable2.getStrokeCheckedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeDisabledColorStyleable())) {
            this.mStrokeDisabledColor = typedArray.getColor(styleable2.getStrokeDisabledColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeFocusedColorStyleable())) {
            this.mStrokeFocusedColor = typedArray.getColor(styleable2.getStrokeFocusedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeSelectedColorStyleable())) {
            this.mStrokeSelectedColor = typedArray.getColor(styleable2.getStrokeSelectedColorStyleable(), 0);
        }
        this.mStrokeWidth = typedArray.getDimensionPixelSize(styleable2.getStrokeWidthStyleable(), 0);
        this.mDashWidth = typedArray.getDimensionPixelSize(styleable2.getDashWidthStyleable(), 0);
        this.mDashGap = typedArray.getDimensionPixelSize(styleable2.getDashGapStyleable(), 0);
        this.mInnerRadius = typedArray.getDimensionPixelOffset(styleable2.getInnerRadiusStyleable(), -1);
        this.mInnerRadiusRatio = typedArray.getFloat(styleable2.getInnerRadiusRatioStyleable(), 3.0f);
        this.mThickness = typedArray.getDimensionPixelOffset(styleable2.getThicknessStyleable(), -1);
        this.mThicknessRatio = typedArray.getFloat(styleable2.getThicknessRatioStyleable(), 9.0f);
        this.mShadowSize = typedArray.getDimensionPixelSize(styleable2.getShadowSizeStyleable(), 0);
        this.mShadowColor = typedArray.getColor(styleable2.getShadowColorStyleable(), 0x10000000);
        this.mShadowOffsetX = typedArray.getDimensionPixelOffset(styleable2.getShadowOffsetXStyleable(), 0);
        this.mShadowOffsetY = typedArray.getDimensionPixelOffset(styleable2.getShadowOffsetYStyleable(), 0);
    }

    public ShapeDrawableBuilder setShape(int shape) {
        this.mShape = shape;
        return this;
    }

    public int getShape() {
        return this.mShape;
    }

    public ShapeDrawableBuilder setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    public ShapeDrawableBuilder setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    public ShapeDrawableBuilder setSolidColor(int color) {
        this.mSolidColor = color;
        this.clearSolidGradientColors();
        return this;
    }

    public int getSolidColor() {
        return this.mSolidColor;
    }

    public ShapeDrawableBuilder setSolidPressedColor(Integer color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    public ShapeDrawableBuilder setSolidCheckedColor(Integer color) {
        this.mSolidCheckedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidCheckedColor() {
        return this.mSolidCheckedColor;
    }

    public ShapeDrawableBuilder setSolidDisabledColor(Integer color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    public ShapeDrawableBuilder setSolidFocusedColor(Integer color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    public ShapeDrawableBuilder setSolidSelectedColor(Integer color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    public ShapeDrawableBuilder setRadius(float radius) {
        return this.setRadius(radius, radius, radius, radius);
    }

    public ShapeDrawableBuilder setRadius(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        this.mTopLeftRadius = topLeftRadius;
        this.mTopRightRadius = topRightRadius;
        this.mBottomLeftRadius = bottomLeftRadius;
        this.mBottomRightRadius = bottomRightRadius;
        return this;
    }

    public ShapeDrawableBuilder setTopLeftRadius(float radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    public float getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    public ShapeDrawableBuilder setTopRightRadius(float radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    public float getTopRightRadius() {
        return this.mTopRightRadius;
    }

    public ShapeDrawableBuilder setBottomLeftRadius(float radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    public float getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    public ShapeDrawableBuilder setBottomRightRadius(float radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    public float getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    public ShapeDrawableBuilder setSolidGradientColors(int startColor, int endColor) {
        return this.setSolidGradientColors(new int[]{startColor, endColor});
    }

    public ShapeDrawableBuilder setSolidGradientColors(int startColor, int centerColor, int endColor) {
        return this.setSolidGradientColors(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawableBuilder setSolidGradientColors(int[] colors) {
        this.mSolidGradientColors = colors;
        return this;
    }

    @Nullable
    public int[] getSolidGradientColors() {
        return this.mSolidGradientColors;
    }

    public boolean isSolidGradientColors() {
        return this.mSolidGradientColors != null && this.mSolidGradientColors.length > 0;
    }

    public void clearSolidGradientColors() {
        this.mSolidGradientColors = null;
    }

    public ShapeDrawableBuilder setStrokeGradientColors(int startColor, int endColor) {
        return this.setStrokeGradientColors(new int[]{startColor, endColor});
    }

    public ShapeDrawableBuilder setStrokeGradientColors(int startColor, int centerColor, int endColor) {
        return this.setStrokeGradientColors(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawableBuilder setStrokeGradientColors(int[] colors) {
        this.mStrokeGradientColors = colors;
        return this;
    }

    @Nullable
    public int[] getStrokeGradientColors() {
        return this.mStrokeGradientColors;
    }

    public boolean isStrokeGradientColors() {
        return this.mStrokeGradientColors != null && this.mStrokeGradientColors.length > 0;
    }

    public void clearStrokeGradientColors() {
        this.mStrokeGradientColors = null;
    }

    public ShapeDrawableBuilder setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    public ShapeDrawableBuilder setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    public int getAngle() {
        return this.mAngle;
    }

    public ShapeDrawableBuilder setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    public int getGradientType() {
        return this.mGradientType;
    }

    public ShapeDrawableBuilder setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    public float getCenterX() {
        return this.mCenterX;
    }

    public ShapeDrawableBuilder setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    public float getCenterY() {
        return this.mCenterY;
    }

    public ShapeDrawableBuilder setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    public ShapeDrawableBuilder setStrokeColor(int color) {
        this.mStrokeColor = color;
        this.clearStrokeGradientColors();
        return this;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public ShapeDrawableBuilder setStrokePressedColor(Integer color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    public ShapeDrawableBuilder setStrokeCheckedColor(Integer color) {
        this.mStrokeCheckedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeCheckedColor() {
        return this.mStrokeCheckedColor;
    }

    public ShapeDrawableBuilder setStrokeDisabledColor(Integer color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    public ShapeDrawableBuilder setStrokeFocusedColor(Integer color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    public ShapeDrawableBuilder setStrokeSelectedColor(Integer color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    public ShapeDrawableBuilder setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public ShapeDrawableBuilder setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    public int getDashWidth() {
        return this.mDashWidth;
    }

    public ShapeDrawableBuilder setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    public int getDashGap() {
        return this.mDashGap;
    }

    public boolean isDashLineEnable() {
        return this.mDashGap > 0;
    }

    public ShapeDrawableBuilder setInnerRadius(int radius) {
        this.mInnerRadius = radius;
        return this;
    }

    public int getInnerRadius() {
        return this.mInnerRadius;
    }

    public ShapeDrawableBuilder setInnerRadiusRatio(float ratio) {
        this.mInnerRadiusRatio = ratio;
        return this;
    }

    public float getInnerRadiusRatio() {
        return this.mInnerRadiusRatio;
    }

    public ShapeDrawableBuilder setThickness(int size) {
        this.mThickness = size;
        return this;
    }

    public int getThickness() {
        return this.mThickness;
    }

    public ShapeDrawableBuilder setThicknessRatio(float ratio) {
        this.mThicknessRatio = ratio;
        return this;
    }

    public float getThicknessRatio() {
        return this.mThicknessRatio;
    }

    public boolean isShadowEnable() {
        return this.mShadowSize > 0;
    }

    public ShapeDrawableBuilder setShadowSize(int size) {
        this.mShadowSize = size;
        return this;
    }

    public int getShadowSize() {
        return this.mShadowSize;
    }

    public ShapeDrawableBuilder setShadowColor(int color) {
        this.mShadowColor = color;
        return this;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public ShapeDrawableBuilder setShadowOffsetX(int offsetX) {
        this.mShadowOffsetX = offsetX;
        return this;
    }

    public int getShadowOffsetX() {
        return this.mShadowOffsetX;
    }

    public ShapeDrawableBuilder setShadowOffsetY(int offsetY) {
        this.mShadowOffsetY = offsetY;
        return this;
    }

    public int getShadowOffsetY() {
        return this.mShadowOffsetY;
    }

    public Drawable buildBackgroundDrawable() {
        ShapeDrawable drawable;
        boolean hasStrokeColorState;
        boolean hasSolidColorState = this.mSolidPressedColor != null || this.mSolidCheckedColor != null || this.mSolidDisabledColor != null || this.mSolidFocusedColor != null || this.mSolidSelectedColor != null;
        boolean bl = hasStrokeColorState = this.mStrokePressedColor != null || this.mStrokeCheckedColor != null || this.mStrokeDisabledColor != null || this.mStrokeFocusedColor != null || this.mStrokeSelectedColor != null;
        if (!(this.isSolidGradientColors() || this.isStrokeGradientColors() || this.mSolidColor != 0 || hasSolidColorState || this.mStrokeColor != 0 || hasStrokeColorState)) {
            return null;
        }
        Drawable viewBackground = this.mView.getBackground();
        ShapeDrawable defaultDrawable = viewBackground instanceof ExtendStateListDrawable ? this.convertShapeDrawable(((ExtendStateListDrawable)viewBackground).getDefaultDrawable()) : this.convertShapeDrawable(viewBackground);
        this.refreshShapeDrawable(defaultDrawable, null, null);
        if (!hasSolidColorState && !hasStrokeColorState) {
            return defaultDrawable;
        }
        ExtendStateListDrawable stateListDrawable = new ExtendStateListDrawable();
        if (this.mSolidPressedColor != null || this.mStrokePressedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getPressedDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidPressedColor, this.mStrokePressedColor);
            stateListDrawable.setPressedDrawable(drawable);
        }
        if (this.mSolidCheckedColor != null || this.mStrokeCheckedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getCheckDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidCheckedColor, this.mStrokeCheckedColor);
            stateListDrawable.setCheckDrawable(drawable);
        }
        if (this.mSolidDisabledColor != null || this.mStrokeDisabledColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getDisabledDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidDisabledColor, this.mStrokeDisabledColor);
            stateListDrawable.setDisabledDrawable(drawable);
        }
        if (this.mSolidFocusedColor != null || this.mStrokeFocusedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getFocusedDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidFocusedColor, this.mStrokeFocusedColor);
            stateListDrawable.setFocusedDrawable(drawable);
        }
        if (this.mSolidSelectedColor != null || this.mStrokeSelectedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getSelectDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidSelectedColor, this.mStrokeSelectedColor);
            stateListDrawable.setSelectDrawable(drawable);
        }
        stateListDrawable.setDefaultDrawable(defaultDrawable);
        return stateListDrawable;
    }

    public void refreshShapeDrawable(ShapeDrawable drawable, @Nullable Integer solidStateColor, @Nullable Integer strokeStateColor) {
        drawable.setShape(this.mShape).setSize(this.mShapeWidth, this.mShapeHeight).setRadius(this.mTopLeftRadius, this.mTopRightRadius, this.mBottomLeftRadius, this.mBottomRightRadius).setUseLevel(this.mUseLevel).setStrokeWidth(this.mStrokeWidth).setStrokeDash(this.mDashWidth, this.mDashGap);
        drawable.setGradientAngle(this.mAngle).setGradientType(this.mGradientType).setGradientRadius(this.mGradientRadius).setGradientCenter(this.mCenterX, this.mCenterY);
        drawable.setInnerRadiusRatio(this.mInnerRadiusRatio).setInnerRadius(this.mInnerRadius).setThicknessRatio(this.mThicknessRatio).setThickness(this.mThickness);
        drawable.setShadowSize(this.mShadowSize).setShadowColor(this.mShadowColor).setShadowOffsetX(this.mShadowOffsetX).setShadowOffsetY(this.mShadowOffsetY);
        if (solidStateColor != null) {
            drawable.setSolidColor(solidStateColor);
        } else if (this.isSolidGradientColors()) {
            drawable.setSolidColor(this.mSolidGradientColors);
        } else {
            drawable.setSolidColor(this.mSolidColor);
        }
        if (strokeStateColor != null) {
            drawable.setStrokeColor(strokeStateColor);
        } else if (this.isStrokeGradientColors()) {
            drawable.setStrokeColor(this.mStrokeGradientColors);
        } else {
            drawable.setStrokeColor(this.mStrokeColor);
        }
    }

    @NonNull
    public ShapeDrawable convertShapeDrawable(Drawable drawable) {
        if (drawable instanceof ShapeDrawable) {
            return (ShapeDrawable)drawable;
        }
        return new ShapeDrawable();
    }

    public void intoBackground() {
        Drawable drawable = this.buildBackgroundDrawable();
        if (drawable == null) {
            return;
        }
        if (this.isDashLineEnable() || this.isShadowEnable()) {
            this.mView.setLayerType(1, null);
        }
        this.mView.setBackground(drawable);
    }
}

