/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatCheckBox;
import android.util.AttributeSet;
import android.widget.TextView;
import com.hjq.shape.R;
import com.hjq.shape.core.IShapeDrawable;
import com.hjq.shape.core.IShapeTextColor;

public class ShapeCheckBox
extends AppCompatCheckBox
implements IShapeDrawable<ShapeCheckBox>,
IShapeTextColor<ShapeCheckBox> {
    private int mShapeType;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private int mSolidPressedColor;
    private int mSolidCheckedColor;
    private int mSolidDisabledColor;
    private int mSolidFocusedColor;
    private int mSolidSelectedColor;
    private int mTopLeftRadius;
    private int mTopRightRadius;
    private int mBottomLeftRadius;
    private int mBottomRightRadius;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private int mStrokePressedColor;
    private int mStrokeCheckedColor;
    private int mStrokeDisabledColor;
    private int mStrokeFocusedColor;
    private int mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;
    private int mInnerRadius;
    private float mInnerRadiusRatio;
    private int mThickness;
    private float mThicknessRatio;
    private int mShadowSize;
    private int mShadowColor;
    private int mShadowOffsetX;
    private int mShadowOffsetY;
    private int mTextColor;
    private int mTextPressedColor;
    private int mTextCheckedColor;
    private int mTextDisabledColor;
    private int mTextFocusedColor;
    private int mTextSelectedColor;
    private int mTextStartColor;
    private int mTextCenterColor;
    private int mTextEndColor;
    private int mTextGradientOrientation;

    public ShapeCheckBox(Context context) {
        this(context, null);
    }

    public ShapeCheckBox(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.checkboxStyle);
    }

    public ShapeCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeCheckBox);
        this.mShapeType = typedArray.getInt(R.styleable.ShapeCheckBox_shape, 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_width, -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_height, -1);
        this.mSolidColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_solidColor, 0);
        this.mSolidPressedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_solidPressedColor, this.mSolidColor);
        this.mSolidCheckedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_solidCheckedColor, this.mSolidColor);
        this.mSolidDisabledColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_solidDisabledColor, this.mSolidColor);
        this.mSolidFocusedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_solidFocusedColor, this.mSolidColor);
        this.mSolidSelectedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_solidSelectedColor, this.mSolidColor);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_radius, 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_topLeftRadius, radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_topRightRadius, radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_bottomLeftRadius, radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_bottomRightRadius, radius);
        this.mStartColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_startColor, this.mSolidColor);
        this.mCenterColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_centerColor, this.mSolidColor);
        this.mEndColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_endColor, this.mSolidColor);
        this.mUseLevel = typedArray.getBoolean(R.styleable.ShapeCheckBox_shape_useLevel, false);
        this.mAngle = (int)typedArray.getFloat(R.styleable.ShapeCheckBox_shape_angle, 0.0f);
        this.mGradientType = typedArray.getInt(R.styleable.ShapeCheckBox_shape_gradientType, 0);
        this.mCenterX = typedArray.getFloat(R.styleable.ShapeCheckBox_shape_centerX, 0.5f);
        this.mCenterY = typedArray.getFloat(R.styleable.ShapeCheckBox_shape_centerY, 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_gradientRadius, radius);
        this.mStrokeColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_strokeColor, 0);
        this.mStrokePressedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_strokePressedColor, this.mStrokeColor);
        this.mStrokeCheckedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_strokeCheckedColor, this.mStrokeColor);
        this.mStrokeDisabledColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_strokeDisabledColor, this.mStrokeColor);
        this.mStrokeFocusedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_strokeFocusedColor, this.mStrokeColor);
        this.mStrokeSelectedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_strokeSelectedColor, this.mStrokeColor);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_strokeWidth, 0);
        this.mDashWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_dashWidth, 0);
        this.mDashGap = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_dashGap, 0);
        this.mInnerRadius = typedArray.getDimensionPixelOffset(R.styleable.ShapeCheckBox_shape_innerRadius, -1);
        this.mInnerRadiusRatio = typedArray.getFloat(R.styleable.ShapeCheckBox_shape_innerRadiusRatio, 3.0f);
        this.mThickness = typedArray.getDimensionPixelOffset(R.styleable.ShapeCheckBox_shape_thickness, -1);
        this.mThicknessRatio = typedArray.getFloat(R.styleable.ShapeCheckBox_shape_thicknessRatio, 9.0f);
        this.mShadowSize = typedArray.getDimensionPixelSize(R.styleable.ShapeCheckBox_shape_shadowSize, 0);
        this.mShadowColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_shadowColor, 0x10000000);
        this.mShadowOffsetX = typedArray.getDimensionPixelOffset(R.styleable.ShapeCheckBox_shape_shadowOffsetX, 0);
        this.mShadowOffsetY = typedArray.getDimensionPixelOffset(R.styleable.ShapeCheckBox_shape_shadowOffsetY, 0);
        this.mTextColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textColor, this.getTextColors().getDefaultColor());
        this.mTextPressedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textPressedColor, this.getTextColors().getColorForState(new int[]{16842919}, this.mTextColor));
        this.mTextCheckedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textCheckedColor, this.getTextColors().getColorForState(new int[]{0x10100A0}, this.mTextColor));
        this.mTextDisabledColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textDisabledColor, this.getTextColors().getColorForState(new int[]{-16842910}, this.mTextColor));
        this.mTextFocusedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textFocusedColor, this.getTextColors().getColorForState(new int[]{16842908}, this.mTextColor));
        this.mTextSelectedColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textSelectedColor, this.getTextColors().getColorForState(new int[]{0x10100A1}, this.mTextColor));
        this.mTextStartColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textStartColor, this.mTextColor);
        this.mTextCenterColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textCenterColor, this.mTextColor);
        this.mTextEndColor = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textEndColor, this.mTextColor);
        this.mTextGradientOrientation = typedArray.getColor(R.styleable.ShapeCheckBox_shape_textGradientOrientation, 0);
        typedArray.recycle();
        this.intoBackground();
        if (this.isTextGradientColor()) {
            this.setText(this.getText());
        } else {
            this.intoTextColor();
        }
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        this.mTextColor = color;
        this.clearTextGradientColor();
    }

    @Override
    public ShapeCheckBox setShapeType(int type) {
        this.mShapeType = type;
        return this;
    }

    @Override
    public int getShapeType() {
        return this.mShapeType;
    }

    @Override
    public ShapeCheckBox setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    @Override
    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    @Override
    public ShapeCheckBox setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    @Override
    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    @Override
    public ShapeCheckBox setSolidColor(int color) {
        if (this.mSolidPressedColor == this.mSolidColor) {
            this.mSolidPressedColor = color;
        }
        if (this.mSolidCheckedColor == this.mSolidColor) {
            this.mSolidCheckedColor = color;
        }
        if (this.mSolidDisabledColor == this.mSolidColor) {
            this.mSolidDisabledColor = color;
        }
        if (this.mSolidFocusedColor == this.mSolidColor) {
            this.mSolidFocusedColor = color;
        }
        if (this.mSolidSelectedColor == this.mSolidColor) {
            this.mSolidSelectedColor = color;
        }
        this.mSolidColor = color;
        this.mStartColor = color;
        this.mCenterColor = color;
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    public ShapeCheckBox setSolidPressedColor(int color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Override
    public int getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    @Override
    public ShapeCheckBox setSolidCheckedColor(int color) {
        this.mSolidCheckedColor = color;
        return this;
    }

    @Override
    public int getSolidCheckedColor() {
        return this.mSolidCheckedColor;
    }

    @Override
    public ShapeCheckBox setSolidDisabledColor(int color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Override
    public int getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    @Override
    public ShapeCheckBox setSolidFocusedColor(int color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Override
    public int getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    @Override
    public ShapeCheckBox setSolidSelectedColor(int color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Override
    public int getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    @Override
    public ShapeCheckBox setTopLeftRadius(int radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    @Override
    public int getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    @Override
    public ShapeCheckBox setTopRightRadius(int radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    @Override
    public int getTopRightRadius() {
        return this.mTopRightRadius;
    }

    @Override
    public ShapeCheckBox setBottomLeftRadius(int radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    @Override
    public int getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    @Override
    public ShapeCheckBox setBottomRightRadius(int radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    @Override
    public int getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    @Override
    public ShapeCheckBox setStartColor(int color) {
        this.mStartColor = color;
        return this;
    }

    @Override
    public int getStartColor() {
        return this.mStartColor;
    }

    @Override
    public ShapeCheckBox setCenterColor(int color) {
        this.mCenterColor = color;
        return this;
    }

    @Override
    public int getCenterColor() {
        return this.mCenterColor;
    }

    @Override
    public ShapeCheckBox setEndColor(int color) {
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getEndColor() {
        return this.mEndColor;
    }

    @Override
    public ShapeCheckBox setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    @Override
    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    @Override
    public ShapeCheckBox setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    @Override
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public ShapeCheckBox setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    @Override
    public int getGradientType() {
        return this.mGradientType;
    }

    @Override
    public ShapeCheckBox setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    @Override
    public float getCenterX() {
        return this.mCenterX;
    }

    @Override
    public ShapeCheckBox setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    @Override
    public float getCenterY() {
        return this.mCenterY;
    }

    @Override
    public ShapeCheckBox setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    @Override
    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    @Override
    public ShapeCheckBox setStrokeColor(int color) {
        if (this.mStrokePressedColor == this.mStrokeColor) {
            this.mStrokePressedColor = color;
        }
        if (this.mStrokeCheckedColor == this.mStrokeColor) {
            this.mStrokeCheckedColor = color;
        }
        if (this.mStrokeDisabledColor == this.mStrokeColor) {
            this.mStrokeDisabledColor = color;
        }
        if (this.mStrokeFocusedColor == this.mStrokeColor) {
            this.mStrokeFocusedColor = color;
        }
        if (this.mStrokeSelectedColor == this.mStrokeColor) {
            this.mStrokeSelectedColor = color;
        }
        this.mStrokeColor = color;
        return this;
    }

    @Override
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @Override
    public ShapeCheckBox setStrokePressedColor(int color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Override
    public int getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    @Override
    public ShapeCheckBox setStrokeCheckedColor(int color) {
        this.mStrokeCheckedColor = color;
        return this;
    }

    @Override
    public int getStrokeCheckedColor() {
        return this.mStrokeCheckedColor;
    }

    @Override
    public ShapeCheckBox setStrokeDisabledColor(int color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Override
    public int getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    @Override
    public ShapeCheckBox setStrokeFocusedColor(int color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Override
    public int getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    @Override
    public ShapeCheckBox setStrokeSelectedColor(int color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Override
    public int getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    @Override
    public ShapeCheckBox setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    @Override
    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    @Override
    public ShapeCheckBox setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    @Override
    public int getDashWidth() {
        return this.mDashWidth;
    }

    @Override
    public ShapeCheckBox setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    @Override
    public int getDashGap() {
        return this.mDashGap;
    }

    @Override
    public ShapeCheckBox setInnerRadius(int radius) {
        this.mInnerRadius = radius;
        return this;
    }

    @Override
    public int getInnerRadius() {
        return this.mInnerRadius;
    }

    @Override
    public ShapeCheckBox setInnerRadiusRatio(float ratio) {
        this.mInnerRadiusRatio = ratio;
        return this;
    }

    @Override
    public float getInnerRadiusRatio() {
        return this.mInnerRadiusRatio;
    }

    @Override
    public ShapeCheckBox setThickness(int size) {
        this.mThickness = size;
        return this;
    }

    @Override
    public int getThickness() {
        return this.mThickness;
    }

    @Override
    public ShapeCheckBox setThicknessRatio(float ratio) {
        this.mThicknessRatio = ratio;
        return this;
    }

    @Override
    public float getThicknessRatio() {
        return this.mThicknessRatio;
    }

    @Override
    public ShapeCheckBox setShadowSize(int size) {
        this.mShadowSize = size;
        return this;
    }

    @Override
    public int getShadowSize() {
        return this.mShadowSize;
    }

    @Override
    public ShapeCheckBox setShadowColor(int color) {
        this.mShadowColor = color;
        return this;
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    public int getTextShadowColor() {
        return super.getShadowColor();
    }

    @Override
    public ShapeCheckBox setShadowOffsetX(int offsetX) {
        this.mShadowOffsetX = offsetX;
        return this;
    }

    @Override
    public int getShadowOffsetX() {
        return this.mShadowOffsetX;
    }

    @Override
    public ShapeCheckBox setShadowOffsetY(int offsetY) {
        this.mShadowOffsetY = offsetY;
        return this;
    }

    @Override
    public int getShadowOffsetY() {
        return this.mShadowOffsetY;
    }

    @Override
    public void intoBackground() {
        Drawable drawable = this.buildBackgroundDrawable();
        if (drawable == null) {
            return;
        }
        if (this.isDashLineEnable() || this.isShadowEnable()) {
            this.setLayerType(1, null);
        }
        this.setBackground(drawable);
    }

    @Override
    public ShapeCheckBox setNormalTextColor(int color) {
        this.mTextColor = color;
        return this;
    }

    @Override
    public int getNormalTextColor() {
        return this.mTextColor;
    }

    @Override
    public ShapeCheckBox setTextPressedColor(int color) {
        this.mTextPressedColor = color;
        return this;
    }

    @Override
    public int getTextPressedColor() {
        return this.mTextPressedColor;
    }

    @Override
    public ShapeCheckBox setTextCheckedColor(int color) {
        this.mTextCheckedColor = color;
        return this;
    }

    @Override
    public int getTextCheckedColor() {
        return this.mTextCheckedColor;
    }

    @Override
    public ShapeCheckBox setTextDisabledColor(int color) {
        this.mTextDisabledColor = color;
        return this;
    }

    @Override
    public int getTextDisabledColor() {
        return this.mTextDisabledColor;
    }

    @Override
    public ShapeCheckBox setTextFocusedColor(int color) {
        this.mTextFocusedColor = color;
        return this;
    }

    @Override
    public int getTextFocusedColor() {
        return this.mTextFocusedColor;
    }

    @Override
    public ShapeCheckBox setTextSelectedColor(int color) {
        this.mTextSelectedColor = color;
        return this;
    }

    @Override
    public int getTextSelectedColor() {
        return this.mTextSelectedColor;
    }

    @Override
    public void intoTextColor() {
        this.setTextColor(this.buildColorState());
    }

    @Override
    public ShapeCheckBox setTextStartColor(int color) {
        this.mTextStartColor = color;
        return this;
    }

    @Override
    public int getTextStartColor() {
        return this.mTextStartColor;
    }

    @Override
    public ShapeCheckBox setTextCenterColor(int color) {
        this.mTextCenterColor = color;
        return this;
    }

    @Override
    public int getTextCenterColor() {
        return this.mTextCenterColor;
    }

    @Override
    public ShapeCheckBox setTextEndColor(int color) {
        this.mTextEndColor = color;
        return this;
    }

    @Override
    public int getTextEndColor() {
        return this.mTextEndColor;
    }

    @Override
    public ShapeCheckBox setTextGradientOrientation(int orientation) {
        this.mTextGradientOrientation = orientation;
        return this;
    }

    @Override
    public int getTextGradientOrientation() {
        return this.mTextGradientOrientation;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.isTextGradientColor()) {
            super.setText((CharSequence)this.buildLinearGradientSpannable(text), type);
        } else {
            super.setText(text, type);
        }
    }
}

