/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.hjq.shape.R;
import com.hjq.shape.core.IShapeDrawable;

public class ShapeLinearLayout
extends LinearLayout
implements IShapeDrawable<ShapeLinearLayout> {
    private int mShapeType;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private int mSolidPressedColor;
    private int mSolidDisabledColor;
    private int mSolidFocusedColor;
    private int mSolidSelectedColor;
    private int mTopLeftRadius;
    private int mTopRightRadius;
    private int mBottomLeftRadius;
    private int mBottomRightRadius;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private int mStrokePressedColor;
    private int mStrokeDisabledColor;
    private int mStrokeFocusedColor;
    private int mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;
    private int mInnerRadius;
    private float mInnerRadiusRatio;
    private int mThickness;
    private float mThicknessRatio;
    private int mShadowSize;
    private int mShadowColor;
    private int mShadowOffsetX;
    private int mShadowOffsetY;

    public ShapeLinearLayout(Context context) {
        this(context, null);
    }

    public ShapeLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeLinearLayout);
        this.mShapeType = typedArray.getInt(R.styleable.ShapeLinearLayout_shape, 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_width, -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_height, -1);
        this.mSolidColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_solidColor, 0);
        this.mSolidPressedColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_solidPressedColor, this.mSolidColor);
        this.mSolidDisabledColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_solidDisabledColor, this.mSolidColor);
        this.mSolidFocusedColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_solidFocusedColor, this.mSolidColor);
        this.mSolidSelectedColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_solidSelectedColor, this.mSolidColor);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_radius, 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_topLeftRadius, radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_topRightRadius, radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_bottomLeftRadius, radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_bottomRightRadius, radius);
        this.mStartColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_startColor, this.mSolidColor);
        this.mCenterColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_centerColor, this.mSolidColor);
        this.mEndColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_endColor, this.mSolidColor);
        this.mUseLevel = typedArray.getBoolean(R.styleable.ShapeLinearLayout_shape_useLevel, false);
        this.mAngle = (int)typedArray.getFloat(R.styleable.ShapeLinearLayout_shape_angle, 0.0f);
        this.mGradientType = typedArray.getInt(R.styleable.ShapeLinearLayout_shape_gradientType, 0);
        this.mCenterX = typedArray.getFloat(R.styleable.ShapeLinearLayout_shape_centerX, 0.5f);
        this.mCenterY = typedArray.getFloat(R.styleable.ShapeLinearLayout_shape_centerY, 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_gradientRadius, radius);
        this.mStrokeColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_strokeColor, 0);
        this.mStrokePressedColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_strokePressedColor, this.mStrokeColor);
        this.mStrokeDisabledColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_strokeDisabledColor, this.mStrokeColor);
        this.mStrokeFocusedColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_strokeFocusedColor, this.mStrokeColor);
        this.mStrokeSelectedColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_strokeSelectedColor, this.mStrokeColor);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_strokeWidth, 0);
        this.mDashWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_dashWidth, 0);
        this.mDashGap = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_dashGap, 0);
        this.mInnerRadius = typedArray.getDimensionPixelOffset(R.styleable.ShapeLinearLayout_shape_innerRadius, -1);
        this.mInnerRadiusRatio = typedArray.getFloat(R.styleable.ShapeLinearLayout_shape_innerRadiusRatio, 3.0f);
        this.mThickness = typedArray.getDimensionPixelOffset(R.styleable.ShapeLinearLayout_shape_thickness, -1);
        this.mThicknessRatio = typedArray.getFloat(R.styleable.ShapeLinearLayout_shape_thicknessRatio, 9.0f);
        this.mShadowSize = typedArray.getDimensionPixelSize(R.styleable.ShapeLinearLayout_shape_shadowSize, 0);
        this.mShadowColor = typedArray.getColor(R.styleable.ShapeLinearLayout_shape_shadowColor, 0x10000000);
        this.mShadowOffsetX = typedArray.getDimensionPixelOffset(R.styleable.ShapeLinearLayout_shape_shadowOffsetX, 0);
        this.mShadowOffsetY = typedArray.getDimensionPixelOffset(R.styleable.ShapeLinearLayout_shape_shadowOffsetY, 0);
        typedArray.recycle();
        this.intoBackground();
    }

    @Override
    public ShapeLinearLayout setShapeType(int type) {
        this.mShapeType = type;
        return this;
    }

    @Override
    public int getShapeType() {
        return this.mShapeType;
    }

    @Override
    public ShapeLinearLayout setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    @Override
    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    @Override
    public ShapeLinearLayout setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    @Override
    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    @Override
    public ShapeLinearLayout setSolidColor(int color) {
        if (this.mSolidPressedColor == this.mSolidColor) {
            this.mSolidPressedColor = color;
        }
        if (this.mSolidDisabledColor == this.mSolidColor) {
            this.mSolidDisabledColor = color;
        }
        if (this.mSolidFocusedColor == this.mSolidColor) {
            this.mSolidFocusedColor = color;
        }
        if (this.mSolidSelectedColor == this.mSolidColor) {
            this.mSolidSelectedColor = color;
        }
        this.mSolidColor = color;
        this.mStartColor = color;
        this.mCenterColor = color;
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    public ShapeLinearLayout setSolidPressedColor(int color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Override
    public int getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    @Override
    public ShapeLinearLayout setSolidDisabledColor(int color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Override
    public int getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    @Override
    public ShapeLinearLayout setSolidFocusedColor(int color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Override
    public int getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    @Override
    public ShapeLinearLayout setSolidSelectedColor(int color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Override
    public int getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    @Override
    public ShapeLinearLayout setTopLeftRadius(int radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    @Override
    public int getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    @Override
    public ShapeLinearLayout setTopRightRadius(int radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    @Override
    public int getTopRightRadius() {
        return this.mTopRightRadius;
    }

    @Override
    public ShapeLinearLayout setBottomLeftRadius(int radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    @Override
    public int getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    @Override
    public ShapeLinearLayout setBottomRightRadius(int radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    @Override
    public int getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    @Override
    public ShapeLinearLayout setStartColor(int color) {
        this.mStartColor = color;
        return this;
    }

    @Override
    public int getStartColor() {
        return this.mStartColor;
    }

    @Override
    public ShapeLinearLayout setCenterColor(int color) {
        this.mCenterColor = color;
        return this;
    }

    @Override
    public int getCenterColor() {
        return this.mCenterColor;
    }

    @Override
    public ShapeLinearLayout setEndColor(int color) {
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getEndColor() {
        return this.mEndColor;
    }

    @Override
    public ShapeLinearLayout setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    @Override
    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    @Override
    public ShapeLinearLayout setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    @Override
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public ShapeLinearLayout setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    @Override
    public int getGradientType() {
        return this.mGradientType;
    }

    @Override
    public ShapeLinearLayout setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    @Override
    public float getCenterX() {
        return this.mCenterX;
    }

    @Override
    public ShapeLinearLayout setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    @Override
    public float getCenterY() {
        return this.mCenterY;
    }

    @Override
    public ShapeLinearLayout setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    @Override
    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    @Override
    public ShapeLinearLayout setStrokeColor(int color) {
        if (this.mStrokePressedColor == this.mStrokeColor) {
            this.mStrokePressedColor = color;
        }
        if (this.mStrokeDisabledColor == this.mStrokeColor) {
            this.mStrokeDisabledColor = color;
        }
        if (this.mStrokeFocusedColor == this.mStrokeColor) {
            this.mStrokeFocusedColor = color;
        }
        if (this.mStrokeSelectedColor == this.mStrokeColor) {
            this.mStrokeSelectedColor = color;
        }
        this.mStrokeColor = color;
        return this;
    }

    @Override
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @Override
    public ShapeLinearLayout setStrokePressedColor(int color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Override
    public int getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    @Override
    public ShapeLinearLayout setStrokeDisabledColor(int color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Override
    public int getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    @Override
    public ShapeLinearLayout setStrokeFocusedColor(int color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Override
    public int getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    @Override
    public ShapeLinearLayout setStrokeSelectedColor(int color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Override
    public int getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    @Override
    public ShapeLinearLayout setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    @Override
    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    @Override
    public ShapeLinearLayout setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    @Override
    public int getDashWidth() {
        return this.mDashWidth;
    }

    @Override
    public ShapeLinearLayout setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    @Override
    public int getDashGap() {
        return this.mDashGap;
    }

    @Override
    public ShapeLinearLayout setInnerRadius(int radius) {
        this.mInnerRadius = radius;
        return this;
    }

    @Override
    public int getInnerRadius() {
        return this.mInnerRadius;
    }

    @Override
    public ShapeLinearLayout setInnerRadiusRatio(float ratio) {
        this.mInnerRadiusRatio = ratio;
        return this;
    }

    @Override
    public float getInnerRadiusRatio() {
        return this.mInnerRadiusRatio;
    }

    @Override
    public ShapeLinearLayout setThickness(int size) {
        this.mThickness = size;
        return this;
    }

    @Override
    public int getThickness() {
        return this.mThickness;
    }

    @Override
    public ShapeLinearLayout setThicknessRatio(float ratio) {
        this.mThicknessRatio = ratio;
        return this;
    }

    @Override
    public float getThicknessRatio() {
        return this.mThicknessRatio;
    }

    @Override
    public ShapeLinearLayout setShadowSize(int size) {
        this.mShadowSize = size;
        return this;
    }

    @Override
    public int getShadowSize() {
        return this.mShadowSize;
    }

    @Override
    public ShapeLinearLayout setShadowColor(int color) {
        this.mShadowColor = color;
        return this;
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    @Override
    public ShapeLinearLayout setShadowOffsetX(int offsetX) {
        this.mShadowOffsetX = offsetX;
        return this;
    }

    @Override
    public int getShadowOffsetX() {
        return this.mShadowOffsetX;
    }

    @Override
    public ShapeLinearLayout setShadowOffsetY(int offsetY) {
        this.mShadowOffsetY = offsetY;
        return this;
    }

    @Override
    public int getShadowOffsetY() {
        return this.mShadowOffsetY;
    }

    @Override
    public void intoBackground() {
        Drawable drawable = this.buildBackgroundDrawable();
        if (drawable == null) {
            return;
        }
        if (this.isDashLineEnable() || this.isShadowEnable()) {
            this.setLayerType(1, null);
        }
        this.setBackground(drawable);
    }
}

