/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.core;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import com.hjq.shape.core.ShapeDrawable;

public interface IShapeDrawable<V extends View> {
    public static final int DEFAULT_SHAPE_TYPE = 0;
    public static final int DEFAULT_SHAPE_WIDTH = -1;
    public static final int DEFAULT_SHAPE_HEIGHT = -1;
    public static final int DEFAULT_SHAPE_SOLID_COLOR = 0;
    public static final int DEFAULT_SHAPE_RADIUS = 0;
    public static final boolean DEFAULT_SHAPE_USE_LEVEL = false;
    public static final int DEFAULT_SHAPE_GRADIENT_TYPE = 0;
    public static final int DEFAULT_SHAPE_ANGLE = 0;
    public static final float DEFAULT_SHAPE_CENTER_X = 0.5f;
    public static final float DEFAULT_SHAPE_CENTER_Y = 0.5f;
    public static final int DEFAULT_SHAPE_STROKE_COLOR = 0;
    public static final int DEFAULT_SHAPE_STROKE_WIDTH = 0;
    public static final int DEFAULT_SHAPE_DASH_WIDTH = 0;
    public static final int DEFAULT_SHAPE_DASH_GAP = 0;
    public static final float DEFAULT_SHAPE_INNER_RADIUS_RATIO = 3.0f;
    public static final int DEFAULT_SHAPE_INNER_RADIUS = -1;
    public static final float DEFAULT_SHAPE_THICKNESS_RATIO = 9.0f;
    public static final int DEFAULT_SHAPE_THICKNESS = -1;
    public static final int DEFAULT_SHAPE_SHADOW_SIZE = 0;
    public static final int DEFAULT_SHAPE_SHADOW_COLOR = 0x10000000;
    public static final int DEFAULT_SHAPE_SHADOW_OFFSET_X = 0;
    public static final int DEFAULT_SHAPE_SHADOW_OFFSET_Y = 0;

    public V setShapeType(int var1);

    public int getShapeType();

    public V setShapeWidth(int var1);

    public int getShapeWidth();

    public V setShapeHeight(int var1);

    public int getShapeHeight();

    public V setSolidColor(int var1);

    public int getSolidColor();

    public V setSolidPressedColor(int var1);

    public int getSolidPressedColor();

    default public V setSolidCheckedColor(int color) {
        return this.setSolidColor(color);
    }

    default public int getSolidCheckedColor() {
        return this.getSolidColor();
    }

    public V setSolidDisabledColor(int var1);

    public int getSolidDisabledColor();

    public V setSolidFocusedColor(int var1);

    public int getSolidFocusedColor();

    public V setSolidSelectedColor(int var1);

    public int getSolidSelectedColor();

    default public V setRadius(int radius) {
        this.setTopLeftRadius(radius);
        this.setTopRightRadius(radius);
        this.setBottomLeftRadius(radius);
        return this.setBottomRightRadius(radius);
    }

    public V setTopLeftRadius(int var1);

    public int getTopLeftRadius();

    public V setTopRightRadius(int var1);

    public int getTopRightRadius();

    public V setBottomLeftRadius(int var1);

    public int getBottomLeftRadius();

    public V setBottomRightRadius(int var1);

    public int getBottomRightRadius();

    public V setStartColor(int var1);

    public int getStartColor();

    public V setCenterColor(int var1);

    public int getCenterColor();

    public V setEndColor(int var1);

    public int getEndColor();

    default public boolean isGradientColor() {
        return this.getSolidColor() != this.getStartColor() && this.getSolidColor() != this.getEndColor();
    }

    default public void clearGradientColor() {
        this.setStartColor(this.getSolidColor());
        this.setCenterColor(this.getSolidColor());
        this.setEndColor(this.getSolidColor());
    }

    public V setUseLevel(boolean var1);

    public boolean isUseLevel();

    public V setAngle(int var1);

    public int getAngle();

    public V setGradientType(int var1);

    public int getGradientType();

    public V setCenterX(float var1);

    public float getCenterX();

    public V setCenterY(float var1);

    public float getCenterY();

    public V setGradientRadius(int var1);

    public int getGradientRadius();

    public V setStrokeColor(int var1);

    public int getStrokeColor();

    public V setStrokePressedColor(int var1);

    public int getStrokePressedColor();

    default public V setStrokeCheckedColor(int color) {
        return this.setStrokeColor(color);
    }

    default public int getStrokeCheckedColor() {
        return this.getStrokeColor();
    }

    public V setStrokeDisabledColor(int var1);

    public int getStrokeDisabledColor();

    public V setStrokeFocusedColor(int var1);

    public int getStrokeFocusedColor();

    public V setStrokeSelectedColor(int var1);

    public int getStrokeSelectedColor();

    public V setStrokeWidth(int var1);

    public int getStrokeWidth();

    public V setDashWidth(int var1);

    public int getDashWidth();

    public V setDashGap(int var1);

    public int getDashGap();

    default public boolean isDashLineEnable() {
        return this.getDashGap() > 0;
    }

    public V setInnerRadius(int var1);

    public int getInnerRadius();

    public V setInnerRadiusRatio(float var1);

    public float getInnerRadiusRatio();

    public V setThickness(int var1);

    public int getThickness();

    public V setThicknessRatio(float var1);

    public float getThicknessRatio();

    default public boolean isShadowEnable() {
        return this.getShadowSize() > 0;
    }

    public V setShadowSize(int var1);

    public int getShadowSize();

    public V setShadowColor(int var1);

    public int getShadowColor();

    public V setShadowOffsetX(int var1);

    public int getShadowOffsetX();

    public V setShadowOffsetY(int var1);

    public int getShadowOffsetY();

    default public Drawable buildBackgroundDrawable() {
        if (!this.isGradientColor() && this.getSolidColor() == 0 && this.getStrokeColor() == 0) {
            return null;
        }
        ShapeDrawable defaultDrawable = this.createShapeDrawable(this.getSolidColor(), this.getStrokeColor());
        if (this.isGradientColor()) {
            if (this.getCenterColor() == this.getSolidColor()) {
                defaultDrawable.setColors(new int[]{this.getStartColor(), this.getEndColor()});
            } else {
                defaultDrawable.setColors(new int[]{this.getStartColor(), this.getCenterColor(), this.getEndColor()});
            }
        }
        if (this.getSolidColor() == this.getSolidPressedColor() && this.getStrokeColor() == this.getStrokePressedColor() && this.getSolidColor() == this.getSolidCheckedColor() && this.getStrokeColor() == this.getStrokeCheckedColor() && this.getSolidColor() == this.getSolidDisabledColor() && this.getStrokeColor() == this.getStrokeDisabledColor() && this.getSolidColor() == this.getSolidFocusedColor() && this.getStrokeColor() == this.getStrokeFocusedColor() && this.getSolidColor() == this.getSolidSelectedColor() && this.getStrokeColor() == this.getStrokeSelectedColor()) {
            return defaultDrawable;
        }
        StateListDrawable drawable = new StateListDrawable();
        if (this.getSolidColor() != this.getSolidPressedColor() || this.getStrokeColor() != this.getStrokePressedColor()) {
            drawable.addState(new int[]{16842919}, (Drawable)this.createShapeDrawable(this.getSolidPressedColor(), this.getStrokePressedColor()));
        }
        if (this.getSolidColor() != this.getSolidCheckedColor() || this.getStrokeColor() != this.getStrokeCheckedColor()) {
            drawable.addState(new int[]{0x10100A0}, (Drawable)this.createShapeDrawable(this.getSolidCheckedColor(), this.getStrokeCheckedColor()));
        }
        if (this.getSolidColor() != this.getSolidDisabledColor() || this.getStrokeColor() != this.getStrokeDisabledColor()) {
            drawable.addState(new int[]{-16842910}, (Drawable)this.createShapeDrawable(this.getSolidDisabledColor(), this.getStrokeDisabledColor()));
        }
        if (this.getSolidColor() != this.getSolidFocusedColor() || this.getStrokeColor() != this.getStrokeFocusedColor()) {
            drawable.addState(new int[]{16842908}, (Drawable)this.createShapeDrawable(this.getSolidFocusedColor(), this.getStrokeFocusedColor()));
        }
        if (this.getSolidColor() != this.getSolidSelectedColor() || this.getStrokeColor() != this.getStrokeSelectedColor()) {
            drawable.addState(new int[]{0x10100A1}, (Drawable)this.createShapeDrawable(this.getSolidSelectedColor(), this.getStrokeSelectedColor()));
        }
        drawable.addState(new int[0], (Drawable)defaultDrawable);
        return drawable;
    }

    default public ShapeDrawable createShapeDrawable(int solidColor, int strokeColor) {
        ShapeDrawable drawable = new ShapeDrawable();
        drawable.setShape(this.getShapeType());
        drawable.setSize(this.getShapeWidth(), this.getShapeHeight());
        drawable.setCornerRadii(new float[]{this.getTopLeftRadius(), this.getTopLeftRadius(), this.getTopRightRadius(), this.getTopRightRadius(), this.getBottomRightRadius(), this.getBottomRightRadius(), this.getBottomLeftRadius(), this.getBottomLeftRadius()});
        drawable.setColor(solidColor);
        drawable.setGradientCenter(this.getCenterX(), this.getCenterY());
        drawable.setUseLevel(this.isUseLevel());
        drawable.setGradientAngle(this.getAngle());
        drawable.setGradientType(this.getGradientType());
        drawable.setGradientRadius(this.getGradientRadius());
        drawable.setStroke(this.getStrokeWidth(), strokeColor, this.getDashWidth(), this.getDashGap());
        if (this.getShapeType() == 3) {
            drawable.setInnerRadiusRatio(this.getInnerRadiusRatio());
            drawable.setInnerRadius(this.getInnerRadius());
            drawable.setThicknessRatio(this.getThicknessRatio());
            drawable.setThickness(this.getThickness());
        }
        int shadowSize = this.getShadowSize();
        if (this.isShadowEnable()) {
            drawable.setShadowSize(shadowSize);
            drawable.setShadowColor(this.getShadowColor());
            drawable.setShadowOffsetX(this.getShadowOffsetX());
            drawable.setShadowOffsetY(this.getShadowOffsetY());
        }
        return drawable;
    }

    public void intoBackground();
}

