/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import com.hjq.shape.R;
import com.hjq.shape.core.IShapeDrawable;

public class ShapeConstraintLayout
extends ConstraintLayout
implements IShapeDrawable<ShapeConstraintLayout> {
    private int mShapeType;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private int mSolidPressedColor;
    private int mSolidDisabledColor;
    private int mSolidFocusedColor;
    private int mSolidSelectedColor;
    private int mTopLeftRadius;
    private int mTopRightRadius;
    private int mBottomLeftRadius;
    private int mBottomRightRadius;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private int mStrokePressedColor;
    private int mStrokeDisabledColor;
    private int mStrokeFocusedColor;
    private int mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;
    private int mInnerRadius;
    private float mInnerRadiusRatio;
    private int mThickness;
    private float mThicknessRatio;
    private int mShadowSize;
    private int mShadowColor;
    private int mShadowOffsetX;
    private int mShadowOffsetY;

    public ShapeConstraintLayout(Context context) {
        this(context, null);
    }

    public ShapeConstraintLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeConstraintLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeConstraintLayout);
        this.mShapeType = typedArray.getInt(R.styleable.ShapeConstraintLayout_shape, 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_width, -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_height, -1);
        this.mSolidColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_solidColor, 0);
        this.mSolidPressedColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_solidPressedColor, this.mSolidColor);
        this.mSolidDisabledColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_solidDisabledColor, this.mSolidColor);
        this.mSolidFocusedColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_solidFocusedColor, this.mSolidColor);
        this.mSolidSelectedColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_solidSelectedColor, this.mSolidColor);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_radius, 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_topLeftRadius, radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_topRightRadius, radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_bottomLeftRadius, radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_bottomRightRadius, radius);
        this.mStartColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_startColor, this.mSolidColor);
        this.mCenterColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_centerColor, this.mSolidColor);
        this.mEndColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_endColor, this.mSolidColor);
        this.mUseLevel = typedArray.getBoolean(R.styleable.ShapeConstraintLayout_shape_useLevel, false);
        this.mAngle = (int)typedArray.getFloat(R.styleable.ShapeConstraintLayout_shape_angle, 0.0f);
        this.mGradientType = typedArray.getInt(R.styleable.ShapeConstraintLayout_shape_gradientType, 0);
        this.mCenterX = typedArray.getFloat(R.styleable.ShapeConstraintLayout_shape_centerX, 0.5f);
        this.mCenterY = typedArray.getFloat(R.styleable.ShapeConstraintLayout_shape_centerY, 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_gradientRadius, radius);
        this.mStrokeColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_strokeColor, 0);
        this.mStrokePressedColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_strokePressedColor, this.mStrokeColor);
        this.mStrokeDisabledColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_strokeDisabledColor, this.mStrokeColor);
        this.mStrokeFocusedColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_strokeFocusedColor, this.mStrokeColor);
        this.mStrokeSelectedColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_strokeSelectedColor, this.mStrokeColor);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_strokeWidth, 0);
        this.mDashWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_dashWidth, 0);
        this.mDashGap = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_dashGap, 0);
        this.mInnerRadius = typedArray.getDimensionPixelOffset(R.styleable.ShapeConstraintLayout_shape_innerRadius, -1);
        this.mInnerRadiusRatio = typedArray.getFloat(R.styleable.ShapeConstraintLayout_shape_innerRadiusRatio, 3.0f);
        this.mThickness = typedArray.getDimensionPixelOffset(R.styleable.ShapeConstraintLayout_shape_thickness, -1);
        this.mThicknessRatio = typedArray.getFloat(R.styleable.ShapeConstraintLayout_shape_thicknessRatio, 9.0f);
        this.mShadowSize = typedArray.getDimensionPixelSize(R.styleable.ShapeConstraintLayout_shape_shadowSize, 0);
        this.mShadowColor = typedArray.getColor(R.styleable.ShapeConstraintLayout_shape_shadowColor, 0x10000000);
        this.mShadowOffsetX = typedArray.getDimensionPixelOffset(R.styleable.ShapeConstraintLayout_shape_shadowOffsetX, 0);
        this.mShadowOffsetY = typedArray.getDimensionPixelOffset(R.styleable.ShapeConstraintLayout_shape_shadowOffsetY, 0);
        typedArray.recycle();
        this.intoBackground();
    }

    @Override
    public ShapeConstraintLayout setShapeType(int type) {
        this.mShapeType = type;
        return this;
    }

    @Override
    public int getShapeType() {
        return this.mShapeType;
    }

    @Override
    public ShapeConstraintLayout setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    @Override
    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    @Override
    public ShapeConstraintLayout setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    @Override
    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    @Override
    public ShapeConstraintLayout setSolidColor(int color) {
        this.mSolidColor = color;
        return this;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    public ShapeConstraintLayout setSolidPressedColor(int color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Override
    public int getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    @Override
    public ShapeConstraintLayout setSolidDisabledColor(int color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Override
    public int getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    @Override
    public ShapeConstraintLayout setSolidFocusedColor(int color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Override
    public int getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    @Override
    public ShapeConstraintLayout setSolidSelectedColor(int color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Override
    public int getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    @Override
    public ShapeConstraintLayout setTopLeftRadius(int radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    @Override
    public int getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    @Override
    public ShapeConstraintLayout setTopRightRadius(int radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    @Override
    public int getTopRightRadius() {
        return this.mTopRightRadius;
    }

    @Override
    public ShapeConstraintLayout setBottomLeftRadius(int radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    @Override
    public int getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    @Override
    public ShapeConstraintLayout setBottomRightRadius(int radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    @Override
    public int getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    @Override
    public ShapeConstraintLayout setStartColor(int color) {
        this.mStartColor = color;
        return this;
    }

    @Override
    public int getStartColor() {
        return this.mStartColor;
    }

    @Override
    public ShapeConstraintLayout setCenterColor(int color) {
        this.mCenterColor = color;
        return this;
    }

    @Override
    public int getCenterColor() {
        return this.mCenterColor;
    }

    @Override
    public ShapeConstraintLayout setEndColor(int color) {
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getEndColor() {
        return this.mEndColor;
    }

    @Override
    public ShapeConstraintLayout setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    @Override
    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    @Override
    public ShapeConstraintLayout setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    @Override
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public ShapeConstraintLayout setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    @Override
    public int getGradientType() {
        return this.mGradientType;
    }

    @Override
    public ShapeConstraintLayout setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    @Override
    public float getCenterX() {
        return this.mCenterX;
    }

    @Override
    public ShapeConstraintLayout setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    @Override
    public float getCenterY() {
        return this.mCenterY;
    }

    @Override
    public ShapeConstraintLayout setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    @Override
    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    @Override
    public ShapeConstraintLayout setStrokeColor(int color) {
        this.mStrokeColor = color;
        return this;
    }

    @Override
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @Override
    public ShapeConstraintLayout setStrokePressedColor(int color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Override
    public int getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    @Override
    public ShapeConstraintLayout setStrokeDisabledColor(int color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Override
    public int getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    @Override
    public ShapeConstraintLayout setStrokeFocusedColor(int color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Override
    public int getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    @Override
    public ShapeConstraintLayout setStrokeSelectedColor(int color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Override
    public int getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    @Override
    public ShapeConstraintLayout setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    @Override
    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    @Override
    public ShapeConstraintLayout setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    @Override
    public int getDashWidth() {
        return this.mDashWidth;
    }

    @Override
    public ShapeConstraintLayout setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    @Override
    public int getDashGap() {
        return this.mDashGap;
    }

    @Override
    public ShapeConstraintLayout setInnerRadius(int radius) {
        this.mInnerRadius = radius;
        return this;
    }

    @Override
    public int getInnerRadius() {
        return this.mInnerRadius;
    }

    @Override
    public ShapeConstraintLayout setInnerRadiusRatio(float ratio) {
        this.mInnerRadiusRatio = ratio;
        return this;
    }

    @Override
    public float getInnerRadiusRatio() {
        return this.mInnerRadiusRatio;
    }

    @Override
    public ShapeConstraintLayout setThickness(int size) {
        this.mThickness = size;
        return this;
    }

    @Override
    public int getThickness() {
        return this.mThickness;
    }

    @Override
    public ShapeConstraintLayout setThicknessRatio(float ratio) {
        this.mThicknessRatio = ratio;
        return this;
    }

    @Override
    public float getThicknessRatio() {
        return this.mThicknessRatio;
    }

    @Override
    public ShapeConstraintLayout setShadowSize(int size) {
        this.mShadowSize = size;
        return this;
    }

    @Override
    public int getShadowSize() {
        return this.mShadowSize;
    }

    @Override
    public ShapeConstraintLayout setShadowColor(int color) {
        this.mShadowColor = color;
        return this;
    }

    @Override
    public int getShadowColor() {
        return this.mShadowColor;
    }

    @Override
    public ShapeConstraintLayout setShadowOffsetX(int offsetX) {
        this.mShadowOffsetX = offsetX;
        return this;
    }

    @Override
    public int getShadowOffsetX() {
        return this.mShadowOffsetX;
    }

    @Override
    public ShapeConstraintLayout setShadowOffsetY(int offsetY) {
        this.mShadowOffsetY = offsetY;
        return this;
    }

    @Override
    public int getShadowOffsetY() {
        return this.mShadowOffsetY;
    }

    @Override
    public void intoBackground() {
        Drawable drawable = this.buildBackgroundDrawable();
        if (drawable == null) {
            return;
        }
        if (this.isShadowEnable()) {
            this.setLayerType(1, null);
        }
        this.setBackground(drawable);
    }
}

