/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.core;

import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.hjq.shape.core.ShapeDrawable;
import com.hjq.shape.core.ShapeGradientOrientation;

public class ShapeState
extends Drawable.ConstantState {
    public int mChangingConfigurations;
    public int mShapeType = 0;
    public int mGradient = 0;
    public ShapeGradientOrientation mOrientation;
    public int[] mColors;
    public int[] mTempColors;
    public float[] mTempPositions;
    public float[] mPositions;
    public boolean mHasSolidColor;
    public int mSolidColor;
    public int mStrokeWidth = -1;
    public int mStrokeColor;
    public float mStrokeDashWidth;
    public float mStrokeDashGap;
    public float mRadius;
    public float[] mRadiusArray;
    public Rect mPadding;
    public int mWidth = -1;
    public int mHeight = -1;
    public float mInnerRadiusRatio;
    public float mThicknessRatio;
    public int mInnerRadius;
    public int mThickness;
    public float mCenterX = 0.5f;
    public float mCenterY = 0.5f;
    public float mGradientRadius = 0.5f;
    public boolean mUseLevel;
    public boolean mUseLevelForShape;
    public boolean mOpaque;
    public int mShadowSize;
    public int mShadowColor;
    public int mShadowOffsetX;
    public int mShadowOffsetY;

    public ShapeState(ShapeGradientOrientation orientation, int[] colors) {
        this.mOrientation = orientation;
        this.setColors(colors);
    }

    public ShapeState(ShapeState state) {
        this.mChangingConfigurations = state.mChangingConfigurations;
        this.mShapeType = state.mShapeType;
        this.mGradient = state.mGradient;
        this.mOrientation = state.mOrientation;
        if (state.mColors != null) {
            this.mColors = (int[])state.mColors.clone();
        }
        if (state.mPositions != null) {
            this.mPositions = (float[])state.mPositions.clone();
        }
        this.mHasSolidColor = state.mHasSolidColor;
        this.mSolidColor = state.mSolidColor;
        this.mStrokeWidth = state.mStrokeWidth;
        this.mStrokeColor = state.mStrokeColor;
        this.mStrokeDashWidth = state.mStrokeDashWidth;
        this.mStrokeDashGap = state.mStrokeDashGap;
        this.mRadius = state.mRadius;
        if (state.mRadiusArray != null) {
            this.mRadiusArray = (float[])state.mRadiusArray.clone();
        }
        if (state.mPadding != null) {
            this.mPadding = new Rect(state.mPadding);
        }
        this.mWidth = state.mWidth;
        this.mHeight = state.mHeight;
        this.mInnerRadiusRatio = state.mInnerRadiusRatio;
        this.mThicknessRatio = state.mThicknessRatio;
        this.mInnerRadius = state.mInnerRadius;
        this.mThickness = state.mThickness;
        this.mCenterX = state.mCenterX;
        this.mCenterY = state.mCenterY;
        this.mGradientRadius = state.mGradientRadius;
        this.mUseLevel = state.mUseLevel;
        this.mUseLevelForShape = state.mUseLevelForShape;
        this.mOpaque = state.mOpaque;
        this.mShadowSize = state.mShadowSize;
        this.mShadowColor = state.mShadowColor;
        this.mShadowOffsetX = state.mShadowOffsetX;
        this.mShadowOffsetY = state.mShadowOffsetY;
    }

    public Drawable newDrawable() {
        return new ShapeDrawable(this);
    }

    public Drawable newDrawable(Resources res) {
        return new ShapeDrawable(this);
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void setShapeType(int type) {
        this.mShapeType = type;
        this.computeOpacity();
    }

    public void setGradientType(int gradient) {
        this.mGradient = gradient;
    }

    public void setGradientCenter(float x, float y) {
        this.mCenterX = x;
        this.mCenterY = y;
    }

    public void setColors(int[] colors) {
        this.mHasSolidColor = false;
        this.mColors = colors;
        this.computeOpacity();
    }

    public void setSolidColor(int argb) {
        this.mHasSolidColor = true;
        this.mSolidColor = argb;
        this.mColors = null;
        this.computeOpacity();
    }

    private void computeOpacity() {
        if (this.mShapeType != 0) {
            this.mOpaque = false;
            return;
        }
        if (this.mRadius > 0.0f || this.mRadiusArray != null) {
            this.mOpaque = false;
            return;
        }
        if (this.mStrokeWidth > 0 && !ShapeState.isOpaque(this.mStrokeColor)) {
            this.mOpaque = false;
            return;
        }
        if (this.mHasSolidColor) {
            this.mOpaque = ShapeState.isOpaque(this.mSolidColor);
            return;
        }
        if (this.mColors != null) {
            for (int color : this.mColors) {
                if (ShapeState.isOpaque(color)) continue;
                this.mOpaque = false;
                return;
            }
        }
        this.mOpaque = true;
    }

    private static boolean isOpaque(int color) {
        return (color >> 24 & 0xFF) == 255;
    }

    public void setStroke(int width, int color) {
        this.mStrokeWidth = width;
        this.mStrokeColor = color;
        this.computeOpacity();
    }

    public void setStroke(int width, int color, float dashWidth, float dashGap) {
        this.mStrokeWidth = width;
        this.mStrokeColor = color;
        this.mStrokeDashWidth = dashWidth;
        this.mStrokeDashGap = dashGap;
        this.computeOpacity();
    }

    public void setCornerRadius(float radius) {
        if (radius < 0.0f) {
            radius = 0.0f;
        }
        this.mRadius = radius;
        this.mRadiusArray = null;
    }

    public void setCornerRadii(float[] radii) {
        this.mRadiusArray = radii;
        if (radii == null) {
            this.mRadius = 0.0f;
        }
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setGradientRadius(float gradientRadius) {
        this.mGradientRadius = gradientRadius;
    }

    public void setShadowColor(int color) {
        this.mShadowColor = color;
    }

    public void setShadowSize(int size) {
        this.mShadowSize = size;
    }

    public void setShadowOffsetX(int offsetX) {
        this.mShadowOffsetX = offsetX;
    }

    public void setShadowOffsetY(int offsetY) {
        this.mShadowOffsetY = offsetY;
    }
}

