/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import com.hjq.shape.IShapeDrawable;
import com.hjq.shape.R;

public class ShapeView
extends View
implements IShapeDrawable<ShapeView> {
    private int mShape;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private int mSolidPressedColor;
    private int mSolidDisabledColor;
    private int mSolidFocusedColor;
    private int mSolidSelectedColor;
    private int mTopLeftRadius;
    private int mTopRightRadius;
    private int mBottomLeftRadius;
    private int mBottomRightRadius;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private int mStrokePressedColor;
    private int mStrokeDisabledColor;
    private int mStrokeFocusedColor;
    private int mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;

    public ShapeView(Context context) {
        this(context, null);
    }

    public ShapeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeView);
        this.mShape = typedArray.getInt(R.styleable.ShapeView_shape, 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_width, -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_height, -1);
        this.mSolidColor = typedArray.getColor(R.styleable.ShapeView_shape_solidColor, 0);
        this.mSolidPressedColor = typedArray.getColor(R.styleable.ShapeView_shape_solidPressedColor, this.mSolidColor);
        this.mSolidDisabledColor = typedArray.getColor(R.styleable.ShapeView_shape_solidDisabledColor, this.mSolidColor);
        this.mSolidFocusedColor = typedArray.getColor(R.styleable.ShapeView_shape_solidFocusedColor, this.mSolidColor);
        this.mSolidSelectedColor = typedArray.getColor(R.styleable.ShapeView_shape_solidSelectedColor, this.mSolidColor);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_radius, 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_topLeftRadius, radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_topRightRadius, radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_bottomLeftRadius, radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_bottomRightRadius, radius);
        this.mStartColor = typedArray.getColor(R.styleable.ShapeView_shape_startColor, 0);
        this.mCenterColor = typedArray.getColor(R.styleable.ShapeView_shape_centerColor, 0);
        this.mEndColor = typedArray.getColor(R.styleable.ShapeView_shape_endColor, 0);
        this.mUseLevel = typedArray.getBoolean(R.styleable.ShapeView_shape_useLevel, false);
        this.mAngle = (int)typedArray.getFloat(R.styleable.ShapeView_shape_angle, 0.0f);
        this.mGradientType = typedArray.getInt(R.styleable.ShapeView_shape_gradientType, 0);
        this.mCenterX = typedArray.getFloat(R.styleable.ShapeView_shape_centerX, 0.5f);
        this.mCenterY = typedArray.getFloat(R.styleable.ShapeView_shape_centerX, 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_gradientRadius, radius);
        this.mStrokeColor = typedArray.getColor(R.styleable.ShapeView_shape_strokeColor, 0);
        this.mStrokePressedColor = typedArray.getColor(R.styleable.ShapeView_shape_strokePressedColor, this.mStrokeColor);
        this.mStrokeDisabledColor = typedArray.getColor(R.styleable.ShapeView_shape_strokeDisabledColor, this.mStrokeColor);
        this.mStrokeFocusedColor = typedArray.getColor(R.styleable.ShapeView_shape_strokeFocusedColor, this.mStrokeColor);
        this.mStrokeSelectedColor = typedArray.getColor(R.styleable.ShapeView_shape_strokeSelectedColor, this.mStrokeColor);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shape_strokeWidth, 0);
        this.mDashWidth = (int)typedArray.getDimension(R.styleable.ShapeView_shape_dashWidth, 0.0f);
        this.mDashGap = (int)typedArray.getDimension(R.styleable.ShapeView_shape_dashGap, 0.0f);
        typedArray.recycle();
        if (this.getBackground() == null) {
            this.intoBackground();
        }
    }

    @Override
    public ShapeView setShape(int shape) {
        this.mShape = shape;
        return this;
    }

    @Override
    public int getShape() {
        return this.mShape;
    }

    @Override
    public ShapeView setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    @Override
    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    @Override
    public ShapeView setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    @Override
    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    @Override
    public ShapeView setSolidColor(int color) {
        this.mSolidColor = color;
        return this;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    public ShapeView setSolidPressedColor(int color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Override
    public int getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    @Override
    public ShapeView setSolidDisabledColor(int color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Override
    public int getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    @Override
    public ShapeView setSolidFocusedColor(int color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Override
    public int getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    @Override
    public ShapeView setSolidSelectedColor(int color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Override
    public int getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    @Override
    public ShapeView setTopLeftRadius(int radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    @Override
    public int getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    @Override
    public ShapeView setTopRightRadius(int radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    @Override
    public int getTopRightRadius() {
        return this.mTopRightRadius;
    }

    @Override
    public ShapeView setBottomLeftRadius(int radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    @Override
    public int getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    @Override
    public ShapeView setBottomRightRadius(int radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    @Override
    public int getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    @Override
    public ShapeView setStartColor(int color) {
        this.mStartColor = color;
        return this;
    }

    @Override
    public int getStartColor() {
        return this.mStartColor;
    }

    @Override
    public ShapeView setCenterColor(int color) {
        this.mCenterColor = color;
        return this;
    }

    @Override
    public int getCenterColor() {
        return this.mCenterColor;
    }

    @Override
    public ShapeView setEndColor(int color) {
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getEndColor() {
        return this.mEndColor;
    }

    @Override
    public ShapeView setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    @Override
    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    @Override
    public ShapeView setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    @Override
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public ShapeView setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    @Override
    public int getGradientType() {
        return this.mGradientType;
    }

    @Override
    public ShapeView setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    @Override
    public float getCenterX() {
        return this.mCenterX;
    }

    @Override
    public ShapeView setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    @Override
    public float getCenterY() {
        return this.mCenterY;
    }

    @Override
    public ShapeView setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    @Override
    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    @Override
    public ShapeView setStrokeColor(int color) {
        this.mStrokeColor = color;
        return this;
    }

    @Override
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @Override
    public ShapeView setStrokePressedColor(int color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Override
    public int getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    @Override
    public ShapeView setStrokeDisabledColor(int color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Override
    public int getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    @Override
    public ShapeView setStrokeFocusedColor(int color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Override
    public int getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    @Override
    public ShapeView setStrokeSelectedColor(int color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Override
    public int getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    @Override
    public ShapeView setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    @Override
    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    @Override
    public ShapeView setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    @Override
    public int getDashWidth() {
        return this.mDashWidth;
    }

    @Override
    public ShapeView setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    @Override
    public int getDashGap() {
        return this.mDashGap;
    }

    @Override
    public void intoBackground() {
        this.setBackground(this.buildDrawable());
    }
}

