/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.builder;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.hjq.shape.config.IShapeDrawableStyleable;
import com.hjq.shape.drawable.ShapeDrawable;
import com.hjq.shape.drawable.ShapeGradientOrientation;
import com.hjq.shape.other.ExtendStateListDrawable;

public final class ShapeDrawableBuilder {
    private static final int NO_COLOR = 0;
    private final View mView;
    private int mType;
    private int mWidth;
    private int mHeight;
    private int mSolidColor;
    private Integer mSolidPressedColor;
    private Integer mSolidCheckedColor;
    private Integer mSolidDisabledColor;
    private Integer mSolidFocusedColor;
    private Integer mSolidSelectedColor;
    private float mTopLeftRadius;
    private float mTopRightRadius;
    private float mBottomLeftRadius;
    private float mBottomRightRadius;
    private int[] mSolidGradientColors;
    private ShapeGradientOrientation mSolidGradientOrientation;
    private int mSolidGradientType;
    private float mSolidGradientCenterX;
    private float mSolidGradientCenterY;
    private int mSolidGradientRadius;
    private int mStrokeColor;
    private Integer mStrokePressedColor;
    private Integer mStrokeCheckedColor;
    private Integer mStrokeDisabledColor;
    private Integer mStrokeFocusedColor;
    private Integer mStrokeSelectedColor;
    private int[] mStrokeGradientColors;
    private ShapeGradientOrientation mStrokeGradientOrientation;
    private int mStrokeSize;
    private int mStrokeDashSize;
    private int mStrokeDashGap;
    private int mShadowSize;
    private int mShadowColor;
    private int mShadowOffsetX;
    private int mShadowOffsetY;
    private int mRingInnerRadiusSize;
    private float mRingInnerRadiusRatio;
    private int mRingThicknessSize;
    private float mRingThicknessRatio;
    private int mLineGravity;

    public ShapeDrawableBuilder(View view, TypedArray typedArray, IShapeDrawableStyleable styleable2) {
        this.mView = view;
        this.mType = typedArray.getInt(styleable2.getShapeTypeStyleable(), 0);
        this.mWidth = typedArray.getDimensionPixelSize(styleable2.getShapeWidthStyleable(), -1);
        this.mHeight = typedArray.getDimensionPixelSize(styleable2.getShapeHeightStyleable(), -1);
        this.mSolidColor = typedArray.getColor(styleable2.getSolidColorStyleable(), 0);
        if (typedArray.hasValue(styleable2.getSolidPressedColorStyleable())) {
            this.mSolidPressedColor = typedArray.getColor(styleable2.getSolidPressedColorStyleable(), 0);
        }
        if (styleable2.getSolidCheckedColorStyleable() > 0 && typedArray.hasValue(styleable2.getSolidCheckedColorStyleable())) {
            this.mSolidCheckedColor = typedArray.getColor(styleable2.getSolidCheckedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getSolidDisabledColorStyleable())) {
            this.mSolidDisabledColor = typedArray.getColor(styleable2.getSolidDisabledColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getSolidFocusedColorStyleable())) {
            this.mSolidFocusedColor = typedArray.getColor(styleable2.getSolidFocusedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getSolidSelectedColorStyleable())) {
            this.mSolidSelectedColor = typedArray.getColor(styleable2.getSolidSelectedColorStyleable(), 0);
        }
        int layoutDirection = ShapeDrawableBuilder.getLayoutDirection(view);
        int radius = typedArray.getDimensionPixelSize(styleable2.getRadiusStyleable(), 0);
        this.mBottomLeftRadius = this.mBottomRightRadius = (float)radius;
        this.mTopRightRadius = this.mBottomRightRadius;
        this.mTopLeftRadius = this.mBottomRightRadius;
        if (typedArray.hasValue(styleable2.getRadiusInTopStartStyleable())) {
            switch (layoutDirection) {
                case 1: {
                    this.mTopRightRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInTopStartStyleable(), radius);
                    break;
                }
                default: {
                    this.mTopLeftRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInTopStartStyleable(), radius);
                }
            }
        }
        if (typedArray.hasValue(styleable2.getRadiusInTopEndStyleable())) {
            switch (layoutDirection) {
                case 1: {
                    this.mTopLeftRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInTopEndStyleable(), radius);
                    break;
                }
                default: {
                    this.mTopRightRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInTopEndStyleable(), radius);
                }
            }
        }
        if (typedArray.hasValue(styleable2.getRadiusInBottomStartStyleable())) {
            switch (layoutDirection) {
                case 1: {
                    this.mBottomRightRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInBottomStartStyleable(), radius);
                    break;
                }
                default: {
                    this.mBottomLeftRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInBottomStartStyleable(), radius);
                }
            }
        }
        if (typedArray.hasValue(styleable2.getRadiusInBottomEndStyleable())) {
            switch (layoutDirection) {
                case 1: {
                    this.mBottomLeftRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInBottomEndStyleable(), radius);
                    break;
                }
                default: {
                    this.mBottomRightRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInBottomEndStyleable(), radius);
                }
            }
        }
        if (typedArray.hasValue(styleable2.getRadiusInTopLeftStyleable())) {
            this.mTopLeftRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInTopLeftStyleable(), radius);
        }
        if (typedArray.hasValue(styleable2.getRadiusInTopRightStyleable())) {
            this.mTopRightRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInTopRightStyleable(), radius);
        }
        if (typedArray.hasValue(styleable2.getRadiusInBottomLeftStyleable())) {
            this.mBottomLeftRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInBottomLeftStyleable(), radius);
        }
        if (typedArray.hasValue(styleable2.getRadiusInBottomRightStyleable())) {
            this.mBottomRightRadius = typedArray.getDimensionPixelSize(styleable2.getRadiusInBottomRightStyleable(), radius);
        }
        if (typedArray.hasValue(styleable2.getSolidGradientStartColorStyleable()) && typedArray.hasValue(styleable2.getSolidGradientEndColorStyleable())) {
            this.mSolidGradientColors = typedArray.hasValue(styleable2.getSolidGradientCenterColorStyleable()) ? new int[]{typedArray.getColor(styleable2.getSolidGradientStartColorStyleable(), 0), typedArray.getColor(styleable2.getSolidGradientCenterColorStyleable(), 0), typedArray.getColor(styleable2.getSolidGradientEndColorStyleable(), 0)} : new int[]{typedArray.getColor(styleable2.getSolidGradientStartColorStyleable(), 0), typedArray.getColor(styleable2.getSolidGradientEndColorStyleable(), 0)};
        }
        this.mSolidGradientOrientation = this.transformGradientOrientation(typedArray.getInt(styleable2.getSolidGradientOrientationStyleable(), this.getDefaultGradientOrientation()));
        this.mSolidGradientType = typedArray.getInt(styleable2.getSolidGradientTypeStyleable(), 0);
        this.mSolidGradientCenterX = typedArray.getFloat(styleable2.getSolidGradientCenterXStyleable(), 0.5f);
        this.mSolidGradientCenterY = typedArray.getFloat(styleable2.getSolidGradientCenterYStyleable(), 0.5f);
        this.mSolidGradientRadius = typedArray.getDimensionPixelSize(styleable2.getSolidGradientRadiusStyleable(), radius);
        this.mStrokeColor = typedArray.getColor(styleable2.getStrokeColorStyleable(), 0);
        if (typedArray.hasValue(styleable2.getStrokePressedColorStyleable())) {
            this.mStrokePressedColor = typedArray.getColor(styleable2.getStrokePressedColorStyleable(), 0);
        }
        if (styleable2.getStrokeCheckedColorStyleable() > 0 && typedArray.hasValue(styleable2.getStrokeCheckedColorStyleable())) {
            this.mStrokeCheckedColor = typedArray.getColor(styleable2.getStrokeCheckedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeDisabledColorStyleable())) {
            this.mStrokeDisabledColor = typedArray.getColor(styleable2.getStrokeDisabledColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeFocusedColorStyleable())) {
            this.mStrokeFocusedColor = typedArray.getColor(styleable2.getStrokeFocusedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeSelectedColorStyleable())) {
            this.mStrokeSelectedColor = typedArray.getColor(styleable2.getStrokeSelectedColorStyleable(), 0);
        }
        if (typedArray.hasValue(styleable2.getStrokeGradientStartColorStyleable()) && typedArray.hasValue(styleable2.getStrokeGradientEndColorStyleable())) {
            this.mStrokeGradientColors = typedArray.hasValue(styleable2.getStrokeGradientCenterColorStyleable()) ? new int[]{typedArray.getColor(styleable2.getStrokeGradientStartColorStyleable(), 0), typedArray.getColor(styleable2.getStrokeGradientCenterColorStyleable(), 0), typedArray.getColor(styleable2.getStrokeGradientEndColorStyleable(), 0)} : new int[]{typedArray.getColor(styleable2.getStrokeGradientStartColorStyleable(), 0), typedArray.getColor(styleable2.getStrokeGradientEndColorStyleable(), 0)};
        }
        this.mStrokeGradientOrientation = this.transformGradientOrientation(typedArray.getInt(styleable2.getStrokeGradientOrientationStyleable(), this.getDefaultGradientOrientation()));
        this.mStrokeSize = typedArray.getDimensionPixelSize(styleable2.getStrokeSizeStyleable(), 0);
        this.mStrokeDashSize = typedArray.getDimensionPixelSize(styleable2.getStrokeDashSizeStyleable(), 0);
        this.mStrokeDashGap = typedArray.getDimensionPixelSize(styleable2.getStrokeDashGapStyleable(), 0);
        this.mShadowSize = typedArray.getDimensionPixelSize(styleable2.getShadowSizeStyleable(), 0);
        this.mShadowColor = typedArray.getColor(styleable2.getShadowColorStyleable(), 0x10000000);
        this.mShadowOffsetX = typedArray.getDimensionPixelOffset(styleable2.getShadowOffsetXStyleable(), 0);
        this.mShadowOffsetY = typedArray.getDimensionPixelOffset(styleable2.getShadowOffsetYStyleable(), 0);
        this.mRingInnerRadiusSize = typedArray.getDimensionPixelOffset(styleable2.getRingInnerRadiusSizeStyleable(), -1);
        this.mRingInnerRadiusRatio = typedArray.getFloat(styleable2.getRingInnerRadiusRatioStyleable(), 3.0f);
        this.mRingThicknessSize = typedArray.getDimensionPixelOffset(styleable2.getRingThicknessSizeStyleable(), -1);
        this.mRingThicknessRatio = typedArray.getFloat(styleable2.getRingThicknessRatioStyleable(), 9.0f);
        this.mLineGravity = typedArray.getInt(styleable2.getLineGravityStyleable(), 17);
    }

    public ShapeDrawableBuilder setType(int type) {
        this.mType = type;
        return this;
    }

    public int getType() {
        return this.mType;
    }

    public ShapeDrawableBuilder setWidth(int width) {
        this.mWidth = width;
        return this;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public ShapeDrawableBuilder setHeight(int height) {
        this.mHeight = height;
        return this;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public ShapeDrawableBuilder setRadius(float radius) {
        return this.setRadius(radius, radius, radius, radius);
    }

    public ShapeDrawableBuilder setRadius(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        this.mTopLeftRadius = topLeftRadius;
        this.mTopRightRadius = topRightRadius;
        this.mBottomLeftRadius = bottomLeftRadius;
        this.mBottomRightRadius = bottomRightRadius;
        return this;
    }

    public ShapeDrawableBuilder setRadiusRelative(float topStartRadius, float topEndRadius, float bottomStartRadius, float bottomEndRadius) {
        int layoutDirection = this.mView.getLayoutDirection();
        switch (layoutDirection) {
            case 1: {
                this.mTopLeftRadius = topEndRadius;
                this.mTopRightRadius = topStartRadius;
                this.mBottomLeftRadius = bottomEndRadius;
                this.mBottomRightRadius = bottomStartRadius;
                break;
            }
            default: {
                this.mTopLeftRadius = topStartRadius;
                this.mTopRightRadius = topEndRadius;
                this.mBottomLeftRadius = bottomStartRadius;
                this.mBottomRightRadius = bottomEndRadius;
            }
        }
        return this;
    }

    public ShapeDrawableBuilder setTopLeftRadius(float radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    public float getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    public ShapeDrawableBuilder setTopRightRadius(float radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    public float getTopRightRadius() {
        return this.mTopRightRadius;
    }

    public ShapeDrawableBuilder setBottomLeftRadius(float radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    public float getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    public ShapeDrawableBuilder setBottomRightRadius(float radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    public float getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    public ShapeDrawableBuilder setSolidColor(int color) {
        this.mSolidColor = color;
        this.clearSolidGradientColors();
        return this;
    }

    public int getSolidColor() {
        return this.mSolidColor;
    }

    public ShapeDrawableBuilder setSolidPressedColor(Integer color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    public ShapeDrawableBuilder setSolidCheckedColor(Integer color) {
        this.mSolidCheckedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidCheckedColor() {
        return this.mSolidCheckedColor;
    }

    public ShapeDrawableBuilder setSolidDisabledColor(Integer color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    public ShapeDrawableBuilder setSolidFocusedColor(Integer color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    public ShapeDrawableBuilder setSolidSelectedColor(Integer color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Nullable
    public Integer getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    public ShapeDrawableBuilder setSolidGradientColors(int startColor, int endColor) {
        return this.setSolidGradientColors(new int[]{startColor, endColor});
    }

    public ShapeDrawableBuilder setSolidGradientColors(int startColor, int centerColor, int endColor) {
        return this.setSolidGradientColors(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawableBuilder setSolidGradientColors(int[] colors) {
        this.mSolidGradientColors = colors;
        return this;
    }

    @Nullable
    public int[] getSolidGradientColors() {
        return this.mSolidGradientColors;
    }

    public boolean isSolidGradientColorsEnable() {
        return this.mSolidGradientColors != null && this.mSolidGradientColors.length > 0;
    }

    public void clearSolidGradientColors() {
        this.mSolidGradientColors = null;
    }

    public ShapeDrawableBuilder setSolidGradientOrientation(ShapeGradientOrientation orientation) {
        this.mSolidGradientOrientation = orientation;
        return this;
    }

    public ShapeGradientOrientation getSolidGradientOrientation() {
        return this.mSolidGradientOrientation;
    }

    public ShapeDrawableBuilder setSolidGradientType(int type) {
        this.mSolidGradientType = type;
        return this;
    }

    public int getSolidGradientType() {
        return this.mSolidGradientType;
    }

    public ShapeDrawableBuilder setSolidGradientCenterX(float centerX) {
        this.mSolidGradientCenterX = centerX;
        return this;
    }

    public float getSolidGradientCenterX() {
        return this.mSolidGradientCenterX;
    }

    public ShapeDrawableBuilder setSolidGradientCenterY(float centerY) {
        this.mSolidGradientCenterY = centerY;
        return this;
    }

    public float getSolidGradientCenterY() {
        return this.mSolidGradientCenterY;
    }

    public ShapeDrawableBuilder setSolidGradientRadius(int radius) {
        this.mSolidGradientRadius = radius;
        return this;
    }

    public int getSolidGradientRadius() {
        return this.mSolidGradientRadius;
    }

    public ShapeDrawableBuilder setStrokeColor(int color) {
        this.mStrokeColor = color;
        this.clearStrokeGradientColors();
        return this;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public ShapeDrawableBuilder setStrokePressedColor(Integer color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    public ShapeDrawableBuilder setStrokeCheckedColor(Integer color) {
        this.mStrokeCheckedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeCheckedColor() {
        return this.mStrokeCheckedColor;
    }

    public ShapeDrawableBuilder setStrokeDisabledColor(Integer color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    public ShapeDrawableBuilder setStrokeFocusedColor(Integer color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    public ShapeDrawableBuilder setStrokeSelectedColor(Integer color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Nullable
    public Integer getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    public ShapeDrawableBuilder setStrokeGradientColors(int startColor, int endColor) {
        return this.setStrokeGradientColors(new int[]{startColor, endColor});
    }

    public ShapeDrawableBuilder setStrokeGradientColors(int startColor, int centerColor, int endColor) {
        return this.setStrokeGradientColors(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawableBuilder setStrokeGradientColors(int[] colors) {
        this.mStrokeGradientColors = colors;
        return this;
    }

    @Nullable
    public int[] getStrokeGradientColors() {
        return this.mStrokeGradientColors;
    }

    public boolean isStrokeGradientColorsEnable() {
        return this.mStrokeGradientColors != null && this.mStrokeGradientColors.length > 0;
    }

    public void clearStrokeGradientColors() {
        this.mStrokeGradientColors = null;
    }

    public ShapeDrawableBuilder setStrokeGradientOrientation(ShapeGradientOrientation orientation) {
        this.mStrokeGradientOrientation = orientation;
        return this;
    }

    public ShapeGradientOrientation getStrokeGradientOrientation() {
        return this.mStrokeGradientOrientation;
    }

    public ShapeDrawableBuilder setStrokeSize(int size) {
        this.mStrokeSize = size;
        return this;
    }

    public int getStrokeSize() {
        return this.mStrokeSize;
    }

    public ShapeDrawableBuilder setStrokeDashSize(int size) {
        this.mStrokeDashSize = size;
        return this;
    }

    public int getStrokeDashSize() {
        return this.mStrokeDashSize;
    }

    public ShapeDrawableBuilder setStrokeDashGap(int gap) {
        this.mStrokeDashGap = gap;
        return this;
    }

    public int getStrokeDashGap() {
        return this.mStrokeDashGap;
    }

    public boolean isStrokeDashLineEnable() {
        return this.mStrokeDashGap > 0;
    }

    public ShapeDrawableBuilder setRingInnerRadiusSize(int size) {
        this.mRingInnerRadiusSize = size;
        return this;
    }

    public int getRingInnerRadiusSize() {
        return this.mRingInnerRadiusSize;
    }

    public ShapeDrawableBuilder setRingInnerRadiusRatio(float ratio) {
        this.mRingInnerRadiusRatio = ratio;
        return this;
    }

    public float getRingInnerRadiusRatio() {
        return this.mRingInnerRadiusRatio;
    }

    public ShapeDrawableBuilder setRingThicknessSize(int size) {
        this.mRingThicknessSize = size;
        return this;
    }

    public int getRingThicknessSize() {
        return this.mRingThicknessSize;
    }

    public ShapeDrawableBuilder setRingThicknessRatio(float ratio) {
        this.mRingThicknessRatio = ratio;
        return this;
    }

    public float getRingThicknessRatio() {
        return this.mRingThicknessRatio;
    }

    public boolean isShadowEnable() {
        return this.mShadowSize > 0;
    }

    public ShapeDrawableBuilder setShadowSize(int size) {
        this.mShadowSize = size;
        return this;
    }

    public int getShadowSize() {
        return this.mShadowSize;
    }

    public ShapeDrawableBuilder setShadowColor(int color) {
        this.mShadowColor = color;
        return this;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public ShapeDrawableBuilder setShadowOffsetX(int offsetX) {
        this.mShadowOffsetX = offsetX;
        return this;
    }

    public int getShadowOffsetX() {
        return this.mShadowOffsetX;
    }

    public ShapeDrawableBuilder setShadowOffsetY(int offsetY) {
        this.mShadowOffsetY = offsetY;
        return this;
    }

    public int getShadowOffsetY() {
        return this.mShadowOffsetY;
    }

    public int getLineGravity() {
        return this.mLineGravity;
    }

    public ShapeDrawableBuilder setLineGravity(int gravity) {
        this.mLineGravity = gravity;
        return this;
    }

    @Nullable
    public Drawable buildBackgroundDrawable() {
        ShapeDrawable drawable;
        boolean hasStrokeColorState;
        boolean hasSolidColorState = this.mSolidPressedColor != null || this.mSolidCheckedColor != null || this.mSolidDisabledColor != null || this.mSolidFocusedColor != null || this.mSolidSelectedColor != null;
        boolean bl = hasStrokeColorState = this.mStrokePressedColor != null || this.mStrokeCheckedColor != null || this.mStrokeDisabledColor != null || this.mStrokeFocusedColor != null || this.mStrokeSelectedColor != null;
        if (!(this.isSolidGradientColorsEnable() || this.isStrokeGradientColorsEnable() || this.mSolidColor != 0 || hasSolidColorState || this.mStrokeColor != 0 || hasStrokeColorState)) {
            return null;
        }
        Drawable viewBackground = this.mView.getBackground();
        ShapeDrawable defaultDrawable = viewBackground instanceof ExtendStateListDrawable ? this.convertShapeDrawable(((ExtendStateListDrawable)viewBackground).getDefaultDrawable()) : this.convertShapeDrawable(viewBackground);
        this.refreshShapeDrawable(defaultDrawable, null, null);
        if (!hasSolidColorState && !hasStrokeColorState) {
            return defaultDrawable;
        }
        ExtendStateListDrawable stateListDrawable = new ExtendStateListDrawable();
        if (this.mSolidPressedColor != null || this.mStrokePressedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getPressedDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidPressedColor, this.mStrokePressedColor);
            stateListDrawable.setPressedDrawable((Drawable)drawable);
        }
        if (this.mSolidCheckedColor != null || this.mStrokeCheckedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getCheckDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidCheckedColor, this.mStrokeCheckedColor);
            stateListDrawable.setCheckDrawable((Drawable)drawable);
        }
        if (this.mSolidDisabledColor != null || this.mStrokeDisabledColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getDisabledDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidDisabledColor, this.mStrokeDisabledColor);
            stateListDrawable.setDisabledDrawable((Drawable)drawable);
        }
        if (this.mSolidFocusedColor != null || this.mStrokeFocusedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getFocusedDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidFocusedColor, this.mStrokeFocusedColor);
            stateListDrawable.setFocusedDrawable((Drawable)drawable);
        }
        if (this.mSolidSelectedColor != null || this.mStrokeSelectedColor != null) {
            drawable = this.convertShapeDrawable(stateListDrawable.getSelectDrawable());
            this.refreshShapeDrawable(drawable, this.mSolidSelectedColor, this.mStrokeSelectedColor);
            stateListDrawable.setSelectDrawable((Drawable)drawable);
        }
        stateListDrawable.setDefaultDrawable((Drawable)defaultDrawable);
        return stateListDrawable;
    }

    public void refreshShapeDrawable(ShapeDrawable drawable, @Nullable Integer solidStateColor, @Nullable Integer strokeStateColor) {
        drawable.setType(this.mType).setWidth(this.mWidth).setHeight(this.mHeight).setRadius(this.mTopLeftRadius, this.mTopRightRadius, this.mBottomLeftRadius, this.mBottomRightRadius);
        drawable.setSolidGradientType(this.mSolidGradientType).setSolidGradientOrientation(this.mSolidGradientOrientation).setSolidGradientRadius((float)this.mSolidGradientRadius).setSolidGradientCenterX(this.mSolidGradientCenterX).setSolidGradientCenterY(this.mSolidGradientCenterY);
        drawable.setStrokeGradientOrientation(this.mStrokeGradientOrientation).setStrokeSize(this.mStrokeSize).setStrokeDashSize((float)this.mStrokeDashSize).setStrokeDashGap((float)this.mStrokeDashGap);
        drawable.setShadowSize(this.mShadowSize).setShadowColor(this.mShadowColor).setShadowOffsetX(this.mShadowOffsetX).setShadowOffsetY(this.mShadowOffsetY);
        if (this.mRingInnerRadiusRatio > 0.0f) {
            drawable.setRingInnerRadiusRatio(this.mRingInnerRadiusRatio);
        } else if (this.mRingInnerRadiusSize > -1) {
            drawable.setRingInnerRadiusSize(this.mRingInnerRadiusSize);
        }
        if (this.mRingThicknessRatio > 0.0f) {
            drawable.setRingThicknessRatio(this.mRingThicknessRatio);
        } else if (this.mRingThicknessSize > -1) {
            drawable.setRingThicknessSize(this.mRingThicknessSize);
        }
        drawable.setLineGravity(this.mLineGravity);
        if (solidStateColor != null) {
            drawable.setSolidColor(new int[]{solidStateColor});
        } else if (this.isSolidGradientColorsEnable()) {
            drawable.setSolidColor(this.mSolidGradientColors);
        } else {
            drawable.setSolidColor(new int[]{this.mSolidColor});
        }
        if (strokeStateColor != null) {
            drawable.setStrokeColor(new int[]{strokeStateColor});
        } else if (this.isStrokeGradientColorsEnable()) {
            drawable.setStrokeColor(this.mStrokeGradientColors);
        } else {
            drawable.setStrokeColor(new int[]{this.mStrokeColor});
        }
    }

    @NonNull
    public ShapeDrawable convertShapeDrawable(Drawable drawable) {
        if (drawable instanceof ShapeDrawable) {
            return (ShapeDrawable)drawable;
        }
        return new ShapeDrawable();
    }

    public void intoBackground() {
        Drawable drawable = this.buildBackgroundDrawable();
        if (this.isStrokeDashLineEnable() || this.isShadowEnable()) {
            this.mView.setLayerType(1, null);
        }
        if (drawable != null) {
            this.mView.setBackground(drawable);
        }
    }

    public void clearBackground() {
        this.mSolidColor = 0;
        this.mSolidGradientColors = null;
        this.mSolidPressedColor = null;
        this.mSolidCheckedColor = null;
        this.mSolidDisabledColor = null;
        this.mSolidFocusedColor = null;
        this.mSolidSelectedColor = null;
        this.mStrokeColor = 0;
        this.mStrokeGradientColors = null;
        this.mStrokePressedColor = null;
        this.mStrokeCheckedColor = null;
        this.mStrokeDisabledColor = null;
        this.mStrokeFocusedColor = null;
        this.mStrokeSelectedColor = null;
        this.mView.setBackground(null);
    }

    private static int getLayoutDirection(View view) {
        Context context = view.getContext();
        Resources resources = null;
        Configuration configuration = null;
        if (context != null) {
            resources = context.getResources();
        }
        if (resources != null) {
            configuration = resources.getConfiguration();
        }
        int layoutDirection = configuration != null ? configuration.getLayoutDirection() : 0;
        return layoutDirection;
    }

    private int getDefaultGradientOrientation() {
        return 10;
    }

    private ShapeGradientOrientation transformGradientOrientation(int value) {
        switch (value) {
            case 0: {
                return ShapeGradientOrientation.LEFT_TO_RIGHT;
            }
            case 180: {
                return ShapeGradientOrientation.RIGHT_TO_LEFT;
            }
            case 1800: {
                return ShapeGradientOrientation.END_TO_START;
            }
            case 90: {
                return ShapeGradientOrientation.BOTTOM_TO_TOP;
            }
            case 270: {
                return ShapeGradientOrientation.TOP_TO_BOTTOM;
            }
            case 315: {
                return ShapeGradientOrientation.TOP_LEFT_TO_BOTTOM_RIGHT;
            }
            case 3150: {
                return ShapeGradientOrientation.TOP_START_TO_BOTTOM_END;
            }
            case 45: {
                return ShapeGradientOrientation.BOTTOM_LEFT_TO_TOP_RIGHT;
            }
            case 450: {
                return ShapeGradientOrientation.BOTTOM_START_TO_TOP_END;
            }
            case 225: {
                return ShapeGradientOrientation.TOP_RIGHT_TO_BOTTOM_LEFT;
            }
            case 2250: {
                return ShapeGradientOrientation.TOP_END_TO_BOTTOM_START;
            }
            case 135: {
                return ShapeGradientOrientation.BOTTOM_RIGHT_TO_TOP_LEFT;
            }
            case 1350: {
                return ShapeGradientOrientation.BOTTOM_END_TO_TOP_START;
            }
        }
        return ShapeGradientOrientation.START_TO_END;
    }
}

