/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.drawable;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import com.hjq.shape.drawable.ShapeGradientOrientation;

final class ShapeDrawableUtils {
    ShapeDrawableUtils() {
    }

    static void saveCanvasLayer(Canvas canvas, float left, float top, float right, float bottom, @Nullable Paint paint) {
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.saveLayer(left, top, right, bottom, paint);
        } else {
            canvas.saveLayer(left, top, right, bottom, paint, 4);
        }
    }

    static float[] computeLinearGradientCoordinate(int layoutDirection, RectF r, float level, ShapeGradientOrientation orientation) {
        float y1;
        float x1;
        float y0;
        float x0;
        switch (orientation) {
            case START_TO_END: {
                return ShapeDrawableUtils.computeLinearGradientCoordinate(layoutDirection, r, level, layoutDirection == 1 ? ShapeGradientOrientation.RIGHT_TO_LEFT : ShapeGradientOrientation.LEFT_TO_RIGHT);
            }
            case END_TO_START: {
                return ShapeDrawableUtils.computeLinearGradientCoordinate(layoutDirection, r, level, layoutDirection == 1 ? ShapeGradientOrientation.LEFT_TO_RIGHT : ShapeGradientOrientation.RIGHT_TO_LEFT);
            }
            case TOP_START_TO_BOTTOM_END: {
                return ShapeDrawableUtils.computeLinearGradientCoordinate(layoutDirection, r, level, layoutDirection == 1 ? ShapeGradientOrientation.TOP_RIGHT_TO_BOTTOM_LEFT : ShapeGradientOrientation.TOP_LEFT_TO_BOTTOM_RIGHT);
            }
            case TOP_END_TO_BOTTOM_START: {
                return ShapeDrawableUtils.computeLinearGradientCoordinate(layoutDirection, r, level, layoutDirection == 1 ? ShapeGradientOrientation.TOP_LEFT_TO_BOTTOM_RIGHT : ShapeGradientOrientation.TOP_RIGHT_TO_BOTTOM_LEFT);
            }
            case BOTTOM_START_TO_TOP_END: {
                return ShapeDrawableUtils.computeLinearGradientCoordinate(layoutDirection, r, level, layoutDirection == 1 ? ShapeGradientOrientation.BOTTOM_RIGHT_TO_TOP_LEFT : ShapeGradientOrientation.BOTTOM_LEFT_TO_TOP_RIGHT);
            }
            case BOTTOM_END_TO_TOP_START: {
                return ShapeDrawableUtils.computeLinearGradientCoordinate(layoutDirection, r, level, layoutDirection == 1 ? ShapeGradientOrientation.BOTTOM_LEFT_TO_TOP_RIGHT : ShapeGradientOrientation.BOTTOM_RIGHT_TO_TOP_LEFT);
            }
            case TOP_TO_BOTTOM: {
                x0 = r.left;
                y0 = r.top;
                x1 = x0;
                y1 = level * r.bottom;
                break;
            }
            case TOP_RIGHT_TO_BOTTOM_LEFT: {
                x0 = r.right;
                y0 = r.top;
                x1 = level * r.left;
                y1 = level * r.bottom;
                break;
            }
            case RIGHT_TO_LEFT: {
                x0 = r.right;
                y0 = r.top;
                x1 = level * r.left;
                y1 = y0;
                break;
            }
            case BOTTOM_RIGHT_TO_TOP_LEFT: {
                x0 = r.right;
                y0 = r.bottom;
                x1 = level * r.left;
                y1 = level * r.top;
                break;
            }
            case BOTTOM_TO_TOP: {
                x0 = r.left;
                y0 = r.bottom;
                x1 = x0;
                y1 = level * r.top;
                break;
            }
            case BOTTOM_LEFT_TO_TOP_RIGHT: {
                x0 = r.left;
                y0 = r.bottom;
                x1 = level * r.right;
                y1 = level * r.top;
                break;
            }
            case LEFT_TO_RIGHT: {
                x0 = r.left;
                y0 = r.top;
                x1 = level * r.right;
                y1 = y0;
                break;
            }
            default: {
                x0 = r.left;
                y0 = r.top;
                x1 = level * r.right;
                y1 = level * r.bottom;
            }
        }
        return new float[]{x0, y0, x1, y1};
    }

    @ColorInt
    public static int setColorAlphaComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return color & 0xFFFFFF | alpha << 24;
    }
}

