/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.language;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import com.hjq.language.ActivityLanguages;
import com.hjq.language.LanguagesConfig;
import com.hjq.language.LanguagesObserver;
import com.hjq.language.LanguagesUtils;
import com.hjq.language.OnLanguageListener;
import java.util.Locale;

public final class MultiLanguages {
    private static Application sApplication;
    private static OnLanguageListener sLanguageListener;

    public static void init(Application application) {
        MultiLanguages.init(application, true);
    }

    public static void init(Application application, boolean inject) {
        sApplication = application;
        LanguagesObserver.register(application);
        LanguagesUtils.setDefaultLocale((Context)application);
        if (inject) {
            ActivityLanguages.inject(application);
        }
    }

    public static Context attach(Context context) {
        if (LanguagesUtils.getLocale(context).equals(LanguagesConfig.getAppLanguage(context))) {
            return context;
        }
        return LanguagesUtils.attachLanguages(context, LanguagesConfig.getAppLanguage(context));
    }

    public static void updateAppLanguage(Context context) {
        MultiLanguages.updateAppLanguage(context.getResources());
    }

    public static void updateAppLanguage(Resources resources) {
        if (resources == null) {
            return;
        }
        if (LanguagesUtils.getLocale(resources.getConfiguration()).equals(MultiLanguages.getAppLanguage())) {
            return;
        }
        LanguagesUtils.updateLanguages(resources, MultiLanguages.getAppLanguage());
    }

    public static Locale getAppLanguage() {
        return LanguagesConfig.getAppLanguage((Context)sApplication);
    }

    public static boolean setAppLanguage(Context context, Locale newLocale) {
        LanguagesConfig.setAppLanguage(context, newLocale);
        if (LanguagesUtils.getLocale(context).equals(newLocale)) {
            return false;
        }
        Locale oldLocale = LanguagesUtils.getLocale(context);
        LanguagesUtils.updateLanguages(context.getResources(), newLocale);
        if (context != sApplication) {
            LanguagesUtils.updateLanguages(sApplication.getResources(), newLocale);
        }
        LanguagesUtils.setDefaultLocale(context);
        if (sLanguageListener != null) {
            sLanguageListener.onAppLocaleChange(oldLocale, newLocale);
        }
        return true;
    }

    public static Locale getSystemLanguage() {
        return LanguagesObserver.getSystemLanguage();
    }

    public static boolean clearAppLanguage(Context context) {
        LanguagesConfig.clearLanguage(context);
        if (LanguagesUtils.getLocale(context).equals(MultiLanguages.getSystemLanguage())) {
            return false;
        }
        LanguagesUtils.updateLanguages(context.getResources(), MultiLanguages.getSystemLanguage());
        LanguagesUtils.setDefaultLocale(context);
        if (context != sApplication) {
            LanguagesUtils.updateLanguages(sApplication.getResources(), MultiLanguages.getSystemLanguage());
        }
        return true;
    }

    public static boolean isSystemLanguage() {
        return LanguagesConfig.isSystemLanguage((Context)sApplication);
    }

    public static boolean equalsLanguage(Locale locale1, Locale locale2) {
        return locale1.getLanguage().equals(locale2.getLanguage());
    }

    public static boolean equalsCountry(Locale locale1, Locale locale2) {
        return MultiLanguages.equalsLanguage(locale1, locale2) && locale1.getCountry().equals(locale2.getCountry());
    }

    public static String getLanguageString(Context context, Locale locale, int id) {
        return MultiLanguages.getLanguageResources(context, locale).getString(id);
    }

    public static Resources getLanguageResources(Context context, Locale locale) {
        return LanguagesUtils.getLanguageResources(context, locale);
    }

    public static void setOnLanguageListener(OnLanguageListener listener) {
        sLanguageListener = listener;
    }

    public static void setSharedPreferencesName(String name) {
        LanguagesConfig.setSharedPreferencesName(name);
    }

    static OnLanguageListener getOnLanguagesListener() {
        return sLanguageListener;
    }

    static Application getApplication() {
        return sApplication;
    }
}

