/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.language;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import com.hjq.language.LanguagesConfig;
import java.util.Locale;

final class LanguagesUtils {
    LanguagesUtils() {
    }

    static Locale getLocale(Context context) {
        return LanguagesUtils.getLocale(context.getResources().getConfiguration());
    }

    static Locale getLocale(Configuration config) {
        if (Build.VERSION.SDK_INT >= 24) {
            return config.getLocales().get(0);
        }
        return config.locale;
    }

    static void setLocale(Configuration config, Locale locale) {
        if (Build.VERSION.SDK_INT >= 17) {
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleList localeList = new LocaleList(new Locale[]{locale});
                config.setLocales(localeList);
            } else {
                config.setLocale(locale);
            }
        } else {
            config.locale = locale;
        }
    }

    static void setDefaultLocale(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList.setDefault((LocaleList)configuration.getLocales());
        } else {
            Locale.setDefault(configuration.locale);
        }
    }

    static Context attachLanguages(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration config = new Configuration(resources.getConfiguration());
        LanguagesUtils.setLocale(config, locale);
        if (Build.VERSION.SDK_INT >= 17) {
            context = context.createConfigurationContext(config);
        }
        resources.updateConfiguration(config, resources.getDisplayMetrics());
        return context;
    }

    static void updateLanguages(Resources resources, Locale locale) {
        Configuration config = resources.getConfiguration();
        LanguagesUtils.setLocale(config, locale);
        resources.updateConfiguration(config, resources.getDisplayMetrics());
    }

    static void updateConfigurationChanged(Context context, Configuration newConfig) {
        Configuration config = new Configuration(newConfig);
        LanguagesUtils.setLocale(config, LanguagesConfig.getAppLanguage(context));
        Resources resources = context.getResources();
        resources.updateConfiguration(config, resources.getDisplayMetrics());
    }

    static Resources getLanguageResources(Context context, Locale locale) {
        Configuration config = new Configuration();
        LanguagesUtils.setLocale(config, locale);
        if (Build.VERSION.SDK_INT >= 17) {
            return context.createConfigurationContext(config).getResources();
        }
        return new Resources(context.getAssets(), context.getResources().getDisplayMetrics(), config);
    }
}

