/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.language;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.hjq.language.LanguagesUtils;
import com.hjq.language.MultiLanguages;
import java.util.Locale;

final class LanguagesConfig {
    private static final String KEY_LANGUAGE = "key_language";
    private static final String KEY_COUNTRY = "key_country";
    private static String sSharedPreferencesName = "language_setting";
    private static volatile Locale sCurrentLanguage;

    LanguagesConfig() {
    }

    static void setSharedPreferencesName(String name) {
        sSharedPreferencesName = name;
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(sSharedPreferencesName, 0);
    }

    static void setAppLanguage(Context context, Locale locale) {
        sCurrentLanguage = locale;
        LanguagesConfig.getSharedPreferences(context).edit().putString(KEY_LANGUAGE, locale.getLanguage()).putString(KEY_COUNTRY, locale.getCountry()).apply();
    }

    static Locale getAppLanguage(Context context) {
        if (sCurrentLanguage == null) {
            String language = LanguagesConfig.getSharedPreferences(context).getString(KEY_LANGUAGE, null);
            String country = LanguagesConfig.getSharedPreferences(context).getString(KEY_COUNTRY, null);
            sCurrentLanguage = !TextUtils.isEmpty((CharSequence)language) ? new Locale(language, country) : LanguagesUtils.getLocale(context);
        }
        return sCurrentLanguage;
    }

    public static boolean isSystemLanguage(Context context) {
        String language = LanguagesConfig.getSharedPreferences(context).getString(KEY_LANGUAGE, null);
        return language == null || "".equals(language);
    }

    static void clearLanguage(Context context) {
        sCurrentLanguage = MultiLanguages.getSystemLanguage();
        LanguagesConfig.getSharedPreferences(context).edit().remove(KEY_LANGUAGE).remove(KEY_COUNTRY).apply();
    }
}

