/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Application;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import android.widget.Toast;
import com.hjq.logcat.ForegroundServiceStartTask;
import com.hjq.logcat.LogcatConfig;
import com.hjq.logcat.LogcatGlobalDispatcher;
import com.hjq.logcat.LogcatLocalDispatcher;
import com.hjq.logcat.LogcatUtils;
import com.hjq.logcat.R;

public final class LogcatProvider
extends ContentProvider {
    public boolean onCreate() {
        Context context = this.getContext();
        if (context != null) {
            LogcatConfig.init(context.getApplicationContext());
            Boolean notifyEntrance = LogcatUtils.getMetaBooleanData(context, "LogcatNotifyEntrance");
            Boolean windowEntrance = LogcatUtils.getMetaBooleanData(context, "LogcatWindowEntrance");
            if (notifyEntrance == null && windowEntrance == null) {
                if (this.isNotificationChannelEnabled(context)) {
                    notifyEntrance = true;
                } else {
                    windowEntrance = true;
                }
            }
            if (context instanceof Application) {
                if (notifyEntrance != null && notifyEntrance.booleanValue()) {
                    ForegroundServiceStartTask.with((Application)context);
                }
                if (windowEntrance != null && windowEntrance.booleanValue()) {
                    if (Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)context)) {
                        LogcatGlobalDispatcher.launch((Application)context);
                    } else {
                        LogcatLocalDispatcher.launch((Application)context);
                    }
                }
            } else {
                Toast.makeText((Context)context, (int)R.string.logcat_launch_error, (int)1).show();
            }
        }
        return true;
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(@NonNull Uri uri) {
        return null;
    }

    public Uri insert(@NonNull Uri uri, ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private boolean isNotificationChannelEnabled(Context context) {
        if (!NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        NotificationChannel channel = manager.getNotificationChannel("logcat");
        if (channel == null) {
            return true;
        }
        return channel.getImportance() != 0;
    }
}

