/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.logcat.ChooseWindow;
import com.hjq.logcat.LogcatAdapter;
import com.hjq.logcat.LogcatConfig;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatManager;
import com.hjq.logcat.LogcatUtils;
import com.hjq.logcat.R;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LogcatActivity
extends AppCompatActivity
implements TextWatcher,
View.OnLongClickListener,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener,
LogcatManager.Callback,
LogcatAdapter.OnItemLongClickListener,
LogcatAdapter.OnItemClickListener {
    private static final String[] ARRAY_LOG_LEVEL = new String[]{"Verbose", "Debug", "Info", "Warn", "Error"};
    private static final String[] ARRAY_LOG_LEVEL_PORTRAIT = new String[]{"V", "D", "I", "W", "E"};
    private View mRootView;
    private View mBarView;
    private CheckBox mCheckBox;
    private View mSaveView;
    private ViewGroup mLevelLayout;
    private TextView mLevelView;
    private EditText mSearchView;
    private ImageView mIconView;
    private View mClearView;
    private View mHideView;
    private RecyclerView mRecyclerView;
    private View mDownView;
    private LinearLayoutManager mLinearLayoutManager;
    private LogcatAdapter mAdapter;
    private String mLogLevel = "V";
    private boolean mPauseLogFlag;
    private final List<String> mTagFilter = new ArrayList<String>();
    private final List<String> mSearchKeyword = new ArrayList<String>();
    private boolean mGrantedReadLogPermission;
    private final Runnable mSearchRunnable = () -> {
        String keyword = this.mSearchView.getText().toString();
        LogcatConfig.setSearchKeyConfig(keyword);
        this.mAdapter.setKeyword(keyword);
        this.mLinearLayoutManager.scrollToPosition(this.mAdapter.getItemCount() - 1);
        if (!keyword.isEmpty()) {
            this.mIconView.setVisibility(0);
            this.mIconView.setImageResource(R.drawable.logcat_ic_empty);
            return;
        }
        if (!this.mSearchKeyword.isEmpty()) {
            this.mIconView.setVisibility(0);
            this.mIconView.setImageResource(R.drawable.logcat_ic_history);
        } else {
            this.mIconView.setVisibility(8);
        }
    };
    private final Runnable mSearchKeywordRunnable = () -> {
        String keyword = this.mSearchView.getText().toString();
        if (keyword.isEmpty()) {
            return;
        }
        if (this.mSearchKeyword.contains(keyword)) {
            return;
        }
        this.mSearchKeyword.add(0, keyword);
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.logcat_activity_logcat);
        this.mRootView = this.findViewById(R.id.ll_log_root);
        this.mBarView = this.findViewById(R.id.ll_log_bar);
        this.mCheckBox = (CheckBox)this.findViewById(R.id.cb_log_switch);
        this.mSaveView = this.findViewById(R.id.iv_log_save);
        this.mLevelLayout = (ViewGroup)this.findViewById(R.id.ll_log_level);
        this.mLevelView = (TextView)this.findViewById(R.id.tv_log_level);
        this.mSearchView = (EditText)this.findViewById(R.id.et_log_search_input);
        this.mIconView = (ImageView)this.findViewById(R.id.iv_log_search_icon);
        this.mClearView = this.findViewById(R.id.iv_log_logcat_clear);
        this.mHideView = this.findViewById(R.id.iv_log_logcat_hide);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.lv_log_logcat_list);
        this.mDownView = this.findViewById(R.id.ib_log_logcat_down);
        this.mAdapter = new LogcatAdapter((Context)this);
        this.mAdapter.setOnItemClickListener(this);
        this.mAdapter.setOnItemLongClickListener(this);
        this.mLinearLayoutManager = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        this.mRecyclerView.setAnimation(null);
        this.mCheckBox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mSearchView.addTextChangedListener((TextWatcher)this);
        this.mSaveView.setOnClickListener((View.OnClickListener)this);
        this.mLevelLayout.setOnClickListener((View.OnClickListener)this);
        this.mIconView.setOnClickListener((View.OnClickListener)this);
        this.mClearView.setOnClickListener((View.OnClickListener)this);
        this.mHideView.setOnClickListener((View.OnClickListener)this);
        this.mDownView.setOnClickListener((View.OnClickListener)this);
        this.mSaveView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mCheckBox.setOnLongClickListener((View.OnLongClickListener)this);
        this.mLevelLayout.setOnLongClickListener((View.OnLongClickListener)this);
        this.mClearView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mHideView.setOnLongClickListener((View.OnLongClickListener)this);
        boolean bl = this.mGrantedReadLogPermission = Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.READ_LOGS") == 0;
        if (Build.VERSION.SDK_INT >= 30 || this.mGrantedReadLogPermission && Build.VERSION.SDK_INT >= 24) {
            LogcatManager.setCanObtainUid(true);
        }
        LogcatManager.setCallback(this);
        LogcatManager.start();
        this.initLogFilter();
        this.initSearchCondition();
        this.refreshLayout();
        long delayMillis = Build.VERSION.SDK_INT >= 31 ? 500L : (Build.VERSION.SDK_INT >= 29 ? 800L : (Build.VERSION.SDK_INT >= 23 ? 1000L : 1200L));
        this.mRecyclerView.postDelayed(() -> this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter), delayMillis);
        this.mRecyclerView.postDelayed(() -> this.mLinearLayoutManager.scrollToPosition(this.mAdapter.getItemCount() - 1), 1200L);
    }

    private void initSearchCondition() {
        String searchKey = LogcatConfig.getSearchKeyConfig();
        if (searchKey != null && !searchKey.isEmpty()) {
            this.mSearchView.setText((CharSequence)searchKey);
        }
        String logLevel = LogcatConfig.getLogLevelConfig();
        this.setLogLevel(logLevel);
    }

    @Override
    public void onReceiveLog(LogcatInfo info) {
        if (!this.mGrantedReadLogPermission) {
            try {
                int uid;
                String uidString = info.getUid();
                if (uidString != null && !uidString.isEmpty() && (uid = Integer.parseInt(uidString)) != Process.myUid()) {
                    return;
                }
            }
            catch (NumberFormatException uidString) {
                // empty catch block
            }
        }
        if (this.mTagFilter.contains(info.getTag())) {
            return;
        }
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        if (adapter == null) {
            this.mAdapter.addItem(info);
        } else {
            this.mRecyclerView.post((Runnable)new LogRunnable(info));
        }
    }

    public boolean onLongClick(View v) {
        if (v == this.mCheckBox) {
            LogcatUtils.toast((Activity)this, R.string.logcat_capture);
        } else if (v == this.mSaveView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_save);
        } else if (v == this.mLevelView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_level);
        } else if (v == this.mClearView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_empty);
        } else if (v == this.mHideView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_close);
        }
        return true;
    }

    public void onClick(View v) {
        if (v == this.mSaveView) {
            try {
                File file = LogcatUtils.saveLogToFile((Context)this, this.mAdapter.getShowData());
                LogcatUtils.toast((Activity)this, this.getResources().getString(R.string.logcat_save_succeed) + file.getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                LogcatUtils.toast((Activity)this, this.getResources().getString(R.string.logcat_save_fail));
            }
        } else if (v == this.mLevelLayout) {
            new ChooseWindow((Activity)this).setList(ARRAY_LOG_LEVEL).setListener(position -> {
                switch (position) {
                    case 0: {
                        this.setLogLevel("V");
                        break;
                    }
                    case 1: {
                        this.setLogLevel("D");
                        break;
                    }
                    case 2: {
                        this.setLogLevel("I");
                        break;
                    }
                    case 3: {
                        this.setLogLevel("W");
                        break;
                    }
                    case 4: {
                        this.setLogLevel("E");
                        break;
                    }
                }
            }).show();
        } else if (v == this.mIconView) {
            String keyword = this.mSearchView.getText().toString();
            if (keyword.isEmpty()) {
                this.showSearchKeyword();
            } else {
                this.mSearchView.setText((CharSequence)"");
            }
        } else if (v == this.mClearView) {
            LogcatManager.clear();
            this.mAdapter.clearData();
        } else if (v == this.mHideView) {
            this.onBackPressed();
        } else if (v == this.mDownView) {
            this.mLinearLayoutManager.scrollToPosition(this.mAdapter.getItemCount() - 1);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            LogcatUtils.toast((Activity)this, R.string.logcat_capture_pause);
            LogcatManager.pause();
            this.mPauseLogFlag = true;
        } else {
            LogcatManager.resume();
            this.mPauseLogFlag = false;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.mSearchView.removeCallbacks(this.mSearchRunnable);
        this.mSearchView.postDelayed(this.mSearchRunnable, 500L);
        this.mSearchView.removeCallbacks(this.mSearchKeywordRunnable);
        this.mSearchView.postDelayed(this.mSearchKeywordRunnable, 3000L);
    }

    @Override
    public void onItemClick(LogcatInfo info, int position) {
        this.mAdapter.onItemClick(position);
    }

    @Override
    public boolean onItemLongClick(LogcatInfo info, int position) {
        new ChooseWindow((Activity)this).setList(R.string.logcat_options_copy, R.string.logcat_options_share, R.string.logcat_options_delete, R.string.logcat_options_shield).setListener(location -> {
            switch (location) {
                case 0: {
                    this.copyLog(position);
                    break;
                }
                case 1: {
                    this.shareLog(position);
                    break;
                }
                case 2: {
                    this.mAdapter.removeItem(position);
                    break;
                }
                case 3: {
                    this.addFilter(this.mAdapter.getItem(position).getTag());
                    break;
                }
            }
        }).show();
        return true;
    }

    private void copyLog(int position) {
        ClipboardManager manager = (ClipboardManager)this.getSystemService("clipboard");
        if (manager != null) {
            manager.setPrimaryClip(ClipData.newPlainText((CharSequence)"log", (CharSequence)this.mAdapter.getItem(position).getContent()));
            LogcatUtils.toast((Activity)this, R.string.logcat_copy_succeed);
        } else {
            LogcatUtils.toast((Activity)this, R.string.logcat_copy_fail);
        }
    }

    private void shareLog(int position) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", this.mAdapter.getItem(position).getContent());
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getResources().getString(R.string.logcat_options_share)));
    }

    private void setLogLevel(String level) {
        if (level.equalsIgnoreCase(this.mLogLevel)) {
            this.refreshLogLevelLayout();
            return;
        }
        this.mLogLevel = level;
        this.mAdapter.setLogLevel(level);
        LogcatConfig.setLogLevelConfig(level);
        this.afterTextChanged(this.mSearchView.getText());
        this.refreshLogLevelLayout();
    }

    private void refreshLogLevelLayout() {
        String[] arrayLogLevel = LogcatUtils.isPortrait((Context)this) ? ARRAY_LOG_LEVEL_PORTRAIT : ARRAY_LOG_LEVEL;
        switch (this.mLogLevel) {
            case "V": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[0]);
                break;
            }
            case "D": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[1]);
                break;
            }
            case "I": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[2]);
                break;
            }
            case "W": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[3]);
                break;
            }
            case "E": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[4]);
                break;
            }
        }
    }

    private void initLogFilter() {
        String[] list;
        try {
            this.mTagFilter.addAll(LogcatUtils.readTagFilter((Context)this));
        }
        catch (IOException e) {
            e.printStackTrace();
            LogcatUtils.toast((Activity)this, R.string.logcat_read_config_fail);
        }
        for (String tag : list = this.getResources().getStringArray(R.array.logcat_filter_list)) {
            if (tag == null || tag.isEmpty() || this.mTagFilter.contains(tag)) continue;
            this.mTagFilter.add(tag);
        }
    }

    private void addFilter(String tag) {
        if ("".equals(tag)) {
            return;
        }
        if (this.mTagFilter.contains(tag)) {
            return;
        }
        this.mTagFilter.add(tag);
        try {
            ArrayList<String> newTagFilter = new ArrayList<String>(this.mTagFilter);
            newTagFilter.removeAll(Arrays.asList(this.getResources().getStringArray(R.array.logcat_filter_list)));
            File file = LogcatUtils.writeTagFilter((Context)this, newTagFilter);
            LogcatUtils.toast((Activity)this, this.getResources().getString(R.string.logcat_shield_succeed) + file.getPath());
            List<LogcatInfo> data = this.mAdapter.getShowData();
            for (int i = 0; i < data.size(); ++i) {
                LogcatInfo info = data.get(i);
                if (!info.getTag().equals(tag)) continue;
                this.mAdapter.removeItem(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LogcatUtils.toast((Activity)this, R.string.logcat_shield_fail);
        }
    }

    public void onBackPressed() {
        this.mSearchView.clearFocus();
        this.moveTaskToBack(false);
    }

    protected void onResume() {
        super.onResume();
        if (this.mPauseLogFlag) {
            return;
        }
        LogcatManager.resume();
    }

    protected void onPause() {
        super.onPause();
        if (this.mPauseLogFlag) {
            return;
        }
        LogcatManager.pause();
    }

    protected void onDestroy() {
        super.onDestroy();
        LogcatManager.destroy();
        this.mSearchView.removeCallbacks(this.mSearchRunnable);
        this.mSearchView.removeCallbacks(this.mSearchKeywordRunnable);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.refreshLogLevelLayout();
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void showSearchKeyword() {
        if (this.mSearchKeyword.isEmpty()) {
            return;
        }
        new ChooseWindow((Activity)this).setList(this.mSearchKeyword).setListener(position -> {
            this.mSearchView.setText((CharSequence)this.mSearchKeyword.get(position));
            this.mSearchView.setSelection(this.mSearchView.getText().toString().length());
        }).show();
    }

    private void refreshLayout() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.addFlags(0x4000000);
        this.mBarView.setPadding(0, 0, 0, 0);
        this.mRootView.setPadding(0, 0, 0, 0);
        if (LogcatUtils.isPortrait((Context)this)) {
            window.clearFlags(1024);
            if (Build.VERSION.SDK_INT >= 23) {
                window.getDecorView().setSystemUiVisibility(0);
            }
            if (Build.VERSION.SDK_INT >= 28) {
                WindowManager.LayoutParams params = window.getAttributes();
                params.layoutInDisplayCutoutMode = 1;
                window.setAttributes(params);
            }
            this.mBarView.setPadding(0, LogcatUtils.getStatusBarHeight((Context)this), 0, 0);
            return;
        }
        window.addFlags(1024);
        this.mBarView.setPadding((int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), 0, (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), 0);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.layoutInDisplayCutoutMode = 2;
            window.setAttributes(params);
            return;
        }
        if (LogcatUtils.isActivityReverse((Activity)this)) {
            this.mRootView.setPadding(0, 0, LogcatUtils.getStatusBarHeight((Context)this), 0);
        } else {
            this.mRootView.setPadding(LogcatUtils.getStatusBarHeight((Context)this), 0, 0, 0);
        }
    }

    private class LogRunnable
    implements Runnable {
        private final LogcatInfo info;

        private LogRunnable(LogcatInfo info) {
            this.info = info;
        }

        @Override
        public void run() {
            LogcatActivity.this.mAdapter.addItem(this.info);
        }
    }
}

