/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class FloatTypeAdapter
extends TypeAdapter<Float> {
    public Float read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NUMBER: {
                return Float.valueOf((float)in.nextDouble());
            }
            case STRING: {
                String result = in.nextString();
                if (result == null || "".equals(result)) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(Float.parseFloat(result));
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        throw new IllegalArgumentException("The current parser is of type Float, but the data is of type " + jsonToken);
    }

    public void write(JsonWriter out, Float value) throws IOException {
        out.value((Number)value);
    }
}

